/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.guice.PropertiesModule;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.initialization.ServerInjectorBuilderTest;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.StatusResource;
import org.junit.Assert;
import org.junit.Test;

public class StatusResourceTest {
    @Test
    public void testLoadedModules() {
        ImmutableList modules = ImmutableList.of((Object)new ServerInjectorBuilderTest.TestDruidModule());
        List statusResourceModuleList = new StatusResource.Status((Collection)modules).getModules();
        Assert.assertEquals((String)"Status should have all modules loaded!", (long)modules.size(), (long)statusResourceModuleList.size());
        for (DruidModule module : modules) {
            String moduleName = module.getClass().getName();
            boolean contains = Boolean.FALSE;
            for (StatusResource.ModuleVersion version : statusResourceModuleList) {
                if (!version.getName().equals(moduleName)) continue;
                contains = Boolean.TRUE;
                break;
            }
            Assert.assertTrue((String)("Status resource should contain module " + moduleName), (boolean)contains);
        }
    }

    @Test
    public void testHiddenProperties() throws Exception {
        this.testHiddenPropertiesWithPropertyFileName("status.resource.test.runtime.properties");
    }

    @Test
    public void testHiddenPropertiesContain() throws Exception {
        this.testHiddenPropertiesWithPropertyFileName("status.resource.test.runtime.hpc.properties");
    }

    private void testHiddenPropertiesWithPropertyFileName(String fileName) throws Exception {
        Injector injector = ((StartupInjectorBuilder)new StartupInjectorBuilder().add(new Module[]{new PropertiesModule(Collections.singletonList(fileName))})).build();
        Map returnedProperties = ((StatusResource)injector.getInstance(StatusResource.class)).getProperties();
        Set lowerCasePropertyNames = returnedProperties.keySet().stream().map(StringUtils::toLowerCase).collect(Collectors.toSet());
        Assert.assertTrue((String)"The list of unfiltered Properties is not > the list of filtered Properties?!?", (((Properties)injector.getInstance(Properties.class)).stringPropertyNames().size() > returnedProperties.size() ? 1 : 0) != 0);
        Set hiddenProperties = (Set)new ObjectMapper().readValue((String)returnedProperties.get("druid.server.hiddenProperties"), (TypeReference)new TypeReference<Set<String>>(){});
        hiddenProperties.forEach(property -> lowerCasePropertyNames.forEach(lowerCasePropertyName -> Assert.assertFalse((boolean)lowerCasePropertyName.contains(StringUtils.toLowerCase((String)property)))));
    }
}

