/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.client.SegmentServerSelector;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.ReferenceCountingSegmentQueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.server.EtagProvider;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class TestClusterQuerySegmentWalker
implements QuerySegmentWalker {
    private final Map<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>> timelines;
    private final QueryRunnerFactoryConglomerate conglomerate;
    @Nullable
    private final QueryScheduler scheduler;
    private final EtagProvider etagProvider;

    @Inject
    TestClusterQuerySegmentWalker(TestSegmentsBroker testSegmentsBroker, QueryRunnerFactoryConglomerate conglomerate, @Nullable QueryScheduler scheduler, EtagProvider etagProvider) {
        this(testSegmentsBroker.timelines, conglomerate, scheduler, etagProvider);
    }

    TestClusterQuerySegmentWalker(Map<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>> timelines, QueryRunnerFactoryConglomerate conglomerate, @Nullable QueryScheduler scheduler, EtagProvider etagProvider) {
        this.timelines = timelines;
        this.conglomerate = conglomerate;
        this.scheduler = scheduler;
        this.etagProvider = etagProvider;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return (queryPlus, responseContext) -> {
            DataSourceAnalysis analysis = queryPlus.getQuery().getDataSource().getAnalysis();
            if (!analysis.isConcreteAndTableBased()) {
                throw new ISE("Cannot handle datasource: %s", new Object[]{queryPlus.getQuery().getDataSource()});
            }
            String dataSourceName = analysis.getBaseTableDataSource().getName();
            FunctionalIterable segmentDescriptors = FunctionalIterable.create((Iterable)intervals).transformCat(interval -> this.getSegmentsForTable(dataSourceName, (Interval)interval)).transform(WindowedSegment::getDescriptor);
            return this.getQueryRunnerForSegments(queryPlus.getQuery(), (Iterable<SegmentDescriptor>)segmentDescriptors).run(queryPlus, responseContext);
        };
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        DataSource dataSourceFromQuery = query.getDataSource();
        QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            throw new ISE("Unknown query type[%s].", new Object[]{query.getClass()});
        }
        DataSourceAnalysis analysis = dataSourceFromQuery.getAnalysis();
        if (!analysis.isConcreteAndTableBased()) {
            throw new ISE("Cannot handle datasource: %s", new Object[]{dataSourceFromQuery});
        }
        String dataSourceName = analysis.getBaseTableDataSource().getName();
        QueryToolChest toolChest = factory.getToolchest();
        if (dataSourceFromQuery instanceof QueryDataSource && !toolChest.canPerformSubquery(((QueryDataSource)dataSourceFromQuery).getQuery())) {
            throw new ISE("Cannot handle subquery: %s", new Object[]{dataSourceFromQuery});
        }
        Function segmentMapFn = dataSourceFromQuery.createSegmentMapFunction(query);
        FinalizeResultsQueryRunner baseRunner = new FinalizeResultsQueryRunner(toolChest.postMergeQueryDecoration(toolChest.mergeResults(toolChest.preMergeQueryDecoration((queryPlus, responseContext) -> this.makeTableRunner(toolChest, factory, this.getSegmentsForTable(dataSourceName, specs), segmentMapFn).run(GroupByQueryRunnerTestHelper.populateResourceId((QueryPlus)queryPlus), responseContext)), false)), toolChest);
        return (arg_0, arg_1) -> this.lambda$getQueryRunnerForSegments$5(specs, (QueryRunner)baseRunner, arg_0, arg_1);
    }

    private <T> QueryRunner<T> makeTableRunner(QueryToolChest<T, Query<T>> toolChest, QueryRunnerFactory<T, Query<T>> factory, Iterable<WindowedSegment> segments, Function<SegmentReference, SegmentReference> segmentMapFn) {
        ArrayList segmentsList = Lists.newArrayList(segments);
        if (segmentsList.isEmpty()) {
            return new NoopQueryRunner();
        }
        return new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)FunctionalIterable.create((Iterable)segmentsList).transform(segment -> new SpecificSegmentQueryRunner((QueryRunner)new ReferenceCountingSegmentQueryRunner(factory, (SegmentReference)segmentMapFn.apply((SegmentReference)segment.getSegment()), segment.getDescriptor()), new SpecificSegmentSpec(segment.getDescriptor())))), true), toolChest);
    }

    private List<WindowedSegment> getSegmentsForTable(String dataSource, Interval interval) {
        VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.timelines.get(dataSource);
        if (timeline == null) {
            return Collections.emptyList();
        }
        ArrayList<WindowedSegment> retVal = new ArrayList<WindowedSegment>();
        for (TimelineObjectHolder holder : timeline.lookup(interval)) {
            for (PartitionChunk chunk : holder.getObject()) {
                retVal.add(new WindowedSegment((ReferenceCountingSegment)chunk.getObject(), holder.getInterval()));
            }
        }
        return retVal;
    }

    private List<WindowedSegment> getSegmentsForTable(String dataSource, Iterable<SegmentDescriptor> specs) {
        VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.timelines.get(dataSource);
        if (timeline == null) {
            return Collections.emptyList();
        }
        ArrayList<WindowedSegment> retVal = new ArrayList<WindowedSegment>();
        for (SegmentDescriptor spec : specs) {
            PartitionChunk entry = timeline.findChunk(spec.getInterval(), (Object)spec.getVersion(), spec.getPartitionNumber());
            retVal.add(new WindowedSegment((ReferenceCountingSegment)entry.getObject(), spec.getInterval()));
        }
        return retVal;
    }

    private /* synthetic */ Sequence lambda$getQueryRunnerForSegments$5(Iterable specs, QueryRunner baseRunner, QueryPlus theQuery, ResponseContext responseContext) {
        QueryPlus newQuery = GroupByQueryRunnerTestHelper.populateResourceId((QueryPlus)theQuery);
        responseContext.initializeRemainingResponses();
        String etag = this.etagProvider.getEtagFor(newQuery.getQuery());
        if (etag != null) {
            responseContext.put(ResponseContext.Keys.ETAG, (Object)etag);
        }
        responseContext.addRemainingResponse(newQuery.getQuery().getMostSpecificId(), 0);
        if (this.scheduler != null) {
            HashSet segments = new HashSet();
            specs.forEach(spec -> segments.add(new SegmentServerSelector(spec)));
            return this.scheduler.run(this.scheduler.prioritizeAndLaneQuery(newQuery, segments), (Sequence)new LazySequence(() -> baseRunner.run(newQuery.withQuery(Queries.withSpecificSegments((Query)newQuery.getQuery(), (List)ImmutableList.copyOf((Iterable)specs))), responseContext)));
        }
        return baseRunner.run(newQuery.withQuery(Queries.withSpecificSegments((Query)newQuery.getQuery(), (List)ImmutableList.copyOf((Iterable)specs))), responseContext);
    }

    public static class TestSegmentsBroker {
        public final Map<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>> timelines = new HashMap<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>>();
    }

    private static class WindowedSegment {
        private final ReferenceCountingSegment segment;
        private final Interval interval;

        public WindowedSegment(ReferenceCountingSegment segment, Interval interval) {
            this.segment = segment;
            this.interval = interval;
            Preconditions.checkArgument((boolean)segment.getId().getInterval().contains((ReadableInterval)interval));
        }

        public ReferenceCountingSegment getSegment() {
            return this.segment;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public SegmentDescriptor getDescriptor() {
            return new SegmentDescriptor(this.interval, this.segment.getId().getVersion(), this.segment.getId().getPartitionNum());
        }
    }
}

