/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.loading.NoopSegmentCacheManager;
import org.apache.druid.segment.loading.TombstoneSegmentizerFactory;
import org.apache.druid.server.TestSegmentUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;

class TestSegmentCacheManager
extends NoopSegmentCacheManager {
    private final List<DataSegment> cachedSegments;
    private final List<DataSegment> observedBootstrapSegments;
    private final List<DataSegment> observedBootstrapSegmentsLoadedIntoPageCache;
    private final List<DataSegment> observedSegments;
    private final List<DataSegment> observedSegmentsLoadedIntoPageCache;
    private final List<DataSegment> observedSegmentsRemovedFromCache;
    private final AtomicInteger observedShutdownBootstrapCount;

    TestSegmentCacheManager() {
        this((Set<DataSegment>)ImmutableSet.of());
    }

    TestSegmentCacheManager(Set<DataSegment> segmentsToCache) {
        this.cachedSegments = ImmutableList.copyOf(segmentsToCache);
        this.observedBootstrapSegments = new CopyOnWriteArrayList<DataSegment>();
        this.observedBootstrapSegmentsLoadedIntoPageCache = new CopyOnWriteArrayList<DataSegment>();
        this.observedSegments = new CopyOnWriteArrayList<DataSegment>();
        this.observedSegmentsLoadedIntoPageCache = new CopyOnWriteArrayList<DataSegment>();
        this.observedSegmentsRemovedFromCache = new CopyOnWriteArrayList<DataSegment>();
        this.observedShutdownBootstrapCount = new AtomicInteger(0);
    }

    @Override
    public boolean canHandleSegments() {
        return true;
    }

    @Override
    public List<DataSegment> getCachedSegments() {
        return this.cachedSegments;
    }

    @Override
    public ReferenceCountingSegment getBootstrapSegment(DataSegment segment, SegmentLazyLoadFailCallback loadFailed) {
        this.observedBootstrapSegments.add(segment);
        return this.getSegmentInternal(segment);
    }

    @Override
    public ReferenceCountingSegment getSegment(DataSegment segment) {
        this.observedSegments.add(segment);
        return this.getSegmentInternal(segment);
    }

    private ReferenceCountingSegment getSegmentInternal(DataSegment segment) {
        if (segment.isTombstone()) {
            return ReferenceCountingSegment.wrapSegment((Segment)TombstoneSegmentizerFactory.segmentForTombstone((DataSegment)segment), (ShardSpec)segment.getShardSpec());
        }
        return ReferenceCountingSegment.wrapSegment((Segment)new TestSegmentUtils.SegmentForTesting(segment.getDataSource(), (Interval)segment.getLoadSpec().get("interval"), MapUtils.getString((Map)segment.getLoadSpec(), (String)"version")), (ShardSpec)segment.getShardSpec());
    }

    @Override
    public void loadSegmentIntoPageCache(DataSegment segment) {
        this.observedSegmentsLoadedIntoPageCache.add(segment);
    }

    @Override
    public void loadSegmentIntoPageCacheOnBootstrap(DataSegment segment) {
        this.observedBootstrapSegmentsLoadedIntoPageCache.add(segment);
    }

    @Override
    public void shutdownBootstrap() {
        this.observedShutdownBootstrapCount.incrementAndGet();
    }

    @Override
    public void storeInfoFile(DataSegment segment) {
    }

    @Override
    public void removeInfoFile(DataSegment segment) {
    }

    @Override
    public void cleanup(DataSegment segment) {
        this.observedSegmentsRemovedFromCache.add(segment);
    }

    public List<DataSegment> getObservedBootstrapSegments() {
        return this.observedBootstrapSegments;
    }

    public List<DataSegment> getObservedBootstrapSegmentsLoadedIntoPageCache() {
        return this.observedBootstrapSegmentsLoadedIntoPageCache;
    }

    public List<DataSegment> getObservedSegments() {
        return this.observedSegments;
    }

    public List<DataSegment> getObservedSegmentsLoadedIntoPageCache() {
        return this.observedSegmentsLoadedIntoPageCache;
    }

    public List<DataSegment> getObservedSegmentsRemovedFromCache() {
        return this.observedSegmentsRemovedFromCache;
    }

    public AtomicInteger getObservedShutdownBootstrapCount() {
        return this.observedShutdownBootstrapCount;
    }
}

