/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import org.apache.druid.server.compaction.CompactionStatistics;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.junit.Assert;
import org.junit.Test;

public class AutoCompactionSnapshotTest {
    @Test
    public void testAutoCompactionSnapshotBuilder() {
        String expectedDataSource = "data";
        String expectedMessage = "message";
        AutoCompactionSnapshot.Builder builder = AutoCompactionSnapshot.builder((String)"data");
        for (int i = 0; i < 2; ++i) {
            builder.incrementSkippedStats(CompactionStatistics.create((long)13L, (long)13L, (long)13L));
            builder.incrementWaitingStats(CompactionStatistics.create((long)13L, (long)13L, (long)13L));
            builder.incrementCompactedStats(CompactionStatistics.create((long)13L, (long)13L, (long)13L));
        }
        AutoCompactionSnapshot actual = builder.withMessage("message").build();
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((long)26L, (long)actual.getSegmentCountSkipped());
        Assert.assertEquals((long)26L, (long)actual.getIntervalCountSkipped());
        Assert.assertEquals((long)26L, (long)actual.getBytesSkipped());
        Assert.assertEquals((long)26L, (long)actual.getBytesCompacted());
        Assert.assertEquals((long)26L, (long)actual.getIntervalCountCompacted());
        Assert.assertEquals((long)26L, (long)actual.getSegmentCountCompacted());
        Assert.assertEquals((long)26L, (long)actual.getBytesAwaitingCompaction());
        Assert.assertEquals((long)26L, (long)actual.getIntervalCountAwaitingCompaction());
        Assert.assertEquals((long)26L, (long)actual.getSegmentCountAwaitingCompaction());
        Assert.assertEquals((Object)AutoCompactionSnapshot.ScheduleStatus.RUNNING, (Object)actual.getScheduleStatus());
        Assert.assertEquals((Object)"data", (Object)actual.getDataSource());
        Assert.assertEquals((Object)"message", (Object)actual.getMessage());
        AutoCompactionSnapshot expected = new AutoCompactionSnapshot("data", AutoCompactionSnapshot.ScheduleStatus.RUNNING, "message", 26L, 26L, 26L, 26L, 26L, 26L, 26L, 26L, 26L);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

