/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CreateDataSegments {
    private static final DateTime DEFAULT_START = DateTimes.of((String)"2012-10-24");
    private final String datasource;
    private DateTime startTime = DEFAULT_START.plusDays(ThreadLocalRandom.current().nextInt(3000));
    private Granularity granularity = Granularities.DAY;
    private int numPartitions = 1;
    private int numIntervals = 1;
    private long sizeInBytes = 500000000L;
    private String version = "1";
    private CompactionState compactionState = null;
    private Boolean used;
    private DateTime lastUpdatedTime;
    private String upgradedFromSegmentId;

    public static CreateDataSegments ofDatasource(String datasource) {
        return new CreateDataSegments(datasource);
    }

    private CreateDataSegments(String datasource) {
        this.datasource = datasource;
    }

    public CreateDataSegments forIntervals(int numIntervals, Granularity intervalSize) {
        this.numIntervals = numIntervals;
        this.granularity = intervalSize;
        return this;
    }

    public CreateDataSegments startingAt(String startOfFirstInterval) {
        this.startTime = DateTimes.of((String)startOfFirstInterval);
        return this;
    }

    public CreateDataSegments startingAt(DateTime startOfFirstInterval) {
        this.startTime = startOfFirstInterval;
        return this;
    }

    public CreateDataSegments withNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
        return this;
    }

    public CreateDataSegments withCompactionState(CompactionState compactionState) {
        this.compactionState = compactionState;
        return this;
    }

    public CreateDataSegments withVersion(String version) {
        this.version = version;
        return this;
    }

    public CreateDataSegments markUnused() {
        this.used = false;
        return this;
    }

    public CreateDataSegments markUsed() {
        this.used = true;
        return this;
    }

    public CreateDataSegments lastUpdatedOn(DateTime updatedTime) {
        this.lastUpdatedTime = updatedTime;
        return this;
    }

    public CreateDataSegments updatedNow() {
        return this.lastUpdatedOn(DateTimes.nowUtc());
    }

    public DataSegmentPlus asPlus() {
        return this.plus(this.eachOfSize(this.sizeInBytes).get(0));
    }

    public List<DataSegment> eachOfSizeInMb(long sizeMb) {
        return this.eachOfSize(sizeMb * 1000000L);
    }

    public List<DataSegment> eachOfSize(long sizeInBytes) {
        boolean isEternityInterval = Objects.equals(this.granularity, Granularities.ALL);
        if (isEternityInterval) {
            this.numIntervals = 1;
        }
        int uniqueIdInInterval = 0;
        DateTime nextStart = this.startTime;
        ArrayList<NumberedDataSegment> segments = new ArrayList<NumberedDataSegment>();
        for (int numInterval = 0; numInterval < this.numIntervals; ++numInterval) {
            Interval nextInterval = isEternityInterval ? Intervals.ETERNITY : new Interval((ReadableInstant)nextStart, (ReadableInstant)this.granularity.increment(nextStart));
            for (int numPartition = 0; numPartition < this.numPartitions; ++numPartition) {
                segments.add(new NumberedDataSegment(this.datasource, nextInterval, this.version, new NumberedShardSpec(numPartition, this.numPartitions), ++uniqueIdInInterval, this.compactionState, sizeInBytes));
            }
            nextStart = this.granularity.increment(nextStart);
        }
        return Collections.unmodifiableList(segments);
    }

    private DataSegmentPlus plus(DataSegment segment) {
        return new DataSegmentPlus(segment, DateTimes.nowUtc(), this.lastUpdatedTime, this.used, null, null, this.upgradedFromSegmentId);
    }

    private static class NumberedDataSegment
    extends DataSegment {
        private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd");
        private final int uniqueId;

        private NumberedDataSegment(String datasource, Interval interval, String version, NumberedShardSpec shardSpec, int uniqueId, CompactionState compactionState, long size) {
            super(datasource, interval, version, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)shardSpec, compactionState, Integer.valueOf(9), size);
            this.uniqueId = uniqueId;
        }

        public String toString() {
            return "{" + this.getDataSource() + "::" + this.getInterval().getStart().toString(FORMATTER) + "::" + this.uniqueId + "}";
        }
    }
}

