/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.SegmentsSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.transform.CompactionTransformSpec;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.server.coordinator.InlineSchemaDataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskDimensionsConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskIOConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class InlineSchemaDataSourceCompactionConfigTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();

    @Test
    public void testSerdeBasic() throws IOException {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withSkipOffsetFromLatest(new Period(3600L)).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)100000000000000L, (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
        Assert.assertEquals((Object)config.getEngine(), (Object)fromJson.getEngine());
    }

    @Test
    public void testSerdeWithMaxRowsPerSegment() throws IOException {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withMaxRowsPerSegment(Integer.valueOf(30)).withSkipOffsetFromLatest(new Period(3600L)).withEngine(CompactionEngine.MSQ).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getEngine(), (Object)fromJson.getEngine());
    }

    @Test
    public void testSerdeWithMaxTotalRows() throws IOException {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withSkipOffsetFromLatest(new Period(3600L)).withEngine(CompactionEngine.NATIVE).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getEngine(), (Object)fromJson.getEngine());
    }

    @Test
    public void testSerdeMaxTotalRowsWithMaxRowsPerSegment() throws IOException {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withMaxRowsPerSegment(Integer.valueOf(10000)).withSkipOffsetFromLatest(new Period(3600L)).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
    }

    @Test
    public void testSerdeUserCompactionTuningConfig() throws IOException {
        UserCompactionTaskQueryTuningConfig tuningConfig = new UserCompactionTaskQueryTuningConfig(Integer.valueOf(40000), null, Long.valueOf(2000L), null, (SplitHintSpec)new SegmentsSplitHintSpec(new HumanReadableBytes(100000L), null), (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(1000), Long.valueOf(20000L)), IndexSpec.builder().withDimensionCompression(CompressionStrategy.LZ4).withMetricCompression(CompressionStrategy.LZF).withLongEncoding(CompressionFactory.LongEncodingStrategy.LONGS).build(), IndexSpec.builder().withDimensionCompression(CompressionStrategy.LZ4).withMetricCompression(CompressionStrategy.UNCOMPRESSED).withLongEncoding(CompressionFactory.LongEncodingStrategy.AUTO).build(), Integer.valueOf(2), Long.valueOf(1000L), (SegmentWriteOutMediumFactory)TmpFileSegmentWriteOutMediumFactory.instance(), Integer.valueOf(100), Integer.valueOf(5), Long.valueOf(1000L), new Duration(3000L), Integer.valueOf(7), Integer.valueOf(1000), Integer.valueOf(100), Integer.valueOf(2));
        String json = OBJECT_MAPPER.writeValueAsString((Object)tuningConfig);
        UserCompactionTaskQueryTuningConfig fromJson = (UserCompactionTaskQueryTuningConfig)OBJECT_MAPPER.readValue(json, UserCompactionTaskQueryTuningConfig.class);
        Assert.assertEquals((Object)tuningConfig, (Object)fromJson);
    }

    @Test
    public void testSerdeUserCompactionTuningConfigWithAppendableIndexSpec() throws IOException {
        UserCompactionTaskQueryTuningConfig tuningConfig = new UserCompactionTaskQueryTuningConfig(Integer.valueOf(40000), (AppendableIndexSpec)new OnheapIncrementalIndex.Spec(Boolean.valueOf(true)), Long.valueOf(2000L), null, (SplitHintSpec)new SegmentsSplitHintSpec(new HumanReadableBytes(100000L), null), (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(1000), Long.valueOf(20000L)), IndexSpec.builder().withDimensionCompression(CompressionStrategy.LZ4).withMetricCompression(CompressionStrategy.LZ4).withLongEncoding(CompressionFactory.LongEncodingStrategy.LONGS).build(), IndexSpec.builder().withDimensionCompression(CompressionStrategy.LZ4).withMetricCompression(CompressionStrategy.UNCOMPRESSED).withLongEncoding(CompressionFactory.LongEncodingStrategy.AUTO).build(), Integer.valueOf(2), Long.valueOf(1000L), (SegmentWriteOutMediumFactory)TmpFileSegmentWriteOutMediumFactory.instance(), Integer.valueOf(100), Integer.valueOf(5), Long.valueOf(1000L), new Duration(3000L), Integer.valueOf(7), Integer.valueOf(1000), Integer.valueOf(100), Integer.valueOf(2));
        String json = OBJECT_MAPPER.writeValueAsString((Object)tuningConfig);
        UserCompactionTaskQueryTuningConfig fromJson = (UserCompactionTaskQueryTuningConfig)OBJECT_MAPPER.readValue(json, UserCompactionTaskQueryTuningConfig.class);
        Assert.assertEquals((Object)tuningConfig, (Object)fromJson);
    }

    @Test
    public void testSerdeGranularitySpec() throws IOException {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withSkipOffsetFromLatest(new Period(3600L)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null)).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
    }

    @Test
    public void testSerdeGranularitySpecWithQueryGranularity() throws Exception {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withSkipOffsetFromLatest(new Period(3600L)).withGranularitySpec(new UserCompactionTaskGranularityConfig(null, Granularities.YEAR, null)).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
        Assert.assertNotNull((Object)config.getGranularitySpec());
        Assert.assertNotNull((Object)fromJson.getGranularitySpec());
        Assert.assertEquals((Object)config.getGranularitySpec().getQueryGranularity(), (Object)fromJson.getGranularitySpec().getQueryGranularity());
    }

    @Test
    public void testSerdeWithNullGranularitySpec() throws IOException {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withSkipOffsetFromLatest(new Period(3600L)).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
    }

    @Test
    public void testSerdeGranularitySpecWithNullValues() throws IOException {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withSkipOffsetFromLatest(new Period(3600L)).withGranularitySpec(new UserCompactionTaskGranularityConfig(null, null, null)).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
    }

    @Test
    public void testSerdeGranularitySpecWithRollup() throws IOException {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withSkipOffsetFromLatest(new Period(3600L)).withGranularitySpec(new UserCompactionTaskGranularityConfig(null, null, Boolean.valueOf(true))).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
        Assert.assertNotNull((Object)config.getGranularitySpec());
        Assert.assertNotNull((Object)fromJson.getGranularitySpec());
        Assert.assertEquals((Object)config.getGranularitySpec().isRollup(), (Object)fromJson.getGranularitySpec().isRollup());
    }

    @Test
    public void testSerdeIOConfigWithNonNullDropExisting() throws IOException {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withSkipOffsetFromLatest(new Period(3600L)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null)).withIoConfig(new UserCompactionTaskIOConfig(Boolean.valueOf(true))).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
        Assert.assertEquals((Object)config.getIoConfig(), (Object)fromJson.getIoConfig());
    }

    @Test
    public void testSerdeIOConfigWithNullDropExisting() throws IOException {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withSkipOffsetFromLatest(new Period(3600L)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null)).withIoConfig(new UserCompactionTaskIOConfig(null)).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
        Assert.assertEquals((Object)config.getIoConfig(), (Object)fromJson.getIoConfig());
    }

    @Test
    public void testSerdeDimensionsSpec() throws IOException {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withSkipOffsetFromLatest(new Period(3600L)).withDimensionsSpec(new UserCompactionTaskDimensionsConfig(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"foo")))).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getDimensionsSpec(), (Object)fromJson.getDimensionsSpec());
    }

    @Test
    public void testSerdeTransformSpec() throws IOException {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withSkipOffsetFromLatest(new Period(3600L)).withTransformSpec(new CompactionTransformSpec((DimFilter)new SelectorDimFilter("dim1", "foo", null))).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getTransformSpec(), (Object)fromJson.getTransformSpec());
    }

    @Test
    public void testSerdeMetricsSpec() throws IOException {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withSkipOffsetFromLatest(new Period(3600L)).withMetricsSpec(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).withTaskContext((Map)ImmutableMap.of((Object)"key", (Object)"val")).build();
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        InlineSchemaDataSourceCompactionConfig fromJson = (InlineSchemaDataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object[])config.getMetricsSpec(), (Object[])fromJson.getMetricsSpec());
    }
}

