/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.config.MetadataCleanupConfig;
import org.apache.druid.server.coordinator.duty.KillSupervisors;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillSupervisorsTest {
    @Mock
    private MetadataSupervisorManager mockMetadataSupervisorManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    private KillSupervisors killSupervisors;
    private CoordinatorRunStats runStats;

    @Before
    public void setup() {
        this.runStats = new CoordinatorRunStats();
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)this.runStats);
    }

    @Test
    public void testRunSkipIfLastRunLessThanPeriod() {
        MetadataCleanupConfig config = new MetadataCleanupConfig(Boolean.valueOf(true), new Duration(Long.MAX_VALUE), new Duration((Object)"PT1S"));
        this.killSupervisors = new KillSupervisors(config, this.mockMetadataSupervisorManager);
        this.killSupervisors.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockMetadataSupervisorManager});
    }

    @Test
    public void testRunNotSkipIfLastRunMoreThanPeriod() {
        MetadataCleanupConfig config = new MetadataCleanupConfig(Boolean.valueOf(true), new Duration((Object)"PT6S"), new Duration((Object)"PT1S"));
        this.killSupervisors = new KillSupervisors(config, this.mockMetadataSupervisorManager);
        this.killSupervisors.run(this.mockDruidCoordinatorRuntimeParams);
        ((MetadataSupervisorManager)Mockito.verify((Object)this.mockMetadataSupervisorManager)).removeTerminatedSupervisorsOlderThan(ArgumentMatchers.anyLong());
        Assert.assertTrue((boolean)this.runStats.hasStat(Stats.Kill.SUPERVISOR_SPECS));
    }
}

