/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.balancer.BalancerStrategy;
import org.apache.druid.server.coordinator.balancer.RandomBalancerStrategy;
import org.apache.druid.server.coordinator.duty.MarkEternityTombstonesAsUnused;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.SegmentLoadQueueManager;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.server.coordinator.simulate.TestSegmentsMetadataManager;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MarkEternityTombstonesAsUnusedTest {
    private final String ds1 = "foo";
    private final String ds2 = "bar";
    private final DataSegment ds1NumberedSegmentMinToMaxV0 = DataSegment.builder().dataSource("foo").interval(Intervals.ETERNITY).version("0").size(0L).build();
    private final DataSegment ds1TombstoneSegmentMinToMaxV1 = DataSegment.builder().dataSource("foo").shardSpec((ShardSpec)new TombstoneShardSpec()).interval(Intervals.ETERNITY).version("1").size(0L).build();
    private final DataSegment ds1TombstoneSegmentMinTo2000V1 = DataSegment.builder().dataSource("foo").shardSpec((ShardSpec)new TombstoneShardSpec()).interval(new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"2000"))).version("1").size(0L).build();
    private final DataSegment ds1NumberedSegment2000To2001V1 = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2000/2001")).version("1").size(0L).build();
    private final DataSegment ds1TombstoneSegment2001ToMaxV1 = DataSegment.builder().dataSource("foo").shardSpec((ShardSpec)new TombstoneShardSpec()).interval(new Interval((ReadableInstant)DateTimes.of((String)"2001"), (ReadableInstant)DateTimes.MAX)).version("1").size(0L).build();
    final DataSegment ds1TombstoneSegmentMinTo2000V2 = this.ds1TombstoneSegmentMinTo2000V1.withVersion("2");
    final DataSegment ds1TombstoneSegment2001ToMaxV2 = this.ds1TombstoneSegment2001ToMaxV1.withVersion("2");
    private final DataSegment ds2TombstoneSegment1995To2005V0 = DataSegment.builder().dataSource("bar").shardSpec((ShardSpec)new TombstoneShardSpec()).interval(Intervals.of((String)"1995/2005")).version("0").size(0L).build();
    private final DataSegment ds2TombstoneSegmentMinTo2000V1 = DataSegment.builder().dataSource("bar").shardSpec((ShardSpec)new TombstoneShardSpec()).interval(new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"2000"))).version("1").size(0L).build();
    private final DataSegment ds2NumberedSegment3000To4000V1 = DataSegment.builder().dataSource("bar").interval(Intervals.of((String)"3000/4000")).version("1").size(0L).build();
    private final DataSegment ds2TombstoneSegment4000ToMaxV1 = DataSegment.builder().dataSource("bar").shardSpec((ShardSpec)new TombstoneShardSpec()).interval(new Interval((ReadableInstant)DateTimes.of((String)"4000"), (ReadableInstant)DateTimes.MAX)).version("1").size(0L).build();
    private final DataSegment ds2TombstoneSegment4000To4001V1 = DataSegment.builder().dataSource("bar").shardSpec((ShardSpec)new TombstoneShardSpec()).interval(new Interval((ReadableInstant)DateTimes.of((String)"4000"), (ReadableInstant)DateTimes.of((String)"4001"))).version("1").size(0L).build();
    private final DataSegment ds2NumberedSegment1999To2500V2 = DataSegment.builder().dataSource("bar").interval(Intervals.of((String)"1999/2500")).version("2").size(0L).build();
    private final DataSegment ds2TombstoneSegment4000ToMaxV1With1CorePartition = this.ds2TombstoneSegment4000ToMaxV1.withShardSpec((ShardSpec)new TombstoneShardSpec(){

        @JsonProperty(value="partitions")
        public int getNumCorePartitions() {
            return 1;
        }
    });
    private TestSegmentsMetadataManager segmentsMetadataManager;

    @Before
    public void setup() {
        this.segmentsMetadataManager = new TestSegmentsMetadataManager();
    }

    @Test
    public void testCandidateTombstonesWithUsedOvershadowedSegments() {
        ImmutableList allUsedSegments = ImmutableList.of((Object)this.ds1NumberedSegmentMinToMaxV0, (Object)this.ds1TombstoneSegmentMinTo2000V1, (Object)this.ds1NumberedSegment2000To2001V1, (Object)this.ds1TombstoneSegment2001ToMaxV1);
        ImmutableList expectedUsedSegments = ImmutableList.copyOf((Collection)allUsedSegments);
        DruidCoordinatorRuntimeParams params = this.initializeServerAndGetParams((ImmutableList<DataSegment>)allUsedSegments);
        SegmentTimeline timeline = (SegmentTimeline)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get("foo");
        Assert.assertTrue((boolean)timeline.isOvershadowed(this.ds1NumberedSegmentMinToMaxV0));
        Assert.assertFalse((boolean)timeline.isOvershadowed(this.ds1TombstoneSegmentMinTo2000V1));
        Assert.assertFalse((boolean)timeline.isOvershadowed(this.ds1NumberedSegment2000To2001V1));
        Assert.assertFalse((boolean)timeline.isOvershadowed(this.ds1TombstoneSegment2001ToMaxV1));
        this.runEternityTombstonesDutyAndVerify(params, (ImmutableList<DataSegment>)allUsedSegments, (ImmutableList<DataSegment>)expectedUsedSegments);
    }

    @Test
    public void testCandidateTombstonesWithUsedOvershadowedSegments2() {
        ImmutableList allUsedSegments = ImmutableList.of((Object)this.ds1NumberedSegmentMinToMaxV0, (Object)this.ds1TombstoneSegmentMinToMaxV1);
        ImmutableList expectedUsedSegments = ImmutableList.copyOf((Collection)allUsedSegments);
        DruidCoordinatorRuntimeParams params = this.initializeServerAndGetParams((ImmutableList<DataSegment>)allUsedSegments);
        SegmentTimeline ds1Timeline = (SegmentTimeline)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get("foo");
        Assert.assertTrue((boolean)ds1Timeline.isOvershadowed(this.ds1NumberedSegmentMinToMaxV0));
        Assert.assertFalse((boolean)ds1Timeline.isOvershadowed(this.ds1TombstoneSegmentMinToMaxV1));
        this.runEternityTombstonesDutyAndVerify(params, (ImmutableList<DataSegment>)allUsedSegments, (ImmutableList<DataSegment>)expectedUsedSegments);
    }

    @Test
    public void testCandidateTombstonesWithNoUsedOvershadowedSegments() {
        ImmutableList allUsedSegments = ImmutableList.of((Object)this.ds1TombstoneSegmentMinTo2000V1, (Object)this.ds1NumberedSegment2000To2001V1, (Object)this.ds1TombstoneSegment2001ToMaxV1);
        ImmutableList expectedUsedSegments = ImmutableList.of((Object)this.ds1NumberedSegment2000To2001V1);
        DruidCoordinatorRuntimeParams params = this.initializeServerAndGetParams((ImmutableList<DataSegment>)allUsedSegments);
        SegmentTimeline timeline = (SegmentTimeline)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get("foo");
        Assert.assertFalse((boolean)timeline.isOvershadowed(this.ds1TombstoneSegmentMinTo2000V1));
        Assert.assertFalse((boolean)timeline.isOvershadowed(this.ds1NumberedSegment2000To2001V1));
        Assert.assertFalse((boolean)timeline.isOvershadowed(this.ds1TombstoneSegmentMinTo2000V2));
        this.runEternityTombstonesDutyAndVerify(params, (ImmutableList<DataSegment>)allUsedSegments, (ImmutableList<DataSegment>)expectedUsedSegments);
    }

    @Test
    public void testCandidateTombstonesWithNoUsedOvershadowedSegments2() {
        ImmutableList allUsedSegments = ImmutableList.of((Object)this.ds1TombstoneSegmentMinToMaxV1);
        ImmutableList expectedUsedSegments = ImmutableList.of();
        DruidCoordinatorRuntimeParams params = this.initializeServerAndGetParams((ImmutableList<DataSegment>)allUsedSegments);
        SegmentTimeline ds1Timeline = (SegmentTimeline)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get("foo");
        Assert.assertFalse((boolean)ds1Timeline.isOvershadowed(this.ds1TombstoneSegmentMinToMaxV1));
        this.runEternityTombstonesDutyAndVerify(params, (ImmutableList<DataSegment>)allUsedSegments, (ImmutableList<DataSegment>)expectedUsedSegments);
    }

    @Test
    public void testCandiateTombstonesWithManyOvershadowedSegments() {
        ImmutableList allUsedSegments = ImmutableList.of((Object)this.ds1TombstoneSegmentMinTo2000V1, (Object)this.ds1NumberedSegment2000To2001V1, (Object)this.ds1TombstoneSegment2001ToMaxV1, (Object)this.ds1TombstoneSegmentMinTo2000V2, (Object)this.ds1TombstoneSegment2001ToMaxV2);
        ImmutableList expectedUsedSegments = ImmutableList.copyOf((Collection)allUsedSegments);
        DruidCoordinatorRuntimeParams params = this.initializeServerAndGetParams((ImmutableList<DataSegment>)allUsedSegments);
        SegmentTimeline timeline = (SegmentTimeline)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get("foo");
        Assert.assertTrue((boolean)timeline.isOvershadowed(this.ds1TombstoneSegmentMinTo2000V1));
        Assert.assertTrue((boolean)timeline.isOvershadowed(this.ds1TombstoneSegment2001ToMaxV1));
        Assert.assertFalse((boolean)timeline.isOvershadowed(this.ds1NumberedSegment2000To2001V1));
        Assert.assertFalse((boolean)timeline.isOvershadowed(this.ds1TombstoneSegmentMinTo2000V2));
        Assert.assertFalse((boolean)timeline.isOvershadowed(this.ds1TombstoneSegment2001ToMaxV2));
        this.runEternityTombstonesDutyAndVerify(params, (ImmutableList<DataSegment>)allUsedSegments, (ImmutableList<DataSegment>)expectedUsedSegments);
    }

    @Test
    public void testCandidateTombstonesInMultipleDatasources() {
        ImmutableList allUsedSegments = ImmutableList.of((Object)this.ds1TombstoneSegmentMinTo2000V1, (Object)this.ds1NumberedSegment2000To2001V1, (Object)this.ds1TombstoneSegment2001ToMaxV1, (Object)this.ds1TombstoneSegmentMinTo2000V2, (Object)this.ds2TombstoneSegmentMinTo2000V1, (Object)this.ds2NumberedSegment3000To4000V1, (Object)this.ds2TombstoneSegment4000ToMaxV1);
        ImmutableList expectedUsedSegments = ImmutableList.of((Object)this.ds1TombstoneSegmentMinTo2000V1, (Object)this.ds1NumberedSegment2000To2001V1, (Object)this.ds1TombstoneSegmentMinTo2000V2, (Object)this.ds2NumberedSegment3000To4000V1);
        DruidCoordinatorRuntimeParams params = this.initializeServerAndGetParams((ImmutableList<DataSegment>)allUsedSegments);
        SegmentTimeline ds1Timeline = (SegmentTimeline)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get("foo");
        Assert.assertTrue((boolean)ds1Timeline.isOvershadowed(this.ds1TombstoneSegmentMinTo2000V1));
        Assert.assertFalse((boolean)ds1Timeline.isOvershadowed(this.ds1NumberedSegment2000To2001V1));
        Assert.assertFalse((boolean)ds1Timeline.isOvershadowed(this.ds1TombstoneSegment2001ToMaxV1));
        Assert.assertFalse((boolean)ds1Timeline.isOvershadowed(this.ds1TombstoneSegmentMinTo2000V2));
        SegmentTimeline ds2Timeline = (SegmentTimeline)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get("bar");
        Assert.assertFalse((boolean)ds2Timeline.isOvershadowed(this.ds2TombstoneSegmentMinTo2000V1));
        Assert.assertFalse((boolean)ds2Timeline.isOvershadowed(this.ds2NumberedSegment3000To4000V1));
        Assert.assertFalse((boolean)ds2Timeline.isOvershadowed(this.ds2TombstoneSegment4000ToMaxV1));
        this.runEternityTombstonesDutyAndVerify(params, (ImmutableList<DataSegment>)allUsedSegments, (ImmutableList<DataSegment>)expectedUsedSegments);
    }

    @Test
    public void testCandidateTombstonesWithPartiallyOverlappingSegment() {
        ImmutableList allUsedSegments = ImmutableList.of((Object)this.ds2TombstoneSegment1995To2005V0, (Object)this.ds2TombstoneSegmentMinTo2000V1, (Object)this.ds2NumberedSegment3000To4000V1, (Object)this.ds2TombstoneSegment4000ToMaxV1);
        ImmutableList expectedUsedSegments = ImmutableList.of((Object)this.ds2TombstoneSegment1995To2005V0, (Object)this.ds2NumberedSegment3000To4000V1);
        DruidCoordinatorRuntimeParams params = this.initializeServerAndGetParams((ImmutableList<DataSegment>)allUsedSegments);
        SegmentTimeline ds2Timeline = (SegmentTimeline)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get("bar");
        Assert.assertFalse((boolean)ds2Timeline.isOvershadowed(this.ds2TombstoneSegment1995To2005V0));
        Assert.assertFalse((boolean)ds2Timeline.isOvershadowed(this.ds2TombstoneSegmentMinTo2000V1));
        Assert.assertFalse((boolean)ds2Timeline.isOvershadowed(this.ds2NumberedSegment3000To4000V1));
        Assert.assertFalse((boolean)ds2Timeline.isOvershadowed(this.ds2TombstoneSegment4000ToMaxV1));
        this.runEternityTombstonesDutyAndVerify(params, (ImmutableList<DataSegment>)allUsedSegments, (ImmutableList<DataSegment>)expectedUsedSegments);
    }

    @Test
    public void testCandidateTombstonesWithPartiallyOverlappingHigherVersionUsedSegment() {
        ImmutableList allUsedSegments = ImmutableList.of((Object)this.ds2TombstoneSegmentMinTo2000V1, (Object)this.ds2NumberedSegment3000To4000V1, (Object)this.ds2TombstoneSegment4000ToMaxV1, (Object)this.ds2NumberedSegment1999To2500V2);
        ImmutableList expectedUsedSegments = ImmutableList.of((Object)this.ds2NumberedSegment3000To4000V1, (Object)this.ds2NumberedSegment1999To2500V2);
        DruidCoordinatorRuntimeParams params = this.initializeServerAndGetParams((ImmutableList<DataSegment>)allUsedSegments);
        SegmentTimeline ds2Timeline = (SegmentTimeline)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get("bar");
        Assert.assertFalse((boolean)ds2Timeline.isOvershadowed(this.ds2TombstoneSegmentMinTo2000V1));
        Assert.assertFalse((boolean)ds2Timeline.isOvershadowed(this.ds2NumberedSegment3000To4000V1));
        Assert.assertFalse((boolean)ds2Timeline.isOvershadowed(this.ds2TombstoneSegment4000ToMaxV1));
        Assert.assertFalse((boolean)ds2Timeline.isOvershadowed(this.ds2NumberedSegment1999To2500V2));
        this.runEternityTombstonesDutyAndVerify(params, (ImmutableList<DataSegment>)allUsedSegments, (ImmutableList<DataSegment>)expectedUsedSegments);
    }

    @Test
    public void testFiniteIntervalTombstone() {
        ImmutableList allUsedSegments = ImmutableList.of((Object)this.ds2TombstoneSegment4000To4001V1);
        ImmutableList expectedUsedSegments = ImmutableList.of((Object)this.ds2TombstoneSegment4000To4001V1);
        DruidCoordinatorRuntimeParams params = this.initializeServerAndGetParams((ImmutableList<DataSegment>)allUsedSegments);
        SegmentTimeline ds2Timeline = (SegmentTimeline)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get("bar");
        Assert.assertFalse((boolean)ds2Timeline.isOvershadowed(this.ds2TombstoneSegment4000To4001V1));
        this.runEternityTombstonesDutyAndVerify(params, (ImmutableList<DataSegment>)allUsedSegments, (ImmutableList<DataSegment>)expectedUsedSegments);
    }

    @Test
    public void testTombstoneWith1CorePartition() {
        ImmutableList allUsedSegments = ImmutableList.of((Object)this.ds2TombstoneSegment4000ToMaxV1With1CorePartition);
        ImmutableList expectedUsedSegments = ImmutableList.of((Object)this.ds2TombstoneSegment4000ToMaxV1With1CorePartition);
        DruidCoordinatorRuntimeParams params = this.initializeServerAndGetParams((ImmutableList<DataSegment>)allUsedSegments);
        SegmentTimeline ds2Timeline = (SegmentTimeline)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get("bar");
        Assert.assertFalse((boolean)ds2Timeline.isOvershadowed(this.ds2TombstoneSegment4000ToMaxV1With1CorePartition));
        this.runEternityTombstonesDutyAndVerify(params, (ImmutableList<DataSegment>)allUsedSegments, (ImmutableList<DataSegment>)expectedUsedSegments);
    }

    private DruidCoordinatorRuntimeParams initializeServerAndGetParams(ImmutableList<DataSegment> segments) {
        DruidServer druidServer = new DruidServer("", "", "", 0L, ServerType.fromString((String)"broker"), "", 0);
        for (DataSegment segment : segments) {
            this.segmentsMetadataManager.addSegment(segment);
            druidServer.addDataSegment(segment);
        }
        DruidCluster druidCluster = DruidCluster.builder().add(new ServerHolder(druidServer.toImmutableDruidServer(), (LoadQueuePeon)new TestLoadQueuePeon())).build();
        DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.builder().withDataSourcesSnapshot(this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments()).withDruidCluster(druidCluster).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMarkSegmentAsUnusedDelayMillis(0L).build()).withBalancerStrategy((BalancerStrategy)new RandomBalancerStrategy()).withSegmentAssignerUsing(new SegmentLoadQueueManager(null, null)).build();
        return params;
    }

    private void runEternityTombstonesDutyAndVerify(DruidCoordinatorRuntimeParams params, ImmutableList<DataSegment> allUsedSegments, ImmutableList<DataSegment> expectedUsedSegments) {
        params = new MarkEternityTombstonesAsUnused((ds, segmentIds) -> this.segmentsMetadataManager.markSegmentsAsUnused(segmentIds)).run(params);
        HashSet actualUsedSegments = Sets.newHashSet(this.segmentsMetadataManager.iterateAllUsedSegments());
        Assert.assertEquals((long)expectedUsedSegments.size(), (long)actualUsedSegments.size());
        Assert.assertTrue((boolean)actualUsedSegments.containsAll((Collection<?>)expectedUsedSegments));
        CoordinatorRunStats runStats = params.getCoordinatorStats();
        Assert.assertEquals((long)(allUsedSegments.size() - expectedUsedSegments.size()), (long)(runStats.get(Stats.Segments.UNNEEDED_ETERNITY_TOMBSTONE, RowKey.of((Dimension)Dimension.DATASOURCE, (String)"foo")) + runStats.get(Stats.Segments.UNNEEDED_ETERNITY_TOMBSTONE, RowKey.of((Dimension)Dimension.DATASOURCE, (String)"bar"))));
    }
}

