/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import java.util.Collections;
import java.util.Iterator;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.RoundRobinServerSelector;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class RoundRobinServerSelectorTest {
    private static final String TIER = "normal";
    private final DataSegment segment = new DataSegment("wiki", Intervals.of((String)"2022-01-01/2022-01-02"), "1", Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)new NumberedShardSpec(1, 10), Integer.valueOf(9), 100L);

    @Test
    public void testSingleIterator() {
        ServerHolder serverXL = this.createHistorical("serverXL", 1000L);
        ServerHolder serverL = this.createHistorical("serverL", 900L);
        ServerHolder serverM = this.createHistorical("serverM", 800L);
        ServerHolder serverXS = this.createHistorical("serverXS", 10L);
        DruidCluster cluster = DruidCluster.builder().addTier(TIER, new ServerHolder[]{serverXL, serverM, serverXS, serverL}).build();
        RoundRobinServerSelector selector = new RoundRobinServerSelector(cluster);
        Iterator pickedServers = selector.getServersInTierToLoadSegment(TIER, this.segment);
        Assert.assertTrue((boolean)pickedServers.hasNext());
        Assert.assertEquals((Object)serverXL, pickedServers.next());
        Assert.assertEquals((Object)serverL, pickedServers.next());
        Assert.assertEquals((Object)serverM, pickedServers.next());
        Assert.assertFalse((boolean)pickedServers.hasNext());
    }

    @Test
    public void testNextIteratorContinuesFromSamePosition() {
        ServerHolder serverXL = this.createHistorical("serverXL", 1000L);
        ServerHolder serverL = this.createHistorical("serverL", 900L);
        ServerHolder serverM = this.createHistorical("serverM", 800L);
        ServerHolder serverXS = this.createHistorical("serverXS", 10L);
        DruidCluster cluster = DruidCluster.builder().addTier(TIER, new ServerHolder[]{serverXL, serverM, serverXS, serverL}).build();
        RoundRobinServerSelector selector = new RoundRobinServerSelector(cluster);
        Iterator pickedServers = selector.getServersInTierToLoadSegment(TIER, this.segment);
        Assert.assertTrue((boolean)pickedServers.hasNext());
        Assert.assertEquals((Object)serverXL, pickedServers.next());
        pickedServers = selector.getServersInTierToLoadSegment(TIER, this.segment);
        Assert.assertTrue((boolean)pickedServers.hasNext());
        Assert.assertEquals((Object)serverL, pickedServers.next());
        Assert.assertEquals((Object)serverM, pickedServers.next());
        Assert.assertEquals((Object)serverXL, pickedServers.next());
        Assert.assertFalse((boolean)pickedServers.hasNext());
    }

    @Test
    public void testNoServersInTier() {
        DruidCluster cluster = DruidCluster.builder().addTier(TIER, new ServerHolder[0]).build();
        RoundRobinServerSelector selector = new RoundRobinServerSelector(cluster);
        Iterator eligibleServers = selector.getServersInTierToLoadSegment(TIER, this.segment);
        Assert.assertFalse((boolean)eligibleServers.hasNext());
    }

    @Test
    public void testNoEligibleServerInTier() {
        DruidCluster cluster = DruidCluster.builder().addTier(TIER, new ServerHolder[]{this.createHistorical("server1", 40L), this.createHistorical("server2", 30L), this.createHistorical("server3", 10L), this.createHistorical("server4", 20L)}).build();
        RoundRobinServerSelector selector = new RoundRobinServerSelector(cluster);
        Iterator eligibleServers = selector.getServersInTierToLoadSegment(TIER, this.segment);
        Assert.assertFalse((boolean)eligibleServers.hasNext());
    }

    private ServerHolder createHistorical(String name, long size) {
        return new ServerHolder(new DruidServer(name, name, null, size, ServerType.HISTORICAL, TIER, 1).toImmutableDruidServer(), (LoadQueuePeon)new TestLoadQueuePeon());
    }
}

