/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.metrics.MetricsVerifier;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.rules.ForeverBroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.ForeverDropRule;
import org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulation;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.timeline.DataSegment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class CoordinatorSimulationBaseTest
implements CoordinatorSimulation.CoordinatorState,
CoordinatorSimulation.ClusterState,
MetricsVerifier {
    static final double DOUBLE_DELTA = 1.0E-8;
    private CoordinatorSimulation sim;
    private MetricsVerifier metricsVerifier;

    @Before
    public abstract void setUp();

    @After
    public void tearDown() {
        if (this.sim != null) {
            this.sim.stop();
            this.sim = null;
        }
    }

    void startSimulation(CoordinatorSimulation simulation) {
        this.sim = simulation;
        simulation.start();
        this.metricsVerifier = this.sim.coordinator().getMetricsVerifier();
    }

    @Override
    public void runCoordinatorCycle() {
        this.sim.coordinator().runCoordinatorCycle();
    }

    @Override
    public MetricsVerifier getMetricsVerifier() {
        return null;
    }

    @Override
    public DruidServer getInventoryView(String serverName) {
        return this.sim.coordinator().getInventoryView(serverName);
    }

    @Override
    public void syncInventoryView() {
        this.sim.coordinator().syncInventoryView();
    }

    @Override
    public void setDynamicConfig(CoordinatorDynamicConfig dynamicConfig) {
        this.sim.coordinator().setDynamicConfig(dynamicConfig);
    }

    @Override
    public void setRetentionRules(String datasource, Rule ... rules) {
        this.sim.coordinator().setRetentionRules(datasource, rules);
    }

    @Override
    public void loadQueuedSegments() {
        this.sim.cluster().loadQueuedSegments();
    }

    @Override
    public void removeServer(DruidServer server) {
        this.sim.cluster().removeServer(server);
    }

    @Override
    public void addServer(DruidServer server) {
        this.sim.cluster().addServer(server);
    }

    @Override
    public void addSegments(List<DataSegment> segments) {
        this.sim.cluster().addSegments(segments);
    }

    @Override
    public double getLoadPercentage(String datasource) {
        return this.sim.coordinator().getLoadPercentage(datasource);
    }

    void verifyDatasourceIsFullyLoaded(String datasource) {
        Assert.assertEquals((double)100.0, (double)this.getLoadPercentage(datasource), (double)1.0E-8);
    }

    public List<Number> getMetricValues(String metricName, Map<String, Object> dimensionFilters) {
        return this.metricsVerifier.getMetricValues(metricName, dimensionFilters);
    }

    static Map<String, Object> filterByServer(DruidServer server) {
        return CoordinatorSimulationBaseTest.filter(Dimension.SERVER, server.getName());
    }

    static Map<String, Object> filterByTier(String tier) {
        return CoordinatorSimulationBaseTest.filter(Dimension.TIER, tier);
    }

    static Map<String, Object> filterByDatasource(String datasource) {
        return CoordinatorSimulationBaseTest.filter(Dimension.DATASOURCE, datasource);
    }

    static Map<String, Object> filter(Dimension dimension, String value) {
        return Collections.singletonMap(dimension.reportedName(), value);
    }

    static DruidServer createHistorical(int uniqueIdInTier, String tier, long serverSizeMb) {
        String name = tier + "__hist__" + uniqueIdInTier;
        return new DruidServer(name, name, name, serverSizeMb << 20, ServerType.HISTORICAL, tier, 1);
    }

    static class Drop {
        Drop() {
        }

        static Rule forever() {
            return new ForeverDropRule();
        }
    }

    static class Broadcast {
        Broadcast() {
        }

        static Rule forever() {
            return new ForeverBroadcastDistributionRule();
        }
    }

    static class Load {
        private final Map<String, Integer> tieredReplicants = new HashMap<String, Integer>();

        Load() {
        }

        static Load on(String tier, int numReplicas) {
            Load load = new Load();
            load.tieredReplicants.put(tier, numReplicas);
            return load;
        }

        Load andOn(String tier, int numReplicas) {
            this.tieredReplicants.put(tier, numReplicas);
            return this;
        }

        Rule forever() {
            return new ForeverLoadRule(this.tieredReplicants, null);
        }
    }

    static class Segments {
        static final List<DataSegment> WIKI_10X1D = CreateDataSegments.ofDatasource("wiki").forIntervals(1, Granularities.DAY).startingAt("2022-01-01").withNumPartitions(10).eachOfSizeInMb(500L);
        static final List<DataSegment> WIKI_10X100D = CreateDataSegments.ofDatasource("wiki").forIntervals(100, Granularities.DAY).startingAt("2022-01-01").withNumPartitions(10).eachOfSizeInMb(500L);
        static final List<DataSegment> KOALA_100X100D = CreateDataSegments.ofDatasource("koala").forIntervals(100, Granularities.DAY).startingAt("2022-01-01").withNumPartitions(100).eachOfSizeInMb(500L);

        Segments() {
        }
    }

    static class Metric {
        static final String ASSIGNED_COUNT = "segment/assigned/count";
        static final String MOVED_COUNT = "segment/moved/count";
        static final String MOVE_SKIPPED = "segment/moveSkipped/count";
        static final String DROPPED_COUNT = "segment/dropped/count";
        static final String DELETED_COUNT = "segment/deleted/count";
        static final String LOAD_QUEUE_COUNT = "segment/loadQueue/count";
        static final String DROP_QUEUE_COUNT = "segment/dropQueue/count";
        static final String SUCCESS_ACTIONS = "segment/loadQueue/success";
        static final String CANCELLED_ACTIONS = "segment/loadQueue/cancelled";
        static final String OVERSHADOWED_COUNT = "segment/overshadowed/count";

        Metric() {
        }
    }

    static class Tier {
        static final String T1 = "tier_t1";
        static final String T2 = "tier_t2";

        Tier() {
        }
    }
}

