/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SortOrder;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class TestSegmentsMetadataManager
implements SegmentsMetadataManager {
    private final ConcurrentMap<String, DataSegment> allSegments = new ConcurrentHashMap<String, DataSegment>();
    private final ConcurrentMap<String, DataSegment> usedSegments = new ConcurrentHashMap<String, DataSegment>();
    private volatile DataSourcesSnapshot snapshot;
    private volatile boolean pollingStarted;

    public boolean addSegment(DataSegment segment) {
        this.allSegments.put(segment.getId().toString(), segment);
        boolean added = this.usedSegments.put(segment.getId().toString(), segment) != null;
        this.invalidateDatasourcesSnapshot();
        return added;
    }

    public void removeSegment(DataSegment segment) {
        this.allSegments.remove(segment.getId().toString());
        this.usedSegments.remove(segment.getId().toString());
        this.invalidateDatasourcesSnapshot();
    }

    public Set<DataSegment> getAllUnusedSegments() {
        return Set.copyOf(Maps.difference(this.allSegments, this.usedSegments).entriesOnlyOnLeft().values());
    }

    public Set<DataSegment> getAllSegments() {
        return Set.copyOf(this.allSegments.values());
    }

    public void startPollingDatabasePeriodically() {
        this.pollingStarted = true;
    }

    public void stopPollingDatabasePeriodically() {
        this.pollingStarted = false;
    }

    public boolean isPollingDatabasePeriodically() {
        return this.pollingStarted;
    }

    public int markAsUsedAllNonOvershadowedSegmentsInDataSource(String dataSource) {
        return this.markNonOvershadowedSegmentsAsUsed(dataSource, (Predicate<DataSegment>)Predicates.alwaysTrue());
    }

    public int markAsUsedNonOvershadowedSegmentsInInterval(String dataSource, Interval interval, @Nullable List<String> versions) {
        HashSet<String> allowedVersions = versions == null ? null : new HashSet<String>(versions);
        return this.markNonOvershadowedSegmentsAsUsed(dataSource, segment -> segment.getInterval().overlaps((ReadableInterval)interval) && (versions == null || allowedVersions.contains(segment.getVersion())));
    }

    public int markAsUsedNonOvershadowedSegments(String dataSource, Set<SegmentId> segmentIds) {
        return this.markNonOvershadowedSegmentsAsUsed(dataSource, segment -> segmentIds.contains(segment.getId()));
    }

    public boolean markSegmentAsUsed(String segmentId) {
        if (!this.allSegments.containsKey(segmentId) || this.usedSegments.containsKey(segmentId)) {
            return false;
        }
        this.usedSegments.put(segmentId, (DataSegment)this.allSegments.get(segmentId));
        return true;
    }

    public int markAsUnusedAllSegmentsInDataSource(String dataSource) {
        return this.markSegmentsAsUnused((DataSegment segment) -> segment.getDataSource().equals(dataSource));
    }

    public int markAsUnusedSegmentsInInterval(String dataSource, Interval interval, @Nullable List<String> versions) {
        HashSet<String> eligibleVersions = versions == null ? null : new HashSet<String>(versions);
        return this.markSegmentsAsUnused((DataSegment segment) -> segment.getDataSource().equals(dataSource) && segment.getInterval().overlaps((ReadableInterval)interval) && (eligibleVersions == null || eligibleVersions.contains(segment.getVersion())));
    }

    public int markSegmentsAsUnused(Set<SegmentId> segmentIds) {
        return this.markSegmentsAsUnused((DataSegment segment) -> segmentIds.contains(segment.getId()));
    }

    public boolean markSegmentAsUnused(SegmentId segmentId) {
        boolean updated;
        boolean bl = updated = this.usedSegments.remove(segmentId.toString()) != null;
        if (updated) {
            this.invalidateDatasourcesSnapshot();
        }
        return updated;
    }

    @Nullable
    public ImmutableDruidDataSource getImmutableDataSourceWithUsedSegments(String dataSource) {
        if (this.snapshot == null) {
            this.getSnapshotOfDataSourcesWithAllUsedSegments();
        }
        return this.snapshot.getDataSource(dataSource);
    }

    public Collection<ImmutableDruidDataSource> getImmutableDataSourcesWithAllUsedSegments() {
        return this.getSnapshotOfDataSourcesWithAllUsedSegments().getDataSourcesWithAllUsedSegments();
    }

    public DataSourcesSnapshot getSnapshotOfDataSourcesWithAllUsedSegments() {
        if (this.snapshot == null) {
            this.snapshot = DataSourcesSnapshot.fromUsedSegments(this.usedSegments.values());
        }
        return this.snapshot;
    }

    public Iterable<DataSegment> iterateAllUsedSegments() {
        return this.usedSegments.values();
    }

    public Optional<Iterable<DataSegment>> iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(String datasource, Interval interval, boolean requiresLatest) {
        VersionedIntervalTimeline usedSegmentsTimeline = (VersionedIntervalTimeline)this.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get(datasource);
        return Optional.fromNullable((Object)usedSegmentsTimeline).transform(timeline -> timeline.findNonOvershadowedObjectsInInterval(interval, Partitions.ONLY_COMPLETE));
    }

    public Iterable<DataSegmentPlus> iterateAllUnusedSegmentsForDatasource(String datasource, @Nullable Interval interval, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder) {
        return null;
    }

    public Set<String> retrieveAllDataSourceNames() {
        return this.allSegments.values().stream().map(DataSegment::getDataSource).collect(Collectors.toSet());
    }

    public List<Interval> getUnusedSegmentIntervals(String dataSource, @Nullable DateTime minStartTime, DateTime maxEndTime, int limit, DateTime maxUsedStatusLastUpdatedTime) {
        return null;
    }

    public void populateUsedFlagLastUpdatedAsync() {
    }

    public void stopAsyncUsedFlagLastUpdatedUpdate() {
    }

    private int markNonOvershadowedSegmentsAsUsed(String dataSource, Predicate<DataSegment> isSegmentEligible) {
        Set<DataSegment> datasourceSegments = this.allSegments.values().stream().filter(segment -> segment.getDataSource().equals(dataSource)).collect(Collectors.toSet());
        SegmentTimeline timeline = SegmentTimeline.forSegments(datasourceSegments);
        HashMap segmentsToUpdate = new HashMap();
        datasourceSegments.forEach(segment -> {
            String segmentId = segment.getId().toString();
            if (isSegmentEligible.test((DataSegment)segment) && !this.usedSegments.containsKey(segmentId) && !timeline.isOvershadowed(segment)) {
                segmentsToUpdate.put(segmentId, segment);
            }
        });
        if (segmentsToUpdate.isEmpty()) {
            return 0;
        }
        this.usedSegments.putAll(segmentsToUpdate);
        this.invalidateDatasourcesSnapshot();
        return segmentsToUpdate.size();
    }

    private int markSegmentsAsUnused(Predicate<DataSegment> isSegmentEligible) {
        Set<String> segmentIdsToMarkUnused = this.usedSegments.values().stream().filter(isSegmentEligible::test).map(segment -> segment.getId().toString()).collect(Collectors.toSet());
        if (segmentIdsToMarkUnused.isEmpty()) {
            return 0;
        }
        segmentIdsToMarkUnused.forEach(this.usedSegments::remove);
        this.invalidateDatasourcesSnapshot();
        return segmentIdsToMarkUnused.size();
    }

    private void invalidateDatasourcesSnapshot() {
        this.snapshot = null;
    }
}

