/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.ImmutableMap;
import javax.ws.rs.core.Response;
import org.apache.druid.server.initialization.jetty.CustomExceptionMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CustomExceptionMapperTest {
    @Mock
    private JsonParser jsonParser;
    private CustomExceptionMapper customExceptionMapper;

    @Before
    public void setUp() {
        this.customExceptionMapper = new CustomExceptionMapper();
    }

    @Test
    public void testResponseWithSimpleMessage() {
        JsonMappingException exception = JsonMappingException.from((JsonParser)this.jsonParser, (String)"Test exception");
        Response response = this.customExceptionMapper.toResponse(exception);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertTrue((boolean)(response.getEntity() instanceof ImmutableMap));
        ImmutableMap map = (ImmutableMap)response.getEntity();
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"Test exception", (Object)map.get((Object)"error"));
    }

    @Test
    public void testResponseWithLongMessage() {
        JsonMappingException exception = JsonMappingException.from((JsonParser)this.jsonParser, (String)"Test exception\nStack trace\nMisc details");
        Response response = this.customExceptionMapper.toResponse(exception);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertTrue((boolean)(response.getEntity() instanceof ImmutableMap));
        ImmutableMap map = (ImmutableMap)response.getEntity();
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"Test exception", (Object)map.get((Object)"error"));
    }
}

