/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.DateTime;

public class DataSourcesSnapshot {
    private final DateTime snapshotTime;
    private final Map<String, ImmutableDruidDataSource> dataSourcesWithAllUsedSegments;
    private final Map<String, SegmentTimeline> usedSegmentsTimelinesPerDataSource;
    private final ImmutableSet<DataSegment> overshadowedSegments;

    public static DataSourcesSnapshot fromUsedSegments(Iterable<DataSegment> segments) {
        return DataSourcesSnapshot.fromUsedSegments(segments, DateTimes.nowUtc());
    }

    public static DataSourcesSnapshot fromUsedSegments(Iterable<DataSegment> segments, DateTime snapshotTime) {
        ImmutableMap dataSourceProperties = ImmutableMap.of((Object)"created", (Object)DateTimes.nowUtc().toString());
        HashMap dataSources = new HashMap();
        segments.forEach(arg_0 -> DataSourcesSnapshot.lambda$fromUsedSegments$1(dataSources, (Map)dataSourceProperties, arg_0));
        return new DataSourcesSnapshot(snapshotTime, CollectionUtils.mapValues(dataSources, DruidDataSource::toImmutableDruidDataSource));
    }

    private DataSourcesSnapshot(DateTime snapshotTime, Map<String, ImmutableDruidDataSource> dataSourcesWithAllUsedSegments) {
        this.snapshotTime = snapshotTime;
        this.dataSourcesWithAllUsedSegments = dataSourcesWithAllUsedSegments;
        this.usedSegmentsTimelinesPerDataSource = CollectionUtils.mapValues(dataSourcesWithAllUsedSegments, dataSource -> SegmentTimeline.forSegments(dataSource.getSegments()));
        this.overshadowedSegments = ImmutableSet.copyOf(this.determineOvershadowedSegments());
    }

    public DateTime getSnapshotTime() {
        return this.snapshotTime;
    }

    public Collection<ImmutableDruidDataSource> getDataSourcesWithAllUsedSegments() {
        return this.dataSourcesWithAllUsedSegments.values();
    }

    public Map<String, ImmutableDruidDataSource> getDataSourcesMap() {
        return this.dataSourcesWithAllUsedSegments;
    }

    @Nullable
    public ImmutableDruidDataSource getDataSource(String dataSourceName) {
        return this.dataSourcesWithAllUsedSegments.get(dataSourceName);
    }

    public Map<String, SegmentTimeline> getUsedSegmentsTimelinesPerDataSource() {
        return this.usedSegmentsTimelinesPerDataSource;
    }

    public ImmutableSet<DataSegment> getOvershadowedSegments() {
        return this.overshadowedSegments;
    }

    public Iterable<DataSegment> iterateAllUsedSegmentsInSnapshot() {
        return () -> this.dataSourcesWithAllUsedSegments.values().stream().flatMap(dataSource -> dataSource.getSegments().stream()).iterator();
    }

    private List<DataSegment> determineOvershadowedSegments() {
        ArrayList<DataSegment> overshadowedSegments = new ArrayList<DataSegment>();
        for (ImmutableDruidDataSource dataSource : this.dataSourcesWithAllUsedSegments.values()) {
            SegmentTimeline usedSegmentsTimeline = this.usedSegmentsTimelinesPerDataSource.get(dataSource.getName());
            for (DataSegment segment : dataSource.getSegments()) {
                if (!usedSegmentsTimeline.isOvershadowed(segment)) continue;
                overshadowedSegments.add(segment);
            }
        }
        return overshadowedSegments;
    }

    private static /* synthetic */ void lambda$fromUsedSegments$1(Map dataSources, Map dataSourceProperties, DataSegment segment) {
        dataSources.computeIfAbsent(segment.getDataSource(), dsName -> new DruidDataSource((String)dsName, dataSourceProperties)).addSegmentIfAbsent(segment);
    }
}

