/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.segment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.error.DruidException;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.metadata.segment.DatasourceSegmentMetadataReader;
import org.apache.druid.metadata.segment.DatasourceSegmentMetadataWriter;
import org.apache.druid.metadata.segment.SegmentMetadataTransaction;
import org.apache.druid.metadata.segment.cache.DatasourceSegmentCache;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.skife.jdbi.v2.Handle;

class CachedSegmentMetadataTransaction
implements SegmentMetadataTransaction {
    private final SegmentMetadataTransaction delegate;
    private final DatasourceSegmentCache metadataCache;
    private final DruidLeaderSelector leaderSelector;
    private final int startTerm;
    private final boolean readFromCache;
    private boolean isRollingBack = false;
    private boolean isClosed = false;
    private final List<Consumer<DatasourceSegmentMetadataWriter>> pendingCacheWrites = new ArrayList<Consumer<DatasourceSegmentMetadataWriter>>();

    CachedSegmentMetadataTransaction(SegmentMetadataTransaction delegate, DatasourceSegmentCache metadataCache, DruidLeaderSelector leaderSelector, boolean readFromCache) {
        this.delegate = delegate;
        this.metadataCache = metadataCache;
        this.leaderSelector = leaderSelector;
        this.readFromCache = readFromCache;
        if (!leaderSelector.isLeader()) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.SERVICE_UNAVAILABLE).build("This API is currently not available. Please try again after some time.", new Object[0]);
        }
        this.startTerm = leaderSelector.localTerm();
    }

    private void verifyStillLeaderWithSameTerm() {
        if (!this.isLeaderWithSameTerm()) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.SERVICE_UNAVAILABLE).build("This API is currently not available. Please try again after some time.", new Object[0]);
        }
    }

    private boolean isLeaderWithSameTerm() {
        return this.leaderSelector.isLeader() && this.startTerm == this.leaderSelector.localTerm();
    }

    @Override
    public Handle getHandle() {
        return this.delegate.getHandle();
    }

    @Override
    public void setRollbackOnly() {
        this.isRollingBack = true;
        this.delegate.setRollbackOnly();
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        if (this.isRollingBack) {
            this.isClosed = true;
            return;
        }
        try {
            this.pendingCacheWrites.forEach(action -> {
                if (this.isLeaderWithSameTerm()) {
                    action.accept(this.metadataCache);
                }
            });
        }
        finally {
            this.delegate.close();
            this.isClosed = true;
        }
    }

    @Override
    public Set<String> findExistingSegmentIds(Set<SegmentId> segmentIds) {
        HashSet<SegmentId> remainingIdsToFind = new HashSet<SegmentId>(segmentIds);
        HashSet<String> foundIds = new HashSet<String>();
        if (this.readFromCache) {
            foundIds.addAll(this.metadataCache.findUsedSegments(remainingIdsToFind).stream().map(segment -> segment.getDataSegment().getId().toString()).collect(Collectors.toCollection(HashSet::new)));
            remainingIdsToFind.removeIf(id -> foundIds.contains(id.toString()));
        }
        if (!remainingIdsToFind.isEmpty()) {
            foundIds.addAll(this.delegate.findExistingSegmentIds(remainingIdsToFind));
        }
        return Set.copyOf(foundIds);
    }

    @Override
    public Set<SegmentId> findUsedSegmentIdsOverlapping(Interval interval) {
        return this.performReadAction(reader -> reader.findUsedSegmentIdsOverlapping(interval));
    }

    @Override
    public SegmentId findHighestUnusedSegmentId(Interval interval, String version) {
        return this.delegate.findHighestUnusedSegmentId(interval, version);
    }

    @Override
    public List<DataSegmentPlus> findSegments(Set<SegmentId> segmentIds) {
        HashSet<SegmentId> remainingIdsToFind = new HashSet<SegmentId>(segmentIds);
        ArrayList<DataSegmentPlus> foundSegments = new ArrayList<DataSegmentPlus>();
        if (this.readFromCache) {
            foundSegments.addAll(this.metadataCache.findUsedSegments(remainingIdsToFind));
            foundSegments.forEach(segment -> remainingIdsToFind.remove(segment.getDataSegment().getId()));
        }
        if (!remainingIdsToFind.isEmpty()) {
            foundSegments.addAll(this.delegate.findSegments(remainingIdsToFind));
        }
        return List.copyOf(foundSegments);
    }

    @Override
    public List<DataSegmentPlus> findSegmentsWithSchema(Set<SegmentId> segmentIds) {
        return this.delegate.findSegmentsWithSchema(segmentIds);
    }

    @Override
    public Set<DataSegment> findUsedSegmentsOverlappingAnyOf(List<Interval> intervals) {
        return this.performReadAction(reader -> reader.findUsedSegmentsOverlappingAnyOf(intervals));
    }

    @Override
    public List<DataSegmentPlus> findUsedSegments(Set<SegmentId> segmentIds) {
        return this.performReadAction(reader -> reader.findUsedSegments(segmentIds));
    }

    @Override
    public Set<DataSegmentPlus> findUsedSegmentsPlusOverlappingAnyOf(List<Interval> intervals) {
        return this.performReadAction(reader -> reader.findUsedSegmentsPlusOverlappingAnyOf(intervals));
    }

    @Override
    public List<DataSegment> findUnusedSegments(Interval interval, @Nullable List<String> versions, @Nullable Integer limit, @Nullable DateTime maxUpdatedTime) {
        return this.delegate.findUnusedSegments(interval, versions, limit, maxUpdatedTime);
    }

    @Override
    public DataSegment findSegment(SegmentId segmentId) {
        DataSegment usedSegment = this.metadataCache.findUsedSegment(segmentId);
        if (usedSegment == null) {
            return this.delegate.findSegment(segmentId);
        }
        return usedSegment;
    }

    @Override
    public DataSegment findUsedSegment(SegmentId segmentId) {
        return this.performReadAction(reader -> reader.findUsedSegment(segmentId));
    }

    @Override
    public List<SegmentIdWithShardSpec> findPendingSegmentIds(String sequenceName, String sequencePreviousId) {
        return this.performReadAction(reader -> reader.findPendingSegmentIds(sequenceName, sequencePreviousId));
    }

    @Override
    public List<SegmentIdWithShardSpec> findPendingSegmentIdsWithExactInterval(String sequenceName, Interval interval) {
        return this.performReadAction(reader -> reader.findPendingSegmentIdsWithExactInterval(sequenceName, interval));
    }

    @Override
    public List<PendingSegmentRecord> findPendingSegmentsOverlapping(Interval interval) {
        return this.performReadAction(reader -> reader.findPendingSegmentsOverlapping(interval));
    }

    @Override
    public List<PendingSegmentRecord> findPendingSegmentsWithExactInterval(Interval interval) {
        return this.performReadAction(reader -> reader.findPendingSegmentsWithExactInterval(interval));
    }

    @Override
    public List<PendingSegmentRecord> findPendingSegments(String taskAllocatorId) {
        return this.performReadAction(reader -> reader.findPendingSegments(taskAllocatorId));
    }

    @Override
    public int insertSegments(Set<DataSegmentPlus> segments) {
        return this.performWriteAction(writer -> writer.insertSegments(segments));
    }

    @Override
    public int insertSegmentsWithMetadata(Set<DataSegmentPlus> segments) {
        return this.performWriteAction(writer -> writer.insertSegmentsWithMetadata(segments));
    }

    @Override
    public boolean markSegmentAsUnused(SegmentId segmentId, DateTime updateTime) {
        return this.performWriteAction(writer -> writer.markSegmentAsUnused(segmentId, updateTime));
    }

    @Override
    public int markSegmentsAsUnused(Set<SegmentId> segmentIds, DateTime updateTime) {
        return this.performWriteAction(writer -> writer.markSegmentsAsUnused(segmentIds, updateTime));
    }

    @Override
    public int markAllSegmentsAsUnused(DateTime updateTime) {
        return this.performWriteAction(writer -> writer.markAllSegmentsAsUnused(updateTime));
    }

    @Override
    public int markSegmentsWithinIntervalAsUnused(Interval interval, @Nullable List<String> versions, DateTime updateTime) {
        return this.performWriteAction(writer -> writer.markSegmentsWithinIntervalAsUnused(interval, versions, updateTime));
    }

    @Override
    public int deleteSegments(Set<SegmentId> segmentsIdsToDelete) {
        return this.performWriteAction(writer -> writer.deleteSegments(segmentsIdsToDelete));
    }

    @Override
    public boolean updateSegmentPayload(DataSegment segment) {
        return this.delegate.updateSegmentPayload(segment);
    }

    @Override
    public boolean insertPendingSegment(PendingSegmentRecord pendingSegment, boolean skipSegmentLineageCheck) {
        return this.performWriteAction(writer -> writer.insertPendingSegment(pendingSegment, skipSegmentLineageCheck));
    }

    @Override
    public int insertPendingSegments(List<PendingSegmentRecord> pendingSegments, boolean skipSegmentLineageCheck) {
        return this.performWriteAction(writer -> writer.insertPendingSegments(pendingSegments, skipSegmentLineageCheck));
    }

    @Override
    public int deleteAllPendingSegments() {
        return this.performWriteAction(DatasourceSegmentMetadataWriter::deleteAllPendingSegments);
    }

    @Override
    public int deletePendingSegments(Set<String> segmentIdsToDelete) {
        return this.performWriteAction(writer -> writer.deletePendingSegments(segmentIdsToDelete));
    }

    @Override
    public int deletePendingSegments(String taskAllocatorId) {
        return this.performWriteAction(writer -> writer.deletePendingSegments(taskAllocatorId));
    }

    @Override
    public int deletePendingSegmentsCreatedIn(Interval interval) {
        return this.performWriteAction(writer -> writer.deletePendingSegmentsCreatedIn(interval));
    }

    private <T> T performReadAction(Function<DatasourceSegmentMetadataReader, T> action) {
        if (this.readFromCache) {
            return action.apply(this.metadataCache);
        }
        return action.apply(this.delegate);
    }

    private <T> T performWriteAction(Function<DatasourceSegmentMetadataWriter, T> action) {
        if (this.isClosed) {
            throw DruidException.defensive((String)"Transaction has already been committed. No more writes can be performed.", (Object[])new Object[0]);
        }
        this.verifyStillLeaderWithSameTerm();
        T result = action.apply(this.delegate);
        this.pendingCacheWrites.add(writer -> {
            Object ignored = action.apply((DatasourceSegmentMetadataWriter)writer);
        });
        return result;
    }
}

