/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.table.BaseExternTableTest;
import org.apache.druid.catalog.model.table.ExternalTableDefn;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.InputSourceDefn;
import org.apache.druid.catalog.model.table.TableBuilder;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;

public class LocalInputSourceDefnTest
extends BaseExternTableTest {
    private static final Map<String, Object> BASE_DIR_ONLY = ImmutableMap.of((Object)"type", (Object)"local", (Object)"baseDir", (Object)"/tmp");
    private final InputSourceDefn localDefn;

    public LocalInputSourceDefnTest() {
        this.localDefn = this.registry.inputSourceDefnFor("local");
    }

    @Test
    public void testValidateEmptyInputSource() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource((Map)ImmutableMap.of((Object)"type", (Object)"local")).inputFormat(CSV_FORMAT).column("x", Columns.STRING).column("y", Columns.LONG).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testValidateNoFormat() {
        LocalInputSource inputSource = new LocalInputSource(new File("/tmp"), "*");
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).column("x", Columns.STRING).column("y", Columns.LONG).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testValidateNoColumns() {
        LocalInputSource inputSource = new LocalInputSource(new File("/tmp"), "*");
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).inputFormat(CSV_FORMAT).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testValidateConnection() {
        LocalInputSource inputSource = new LocalInputSource(new File("/tmp"), "*");
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
    }

    @Test
    public void testValidateConnectionNoFilter() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(BASE_DIR_ONLY).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
    }

    @Test
    public void testValidateBaseDirWithFormat() {
        LocalInputSource inputSource = new LocalInputSource(new File("/tmp"), "*");
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).inputFormat(CSV_FORMAT).column("x", Columns.STRING).column("y", Columns.LONG).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
    }

    @Test
    public void testValidateFilesWithFormat() {
        LocalInputSource inputSource = new LocalInputSource(null, null, Collections.singletonList(new File("/tmp/myFile.csv")), null);
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).inputFormat(CSV_FORMAT).column("x", Columns.STRING).column("y", Columns.LONG).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
    }

    @Test
    public void testBaseDirAndFiles() {
        ImmutableMap source = ImmutableMap.of((Object)"type", (Object)"local", (Object)"baseDir", (Object)"/tmp", (Object)"filter", (Object)"*.csv", (Object)"files", Collections.singletonList("foo.csv"));
        TableMetadata table = TableBuilder.external((String)"foo").inputSource((Map)source).inputFormat(CSV_FORMAT).column("x", Columns.STRING).column("y", Columns.LONG).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testAdHocParameters() {
        TableFunction fn = this.localDefn.adHocTableFn();
        Assert.assertTrue((boolean)this.hasParam(fn, "baseDir"));
        Assert.assertTrue((boolean)this.hasParam(fn, "files"));
        Assert.assertTrue((boolean)this.hasParam(fn, "filter"));
        Assert.assertTrue((boolean)this.hasParam(fn, "format"));
    }

    @Test
    public void testAdHocBaseDir() {
        TableFunction fn = this.localDefn.adHocTableFn();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("baseDir", "/tmp");
        args.put("filter", "*.csv");
        args.put("format", "csv");
        ExternalTableSpec externSpec = fn.apply("x", args, COLUMNS, this.mapper);
        LocalInputSource sourceSpec = (LocalInputSource)externSpec.inputSource;
        Assert.assertEquals((Object)new File("/tmp"), (Object)sourceSpec.getBaseDir());
        Assert.assertEquals((Object)"*.csv", (Object)sourceSpec.getFilter());
        Assert.assertTrue((boolean)sourceSpec.getFiles().isEmpty());
        this.validateFormat(externSpec);
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, Collections.emptyList(), this.mapper));
    }

    @Test
    public void testAdHocBaseDirOnly() {
        TableFunction fn = this.localDefn.adHocTableFn();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("baseDir", "/tmp");
        args.put("format", "csv");
        ExternalTableSpec externSpec = fn.apply("x", args, COLUMNS, this.mapper);
        LocalInputSource sourceSpec = (LocalInputSource)externSpec.inputSource;
        Assert.assertEquals((Object)new File("/tmp"), (Object)sourceSpec.getBaseDir());
        Assert.assertEquals((Object)"*", (Object)sourceSpec.getFilter());
        Assert.assertTrue((boolean)sourceSpec.getFiles().isEmpty());
        this.validateFormat(externSpec);
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, Collections.emptyList(), this.mapper));
    }

    @Test
    public void testAdHocFiles() {
        TableFunction fn = this.localDefn.adHocTableFn();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("files", Arrays.asList("/tmp/foo.csv", "/tmp/bar.csv"));
        args.put("format", "csv");
        ExternalTableSpec externSpec = fn.apply("x", args, COLUMNS, this.mapper);
        LocalInputSource sourceSpec = (LocalInputSource)externSpec.inputSource;
        Assert.assertNull((Object)sourceSpec.getBaseDir());
        Assert.assertNull((Object)sourceSpec.getFilter());
        Assert.assertEquals(Arrays.asList(new File("/tmp/foo.csv"), new File("/tmp/bar.csv")), (Object)sourceSpec.getFiles());
        this.validateFormat(externSpec);
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, Collections.emptyList(), this.mapper));
    }

    @Test
    public void testAdHocBaseDirAndFiles() {
        TableFunction fn = this.localDefn.adHocTableFn();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("baseDir", "/tmp");
        args.put("files", Arrays.asList("foo.csv", "bar.csv"));
        args.put("format", "csv");
        ExternalTableSpec externSpec = fn.apply("x", args, COLUMNS, this.mapper);
        LocalInputSource sourceSpec = (LocalInputSource)externSpec.inputSource;
        Assert.assertNull((Object)sourceSpec.getBaseDir());
        Assert.assertNull((Object)sourceSpec.getFilter());
        Assert.assertEquals(Arrays.asList(new File("/tmp/foo.csv"), new File("/tmp/bar.csv")), (Object)sourceSpec.getFiles());
        this.validateFormat(externSpec);
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, Collections.emptyList(), this.mapper));
    }

    @Test
    public void testAdHocErrors() {
        TableFunction fn = this.localDefn.adHocTableFn();
        HashMap<String, String> args = new HashMap<String, String>();
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, COLUMNS, this.mapper));
        args = new HashMap();
        args.put("baseDir", "/tmp");
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, COLUMNS, this.mapper));
        args = new HashMap();
        args.put("filter", "*.csv");
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, COLUMNS, this.mapper));
        args = new HashMap();
        args.put("baseDir", "/tmp");
        args.put("files", "/tmp/foo.csv, /tmp/bar.csv");
        args.put("filter", "*.csv");
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, COLUMNS, this.mapper));
    }

    @Test
    public void testFullyDefinedBaseDirAndPattern() {
        LocalInputSource inputSource = new LocalInputSource(new File("/tmp"), "*.csv", null, null);
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).inputFormat(CSV_FORMAT).column("x", Columns.STRING).column("y", Columns.LONG).build();
        table.validate();
        TableDefnRegistry registry = new TableDefnRegistry(this.mapper);
        Assert.assertNotNull((Object)registry.resolve(table.spec()));
        ResolvedTable resolved = registry.resolve(table.spec());
        ExternalTableDefn externDefn = (ExternalTableDefn)resolved.defn();
        ExternalTableSpec externSpec = externDefn.convert(resolved);
        LocalInputSource sourceSpec = (LocalInputSource)externSpec.inputSource;
        Assert.assertEquals((Object)"/tmp", (Object)sourceSpec.getBaseDir().toString());
        Assert.assertEquals((Object)"*.csv", (Object)sourceSpec.getFilter());
        Assert.assertTrue((boolean)sourceSpec.getFiles().isEmpty());
        this.validateFormat(externSpec);
        TableFunction fn = externDefn.tableFn(resolved);
        Assert.assertEquals((long)0L, (long)fn.parameters().size());
        externSpec = fn.apply("x", Collections.emptyMap(), Collections.emptyList(), this.mapper);
        sourceSpec = (LocalInputSource)externSpec.inputSource;
        Assert.assertEquals((Object)"/tmp", (Object)sourceSpec.getBaseDir().toString());
        Assert.assertEquals((Object)"*.csv", (Object)sourceSpec.getFilter());
        Assert.assertTrue((boolean)sourceSpec.getFiles().isEmpty());
        this.validateFormat(externSpec);
        Assert.assertThrows(IAE.class, () -> fn.apply("x", Collections.emptyMap(), COLUMNS, this.mapper));
    }

    @Test
    public void testFullyDefinedFiles() {
        List<File> files = Collections.singletonList(new File("/tmp/my.csv"));
        LocalInputSource inputSource = new LocalInputSource(null, null, files, null);
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).inputFormat(CSV_FORMAT).column("x", Columns.STRING).column("y", Columns.LONG).build();
        table.validate();
        TableDefnRegistry registry = new TableDefnRegistry(this.mapper);
        Assert.assertNotNull((Object)registry.resolve(table.spec()));
        ResolvedTable resolved = registry.resolve(table.spec());
        ExternalTableDefn externDefn = (ExternalTableDefn)resolved.defn();
        ExternalTableSpec externSpec = externDefn.convert(resolved);
        LocalInputSource sourceSpec = (LocalInputSource)externSpec.inputSource;
        Assert.assertNull((Object)sourceSpec.getBaseDir());
        Assert.assertNull((Object)sourceSpec.getFilter());
        Assert.assertEquals(files, (Object)sourceSpec.getFiles());
        this.validateFormat(externSpec);
        TableFunction fn = externDefn.tableFn(resolved);
        Assert.assertEquals((long)0L, (long)fn.parameters().size());
        externSpec = fn.apply("x", Collections.emptyMap(), Collections.emptyList(), this.mapper);
        sourceSpec = (LocalInputSource)externSpec.inputSource;
        Assert.assertNull((Object)sourceSpec.getBaseDir());
        Assert.assertNull((Object)sourceSpec.getFilter());
        Assert.assertEquals(files, (Object)sourceSpec.getFiles());
        this.validateFormat(externSpec);
        Assert.assertThrows(IAE.class, () -> fn.apply("x", Collections.emptyMap(), COLUMNS, this.mapper));
    }

    @Test
    public void testBaseDirAndFormat() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(BASE_DIR_ONLY).inputFormat(CSV_FORMAT).column("x", Columns.STRING).column("y", Columns.LONG).build();
        table.validate();
        TableDefnRegistry registry = new TableDefnRegistry(this.mapper);
        ResolvedTable resolved = registry.resolve(table.spec());
        ExternalTableDefn externDefn = (ExternalTableDefn)resolved.defn();
        Assert.assertThrows(IAE.class, () -> externDefn.convert(resolved));
        TableFunction fn = externDefn.tableFn(resolved);
        Assert.assertTrue((boolean)this.hasParam(fn, "files"));
        Assert.assertTrue((boolean)this.hasParam(fn, "filter"));
        Assert.assertFalse((boolean)this.hasParam(fn, "format"));
        Assert.assertThrows(IAE.class, () -> fn.apply("x", Collections.emptyMap(), Collections.emptyList(), this.mapper));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("filter", "*.csv");
        ExternalTableSpec externSpec = fn.apply("x", args, Collections.emptyList(), this.mapper);
        LocalInputSource sourceSpec = (LocalInputSource)externSpec.inputSource;
        Assert.assertEquals((Object)"/tmp", (Object)sourceSpec.getBaseDir().toString());
        Assert.assertEquals((Object)"*.csv", (Object)sourceSpec.getFilter());
        this.validateFormat(externSpec);
        args = new HashMap();
        args.put("files", Arrays.asList("foo.csv", "bar.csv"));
        externSpec = fn.apply("x", args, Collections.emptyList(), this.mapper);
        sourceSpec = (LocalInputSource)externSpec.inputSource;
        Assert.assertNull((Object)sourceSpec.getBaseDir());
        Assert.assertNull((Object)sourceSpec.getFilter());
        Assert.assertEquals(Arrays.asList(new File("/tmp/foo.csv"), new File("/tmp/bar.csv")), (Object)sourceSpec.getFiles());
        this.validateFormat(externSpec);
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, COLUMNS, this.mapper));
    }

    @Test
    public void testBaseDirOnly() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(BASE_DIR_ONLY).build();
        table.validate();
        TableDefnRegistry registry = new TableDefnRegistry(this.mapper);
        ResolvedTable resolved = registry.resolve(table.spec());
        ExternalTableDefn externDefn = (ExternalTableDefn)resolved.defn();
        Assert.assertThrows(IAE.class, () -> externDefn.convert(resolved));
        TableFunction fn = externDefn.tableFn(resolved);
        Assert.assertTrue((boolean)this.hasParam(fn, "files"));
        Assert.assertTrue((boolean)this.hasParam(fn, "filter"));
        Assert.assertTrue((boolean)this.hasParam(fn, "format"));
        Assert.assertThrows(IAE.class, () -> fn.apply("x", Collections.emptyMap(), Collections.emptyList(), this.mapper));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("filter", "*.csv");
        args.put("format", "csv");
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, Collections.emptyList(), this.mapper));
        ExternalTableSpec externSpec = fn.apply("x", args, COLUMNS, this.mapper);
        LocalInputSource sourceSpec = (LocalInputSource)externSpec.inputSource;
        Assert.assertEquals((Object)"/tmp", (Object)sourceSpec.getBaseDir().toString());
        Assert.assertEquals((Object)"*.csv", (Object)sourceSpec.getFilter());
        this.validateFormat(externSpec);
        args = new HashMap();
        args.put("files", Arrays.asList("foo.csv", "bar.csv"));
        args.put("format", "csv");
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, Collections.emptyList(), this.mapper));
        externSpec = fn.apply("x", args, COLUMNS, this.mapper);
        sourceSpec = (LocalInputSource)externSpec.inputSource;
        Assert.assertNull((Object)sourceSpec.getBaseDir());
        Assert.assertNull((Object)sourceSpec.getFilter());
        Assert.assertEquals(Arrays.asList(new File("/tmp/foo.csv"), new File("/tmp/bar.csv")), (Object)sourceSpec.getFiles());
        this.validateFormat(externSpec);
    }

    private void validateFormat(ExternalTableSpec externSpec) {
        CsvInputFormat csvFormat = (CsvInputFormat)externSpec.inputFormat;
        Assert.assertEquals(Arrays.asList("x", "y"), (Object)csvFormat.getColumns());
        RowSignature sig = externSpec.signature;
        Assert.assertEquals(Arrays.asList("x", "y"), (Object)sig.getColumnNames());
        Assert.assertEquals((Object)ColumnType.STRING, sig.getColumnType(0).get());
        Assert.assertEquals((Object)ColumnType.LONG, sig.getColumnType(1).get());
        Assert.assertEquals(Collections.singleton("local"), (Object)externSpec.inputSourceTypesSupplier.get());
    }
}

