/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator.discovery;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BooleanSupplier;
import org.apache.druid.curator.CuratorTestBase;
import org.apache.druid.curator.announcement.NodeAnnouncer;
import org.apache.druid.curator.announcement.ServiceAnnouncer;
import org.apache.druid.curator.discovery.CuratorDruidNodeAnnouncer;
import org.apache.druid.curator.discovery.CuratorDruidNodeDiscoveryProvider;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CuratorDruidNodeAnnouncerAndDiscoveryTest
extends CuratorTestBase {
    @Before
    public void setUp() throws Exception {
        this.setupServerAndCurator();
    }

    @Test(timeout=60000L)
    public void testAnnouncementAndDiscovery() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        objectMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ServerConfig.class, (Object)new ServerConfig()).addValue("java.lang.String", (Object)"dummy").addValue("java.lang.Integer", (Object)1234).addValue(ObjectMapper.class, (Object)objectMapper));
        this.curator.start();
        this.curator.blockUntilConnected();
        NodeAnnouncer announcer = new NodeAnnouncer(this.curator, (ExecutorService)Execs.directExecutor());
        announcer.start();
        CuratorDruidNodeAnnouncer druidNodeAnnouncer = new CuratorDruidNodeAnnouncer((ServiceAnnouncer)announcer, new ZkPathsConfig(), (ObjectMapper)objectMapper);
        DiscoveryDruidNode coordinatorNode1 = new DiscoveryDruidNode(new DruidNode("s1", "h1", false, Integer.valueOf(8080), null, true, false), NodeRole.COORDINATOR, (Map)ImmutableMap.of());
        DiscoveryDruidNode coordinatorNode2 = new DiscoveryDruidNode(new DruidNode("s2", "h2", false, Integer.valueOf(8080), null, true, false), NodeRole.COORDINATOR, (Map)ImmutableMap.of());
        DiscoveryDruidNode overlordNode1 = new DiscoveryDruidNode(new DruidNode("s3", "h3", false, Integer.valueOf(8080), null, true, false), NodeRole.OVERLORD, (Map)ImmutableMap.of());
        DiscoveryDruidNode overlordNode2 = new DiscoveryDruidNode(new DruidNode("s4", "h4", false, Integer.valueOf(8080), null, true, false), NodeRole.OVERLORD, (Map)ImmutableMap.of());
        druidNodeAnnouncer.announce(coordinatorNode1);
        druidNodeAnnouncer.announce(overlordNode1);
        CuratorDruidNodeDiscoveryProvider druidNodeDiscoveryProvider = new CuratorDruidNodeDiscoveryProvider(this.curator, new ZkPathsConfig(), (ObjectMapper)objectMapper);
        druidNodeDiscoveryProvider.start();
        DruidNodeDiscovery coordDiscovery = druidNodeDiscoveryProvider.getForNodeRole(NodeRole.COORDINATOR);
        BooleanSupplier coord1NodeDiscovery = druidNodeDiscoveryProvider.getForNode(coordinatorNode1.getDruidNode(), NodeRole.COORDINATOR);
        DruidNodeDiscovery overlordDiscovery = druidNodeDiscoveryProvider.getForNodeRole(NodeRole.OVERLORD);
        BooleanSupplier overlord1NodeDiscovery = druidNodeDiscoveryProvider.getForNode(overlordNode1.getDruidNode(), NodeRole.OVERLORD);
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)coordinatorNode1), coordDiscovery.getAllNodes()) && !coord1NodeDiscovery.getAsBoolean()) {
            Thread.sleep(100L);
        }
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)overlordNode1), overlordDiscovery.getAllNodes()) && !overlord1NodeDiscovery.getAsBoolean()) {
            Thread.sleep(100L);
        }
        HashSet<DiscoveryDruidNode> coordNodes = new HashSet<DiscoveryDruidNode>();
        coordDiscovery.registerListener(CuratorDruidNodeAnnouncerAndDiscoveryTest.createSetAggregatingListener(coordNodes));
        HashSet<DiscoveryDruidNode> overlordNodes = new HashSet<DiscoveryDruidNode>();
        overlordDiscovery.registerListener(CuratorDruidNodeAnnouncerAndDiscoveryTest.createSetAggregatingListener(overlordNodes));
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)coordinatorNode1), coordNodes)) {
            Thread.sleep(100L);
        }
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)overlordNode1), overlordNodes)) {
            Thread.sleep(100L);
        }
        druidNodeAnnouncer.announce(coordinatorNode2);
        druidNodeAnnouncer.announce(overlordNode2);
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)coordinatorNode1, (Object)coordinatorNode2), coordDiscovery.getAllNodes())) {
            Thread.sleep(100L);
        }
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)overlordNode1, (Object)overlordNode2), overlordDiscovery.getAllNodes())) {
            Thread.sleep(100L);
        }
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)coordinatorNode1, (Object)coordinatorNode2), coordNodes)) {
            Thread.sleep(100L);
        }
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of((Object)overlordNode1, (Object)overlordNode2), overlordNodes)) {
            Thread.sleep(100L);
        }
        druidNodeAnnouncer.unannounce(coordinatorNode1);
        druidNodeAnnouncer.unannounce(coordinatorNode2);
        druidNodeAnnouncer.unannounce(overlordNode1);
        druidNodeAnnouncer.unannounce(overlordNode2);
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of(), coordDiscovery.getAllNodes())) {
            Thread.sleep(100L);
        }
        while (!this.checkNodes((Set<DiscoveryDruidNode>)ImmutableSet.of(), overlordDiscovery.getAllNodes())) {
            Thread.sleep(100L);
        }
        while (!coordNodes.isEmpty()) {
            Thread.sleep(100L);
        }
        while (!overlordNodes.isEmpty()) {
            Thread.sleep(100L);
        }
        druidNodeDiscoveryProvider.stop();
        announcer.stop();
    }

    private static DruidNodeDiscovery.Listener createSetAggregatingListener(final Set<DiscoveryDruidNode> set) {
        return new DruidNodeDiscovery.Listener(){

            public void nodesAdded(Collection<DiscoveryDruidNode> nodes) {
                set.addAll(nodes);
            }

            public void nodesRemoved(Collection<DiscoveryDruidNode> nodes) {
                set.removeAll(nodes);
            }
        };
    }

    private boolean checkNodes(Set<DiscoveryDruidNode> expected, Collection<DiscoveryDruidNode> actual) {
        return expected.equals(ImmutableSet.copyOf(actual));
    }

    @After
    public void tearDown() {
        this.tearDownServerAndCurator();
    }
}

