/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.util.Modules;
import java.util.Properties;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.initialization.CoreInjectorBuilder;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.initialization.ServiceInjectorBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ServiceInjectorBuilderTest {
    @Test
    public void testNormalUsage() {
        Injector startupInjector = new StartupInjectorBuilder().withProperties(new Properties()).build();
        CoreInjectorBuilder coreBuilder = new CoreInjectorBuilder(startupInjector);
        coreBuilder.ignoreLoadScopes();
        coreBuilder.addModule((Module)new LocalProviderModule(1));
        ServiceInjectorBuilder si = new ServiceInjectorBuilder(coreBuilder);
        si.add(new Object[]{new LocalProviderModule(2)});
        Injector injector = si.build();
        Integer v = (Integer)injector.getInstance(Integer.class);
        Assertions.assertEquals((int)2, (Integer)v);
    }

    @Test
    public void testOverrideBelow() {
        Injector startupInjector = new StartupInjectorBuilder().withProperties(new Properties()).build();
        CoreInjectorBuilder coreBuilder = new CoreInjectorBuilder(startupInjector);
        coreBuilder.ignoreLoadScopes();
        coreBuilder.addModule(Modules.override((Module[])new Module[]{new LocalProviderModule(0)}).with(new Module[]{new LocalProviderModule(1)}));
        ServiceInjectorBuilder si = new ServiceInjectorBuilder(coreBuilder);
        si.add(new Object[]{new LocalProviderModule(2)});
        Injector injector = si.build();
        Integer v = (Integer)injector.getInstance(Integer.class);
        Assertions.assertEquals((int)2, (Integer)v);
    }

    @Test
    public void testOverrideBoth() {
        Injector startupInjector = new StartupInjectorBuilder().withProperties(new Properties()).build();
        CoreInjectorBuilder coreBuilder = new CoreInjectorBuilder(startupInjector);
        coreBuilder.ignoreLoadScopes();
        coreBuilder.addModule(Modules.override((Module[])new Module[]{new LocalProviderModule(0)}).with(new Module[]{new LocalProviderModule(1)}));
        ServiceInjectorBuilder si = new ServiceInjectorBuilder(coreBuilder);
        si.add(new Object[]{Modules.override((Module[])new Module[]{new LocalProviderModule(-1)}).with(new Module[]{new LocalProviderModule(2)})});
        Injector injector = si.build();
        Integer v = (Integer)injector.getInstance(Integer.class);
        Assertions.assertEquals((int)2, (Integer)v);
    }

    static class LocalProviderModule
    implements DruidModule {
        private int val;

        public LocalProviderModule(int i) {
            this.val = i;
        }

        public void configure(Binder binder) {
        }

        @Provides
        public Integer getVal() {
            return this.val;
        }
    }
}

