/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.initialization;

import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.druid.common.exception.AllowedRegexErrorResponseTransformStrategy;
import org.apache.druid.common.exception.ErrorResponseTransformStrategy;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.server.initialization.ServerConfig;
import org.junit.Assert;
import org.junit.Test;

public class ServerConfigTest {
    private static final DefaultObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();

    @Test
    public void testSerde() throws Exception {
        ServerConfig defaultConfig = new ServerConfig();
        String defaultConfigJson = OBJECT_MAPPER.writeValueAsString((Object)defaultConfig);
        ServerConfig defaultConfig2 = (ServerConfig)OBJECT_MAPPER.readValue(defaultConfigJson, ServerConfig.class);
        Assert.assertEquals((Object)defaultConfig, (Object)defaultConfig2);
        Assert.assertFalse((boolean)defaultConfig2.isEnableForwardedRequestCustomizer());
        Assert.assertFalse((boolean)defaultConfig2.isEnableHSTS());
        ServerConfig modifiedConfig = new ServerConfig(999, 888, defaultConfig.isEnableRequestLimit(), defaultConfig.getMaxIdleTime(), defaultConfig.getDefaultQueryTimeout(), defaultConfig.getMaxScatterGatherBytes(), defaultConfig.getMaxSubqueryRows(), defaultConfig.getMaxSubqueryBytes(), defaultConfig.isuseNestedForUnknownTypeInSubquery(), defaultConfig.getMaxQueryTimeout(), defaultConfig.getMaxRequestHeaderSize(), defaultConfig.getGracefulShutdownTimeout(), defaultConfig.getUnannouncePropagationDelay(), defaultConfig.getInflateBufferSize(), defaultConfig.getCompressionLevel(), true, (List)ImmutableList.of((Object)"OPTIONS"), true, (ErrorResponseTransformStrategy)new AllowedRegexErrorResponseTransformStrategy((List)ImmutableList.of((Object)".*")), "my-cool-policy", true);
        String modifiedConfigJson = OBJECT_MAPPER.writeValueAsString((Object)modifiedConfig);
        ServerConfig modifiedConfig2 = (ServerConfig)OBJECT_MAPPER.readValue(modifiedConfigJson, ServerConfig.class);
        Assert.assertEquals((Object)modifiedConfig, (Object)modifiedConfig2);
        Assert.assertEquals((long)999L, (long)modifiedConfig2.getNumThreads());
        Assert.assertEquals((long)888L, (long)modifiedConfig2.getQueueSize());
        Assert.assertTrue((boolean)(modifiedConfig2.getErrorResponseTransformStrategy() instanceof AllowedRegexErrorResponseTransformStrategy));
        Assert.assertTrue((boolean)modifiedConfig2.isEnableForwardedRequestCustomizer());
        Assert.assertEquals((long)1L, (long)modifiedConfig2.getAllowedHttpMethods().size());
        Assert.assertTrue((boolean)modifiedConfig2.getAllowedHttpMethods().contains("OPTIONS"));
        Assert.assertEquals((Object)"my-cool-policy", (Object)modifiedConfig.getContentSecurityPolicy());
        Assert.assertEquals((Object)"my-cool-policy", (Object)modifiedConfig2.getContentSecurityPolicy());
        Assert.assertTrue((boolean)modifiedConfig2.isEnableHSTS());
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(ServerConfig.class).suppress(new Warning[]{Warning.NONFINAL_FIELDS}).usingGetClass().verify();
    }
}

