/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.messages.client;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.messages.MessageBatch;
import org.apache.druid.messages.client.MessageListener;
import org.apache.druid.messages.client.MessageRelay;
import org.apache.druid.messages.client.MessageRelayClient;
import org.apache.druid.messages.client.MessageRelays;
import org.apache.druid.messages.server.Outbox;
import org.apache.druid.messages.server.OutboxImpl;
import org.apache.druid.server.DruidNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageRelaysTest {
    private static final String MY_HOST = "me";
    private static final DruidNode OUTBOX_NODE = new DruidNode("service", "host", false, Integer.valueOf(80), Integer.valueOf(-1), true, false);
    private static final DiscoveryDruidNode OUTBOX_DISCO_NODE = new DiscoveryDruidNode(new DruidNode("service", "host", false, Integer.valueOf(80), Integer.valueOf(-1), true, false), NodeRole.HISTORICAL, Collections.emptyMap());
    private Outbox<String> outbox;
    private TestMessageListener messageListener;
    private TestDiscovery discovery;
    private MessageRelays<String> messageRelays;

    @Before
    public void setUp() {
        this.outbox = new OutboxImpl();
        this.messageListener = new TestMessageListener();
        this.discovery = new TestDiscovery();
        this.messageRelays = new MessageRelays(() -> this.discovery, node -> {
            Assert.assertEquals((Object)OUTBOX_NODE, (Object)node);
            return new MessageRelay(MY_HOST, node, (MessageRelayClient)new OutboxMessageRelayClient(this.outbox), (MessageListener)this.messageListener);
        });
        this.messageRelays.start();
    }

    @After
    public void tearDown() {
        this.messageRelays.stop();
        Assert.assertEquals(Collections.emptyList(), this.discovery.getListeners());
    }

    @Test
    public void test_serverAdded_thenRemoved() {
        this.discovery.fire(listener -> listener.nodesAdded(Collections.singletonList(OUTBOX_DISCO_NODE)));
        this.discovery.fire(listener -> listener.nodesRemoved(Collections.singletonList(OUTBOX_DISCO_NODE)));
        Assert.assertEquals((long)1L, (long)this.messageListener.getAdds());
        Assert.assertEquals((long)1L, (long)this.messageListener.getRemoves());
    }

    @Test
    public void test_messageListener() {
        this.discovery.fire(listener -> listener.nodesAdded(Collections.singletonList(OUTBOX_DISCO_NODE)));
        Assert.assertEquals((long)1L, (long)this.messageListener.getAdds());
        Assert.assertEquals((long)0L, (long)this.messageListener.getRemoves());
        ListenableFuture sendFuture = this.outbox.sendMessage(MY_HOST, (Object)"foo");
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo"), this.messageListener.getMessages());
        Assert.assertTrue((boolean)sendFuture.isDone());
        ListenableFuture sendFuture2 = this.outbox.sendMessage(MY_HOST, (Object)"bar");
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"bar"), this.messageListener.getMessages());
        Assert.assertTrue((boolean)sendFuture2.isDone());
    }

    private static class TestMessageListener
    implements MessageListener<String> {
        @GuardedBy(value="this")
        private long adds;
        @GuardedBy(value="this")
        private long removes;
        @GuardedBy(value="this")
        private final List<String> messages = new ArrayList<String>();

        private TestMessageListener() {
        }

        public synchronized void serverAdded(DruidNode node) {
            ++this.adds;
        }

        public synchronized void messageReceived(String message) {
            this.messages.add(message);
        }

        public synchronized void serverRemoved(DruidNode node) {
            ++this.removes;
        }

        public synchronized long getAdds() {
            return this.adds;
        }

        public synchronized long getRemoves() {
            return this.removes;
        }

        public synchronized List<String> getMessages() {
            return ImmutableList.copyOf(this.messages);
        }
    }

    private static class TestDiscovery
    implements DruidNodeDiscovery {
        @GuardedBy(value="this")
        private final List<DruidNodeDiscovery.Listener> listeners = new ArrayList<DruidNodeDiscovery.Listener>();

        public Collection<DiscoveryDruidNode> getAllNodes() {
            throw new UnsupportedOperationException();
        }

        public synchronized void registerListener(DruidNodeDiscovery.Listener listener) {
            this.listeners.add(listener);
        }

        public synchronized void removeListener(DruidNodeDiscovery.Listener listener) {
            this.listeners.remove(listener);
        }

        public synchronized List<DruidNodeDiscovery.Listener> getListeners() {
            return ImmutableList.copyOf(this.listeners);
        }

        public synchronized void fire(Consumer<DruidNodeDiscovery.Listener> f) {
            for (DruidNodeDiscovery.Listener listener : this.listeners) {
                f.accept(listener);
            }
        }
    }

    private static class OutboxMessageRelayClient
    implements MessageRelayClient<String> {
        private final Outbox<String> outbox;

        public OutboxMessageRelayClient(Outbox<String> outbox) {
            this.outbox = outbox;
        }

        public ListenableFuture<MessageBatch<String>> getMessages(String clientHost, long epoch, long startWatermark) {
            return this.outbox.getMessages(clientHost, epoch, startWatermark);
        }
    }
}

