/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import java.sql.Driver;
import java.util.List;
import java.util.Properties;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.druid.metadata.BasicDataSourceExt;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.assertj.core.util.Lists;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class BasicDataSourceExtTest {
    @Test
    public void testCreateConnectionFactory() throws Exception {
        MetadataStorageConnectorConfig connectorConfig = new MetadataStorageConnectorConfig(){
            private final List<String> passwords = Lists.newArrayList((Object[])new String[]{"pwd1", "pwd2"});

            public String getUser() {
                return "testuser";
            }

            public String getPassword() {
                return this.passwords.remove(0);
            }
        };
        BasicDataSourceExt basicDataSourceExt = new BasicDataSourceExt(connectorConfig);
        basicDataSourceExt.setConnectionProperties("p1=v1");
        basicDataSourceExt.addConnectionProperty("p2", "v2");
        Driver driver = (Driver)EasyMock.mock(Driver.class);
        Capture uriArg = Capture.newInstance();
        Capture propsArg = Capture.newInstance();
        EasyMock.expect((Object)driver.connect((String)EasyMock.capture((Capture)uriArg), (Properties)EasyMock.capture((Capture)propsArg))).andReturn(null).times(2);
        EasyMock.replay((Object[])new Object[]{driver});
        basicDataSourceExt.setDriver(driver);
        ConnectionFactory connectionFactory = basicDataSourceExt.createConnectionFactory();
        Properties expectedProps = new Properties();
        expectedProps.put("p1", "v1");
        expectedProps.put("p2", "v2");
        expectedProps.put("user", connectorConfig.getUser());
        Assert.assertNull((Object)connectionFactory.createConnection());
        Assert.assertEquals((Object)connectorConfig.getConnectURI(), (Object)uriArg.getValue());
        expectedProps.put("password", "pwd1");
        Assert.assertEquals((Object)expectedProps, (Object)propsArg.getValue());
        Assert.assertNull((Object)connectionFactory.createConnection());
        Assert.assertEquals((Object)connectorConfig.getConnectURI(), (Object)uriArg.getValue());
        expectedProps.put("password", "pwd2");
        Assert.assertEquals((Object)expectedProps, (Object)propsArg.getValue());
    }

    @Test
    public void testConnectionPropertiesHanding() {
        BasicDataSourceExt basicDataSourceExt = new BasicDataSourceExt((MetadataStorageConnectorConfig)EasyMock.mock(MetadataStorageConnectorConfig.class));
        Properties expectedProps = new Properties();
        basicDataSourceExt.setConnectionProperties("");
        Assert.assertEquals((Object)expectedProps, (Object)basicDataSourceExt.getConnectionProperties());
        basicDataSourceExt.setConnectionProperties("p0;p1=v1;p2=v2;p3=v3");
        basicDataSourceExt.addConnectionProperty("p4", "v4");
        basicDataSourceExt.addConnectionProperty("p5", "v5");
        basicDataSourceExt.removeConnectionProperty("p2");
        basicDataSourceExt.removeConnectionProperty("p5");
        expectedProps.put("p0", "");
        expectedProps.put("p1", "v1");
        expectedProps.put("p3", "v3");
        expectedProps.put("p4", "v4");
        Assert.assertEquals((Object)expectedProps, (Object)basicDataSourceExt.getConnectionProperties());
    }
}

