/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.metadata.SqlSegmentsMetadataQuery;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;

public class SqlSegmentsMetadataManagerTestBase {
    protected SqlSegmentsMetadataManager sqlSegmentsMetadataManager;
    protected SegmentSchemaCache segmentSchemaCache;
    protected SegmentSchemaManager segmentSchemaManager;
    protected TestDerbyConnector connector;
    protected SegmentsMetadataManagerConfig config;
    protected MetadataStorageTablesConfig storageConfig;
    protected final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
    protected final DataSegment segment1 = SqlSegmentsMetadataManagerTestBase.createSegment("wikipedia", "2012-03-15T00:00:00.000/2012-03-16T00:00:00.000", "2012-03-16T00:36:30.848Z", "index/y=2012/m=03/d=15/2012-03-16T00:36:30.848Z/0/index.zip", 0);
    protected final DataSegment segment2 = SqlSegmentsMetadataManagerTestBase.createSegment("wikipedia", "2012-01-05T00:00:00.000/2012-01-06T00:00:00.000", "2012-01-06T22:19:12.565Z", "wikipedia/index/y=2012/m=01/d=05/2012-01-06T22:19:12.565Z/0/index.zip", 0);

    protected void setUp(TestDerbyConnector.DerbyConnectorRule derbyConnectorRule) throws Exception {
        this.config = new SegmentsMetadataManagerConfig(Period.seconds((int)3), null, null);
        this.connector = derbyConnectorRule.getConnector();
        this.storageConfig = (MetadataStorageTablesConfig)derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.segmentSchemaCache = new SegmentSchemaCache();
        this.segmentSchemaManager = new SegmentSchemaManager((MetadataStorageTablesConfig)derbyConnectorRule.metadataTablesConfigSupplier().get(), this.jsonMapper, (SQLMetadataConnector)this.connector);
        this.sqlSegmentsMetadataManager = new SqlSegmentsMetadataManager(this.jsonMapper, Suppliers.ofInstance((Object)this.config), derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)this.connector, this.segmentSchemaCache, CentralizedDatasourceSchemaConfig.create(), (ServiceEmitter)NoopServiceEmitter.instance());
        this.sqlSegmentsMetadataManager.start();
        this.connector.createSegmentSchemasTable();
        this.connector.createSegmentTable();
    }

    protected void teardownManager() {
        if (this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically()) {
            this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
        }
        this.sqlSegmentsMetadataManager.stop();
    }

    protected void publishSegment(DataSegment segment) {
        SqlSegmentsMetadataManagerTestBase.publishSegment((SQLMetadataConnector)this.connector, this.storageConfig, this.jsonMapper, segment);
    }

    protected int markSegmentsAsUnused(SegmentId ... segmentIds) {
        return SqlSegmentsMetadataManagerTestBase.markSegmentsAsUnused(Set.of(segmentIds), (SQLMetadataConnector)this.connector, this.storageConfig, this.jsonMapper, DateTimes.nowUtc());
    }

    public static int markSegmentsAsUnused(Set<SegmentId> segmentIds, SQLMetadataConnector connector, MetadataStorageTablesConfig storageConfig, ObjectMapper jsonMapper, DateTime updateTime) {
        return (Integer)connector.retryWithHandle(handle -> SqlSegmentsMetadataQuery.forHandle((Handle)handle, (SQLMetadataConnector)connector, (MetadataStorageTablesConfig)storageConfig, (ObjectMapper)jsonMapper).markSegmentsAsUnused(segmentIds, updateTime));
    }

    protected static DataSegment createSegment(String dataSource, String interval, String version, String bucketKey, int binaryVersion) {
        return new DataSegment(dataSource, Intervals.of((String)interval), version, (Map)ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)"test", (Object)"key", (Object)(dataSource + "/" + bucketKey)), (List)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3"), (List)ImmutableList.of((Object)"count", (Object)"value"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(binaryVersion), 1234L);
    }

    public static void publishSegment(SQLMetadataConnector connector, MetadataStorageTablesConfig config, ObjectMapper jsonMapper, DataSegment segment) {
        String now = DateTimes.nowUtc().toString();
        try {
            DBI dbi = connector.getDBI();
            List exists = (List)dbi.withHandle(handle -> ((Query)handle.createQuery(StringUtils.format((String)"SELECT id FROM %s WHERE id=:id", (Object[])new Object[]{config.getSegmentsTable()})).bind("id", segment.getId().toString())).list());
            if (!exists.isEmpty()) {
                return;
            }
            String publishStatement = StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload, used_status_last_updated) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload, :used_status_last_updated)", (Object[])new Object[]{config.getSegmentsTable(), connector.getQuoteString()});
            byte[] payload = jsonMapper.writeValueAsBytes((Object)segment);
            dbi.withHandle(handle -> {
                ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(publishStatement).bind("id", segment.getId().toString())).bind("dataSource", segment.getDataSource())).bind("created_date", now)).bind("start", segment.getInterval().getStart().toString())).bind("end", segment.getInterval().getEnd().toString())).bind("partitioned", !(segment.getShardSpec() instanceof NoneShardSpec))).bind("version", segment.getVersion())).bind("used", true)).bind("payload", payload)).bind("used_status_last_updated", now)).execute();
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

