/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.SimpleServerView;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.MapCache;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.DefaultBlockingPool;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerBasedOnClusteredClientTestBase;
import org.apache.druid.query.Result;
import org.apache.druid.query.ResultLevelCachingQueryRunner;
import org.apache.druid.query.RetryQueryRunner;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;

public class ResultLevelCachingQueryRunnerTest
extends QueryRunnerBasedOnClusteredClientTestBase {
    private Cache cache;
    private static final int DEFAULT_CACHE_ENTRY_MAX_SIZE = Integer.MAX_VALUE;

    @Before
    public void setup() {
        this.cache = MapCache.create((long)1024L);
    }

    @After
    public void tearDown() throws IOException {
        this.cache.close();
    }

    @Test
    public void testNotPopulateAndNotUse() {
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = ResultLevelCachingQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner1 = this.createQueryRunner(this.newCacheConfig(false, false, Integer.MAX_VALUE), query);
        Sequence sequence1 = queryRunner1.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results1 = sequence1.toList();
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner2 = this.createQueryRunner(this.newCacheConfig(false, false, Integer.MAX_VALUE), query);
        Sequence sequence2 = queryRunner2.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results2 = sequence2.toList();
        Assert.assertEquals((Object)results1, (Object)results2);
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
        this.emitter.verifyNotEmitted("query/resultCache/hit");
    }

    @Test
    public void testPopulateAndNotUse() {
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = ResultLevelCachingQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner1 = this.createQueryRunner(this.newCacheConfig(true, false, Integer.MAX_VALUE), query);
        Sequence sequence1 = queryRunner1.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results1 = sequence1.toList();
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
        this.emitter.verifyNotEmitted("query/resultCache/hit");
        this.emitter.flush();
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner2 = this.createQueryRunner(this.newCacheConfig(true, false, Integer.MAX_VALUE), query);
        Sequence sequence2 = queryRunner2.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results2 = sequence2.toList();
        Assert.assertEquals((Object)results1, (Object)results2);
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
        this.emitter.verifyNotEmitted("query/resultCache/hit");
    }

    @Test
    public void testNotPopulateAndUse() {
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = ResultLevelCachingQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner1 = this.createQueryRunner(this.newCacheConfig(false, false, Integer.MAX_VALUE), query);
        Sequence sequence1 = queryRunner1.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results1 = sequence1.toList();
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
        this.emitter.verifyNotEmitted("query/resultCache/hit");
        this.emitter.flush();
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner2 = this.createQueryRunner(this.newCacheConfig(false, true, Integer.MAX_VALUE), query);
        Sequence sequence2 = queryRunner2.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results2 = sequence2.toList();
        Assert.assertEquals((Object)results1, (Object)results2);
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumMisses());
        this.emitter.verifyEmitted("query/resultCache/hit", 1);
        this.emitter.verifyValue("query/resultCache/hit", (Number)0);
    }

    @Test
    public void testPopulateAndUse() {
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = ResultLevelCachingQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner1 = this.createQueryRunner(this.newCacheConfig(true, true, Integer.MAX_VALUE), query);
        Sequence sequence1 = queryRunner1.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results1 = sequence1.toList();
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumMisses());
        this.emitter.verifyEmitted("query/resultCache/hit", 1);
        this.emitter.verifyValue("query/resultCache/hit", (Number)0);
        this.emitter.flush();
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner2 = this.createQueryRunner(this.newCacheConfig(true, true, Integer.MAX_VALUE), query);
        Sequence sequence2 = queryRunner2.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results2 = sequence2.toList();
        Assert.assertEquals((Object)results1, (Object)results2);
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumMisses());
        this.emitter.verifyEmitted("query/resultCache/hit", 1);
        this.emitter.verifyValue("query/resultCache/hit", (Number)1);
    }

    @Test
    public void testNoPopulateIfEntrySizeExceedsMaximum() {
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = ResultLevelCachingQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner1 = this.createQueryRunner(this.newCacheConfig(true, true, 128), query);
        Sequence sequence1 = queryRunner1.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results1 = sequence1.toList();
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumMisses());
        this.emitter.verifyEmitted("query/resultCache/hit", 1);
        this.emitter.verifyValue("query/resultCache/hit", (Number)0);
        this.emitter.flush();
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner2 = this.createQueryRunner(this.newCacheConfig(true, true, Integer.MAX_VALUE), query);
        Sequence sequence2 = queryRunner2.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results2 = sequence2.toList();
        Assert.assertEquals((Object)results1, (Object)results2);
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)2L, (long)this.cache.getStats().getNumMisses());
        this.emitter.verifyEmitted("query/resultCache/hit", 1);
        this.emitter.verifyValue("query/resultCache/hit", (Number)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPopulateCacheWhenQueryThrowExceptionShouldNotCache() {
        Interval interval = Intervals.of((String)"2000-01-01/PT1H");
        DataSegment segment = ResultLevelCachingQueryRunnerTest.newSegment(interval, 0, 1);
        this.addServer(SimpleServerView.createServer(0), segment, this.generateSegment(segment), true);
        Query<Result<TimeseriesResultValue>> query = ResultLevelCachingQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner = this.createQueryRunner(this.newCacheConfig(true, false, Integer.MAX_VALUE), query);
        Sequence sequence = queryRunner.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        try {
            sequence.toList();
            Assert.fail((String)"Expected to throw an exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Exception for testing", (Object)e.getMessage());
        }
        finally {
            Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
            Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
            Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
            this.emitter.verifyNotEmitted("query/resultCache/hit");
        }
    }

    @Test
    public void testUseCacheAndReleaseResourceFromClient() {
        DefaultBlockingPool mergePool = new DefaultBlockingPool(() -> ByteBuffer.allocate(1), 1);
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = ResultLevelCachingQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        CacheConfig cacheConfig = this.newCacheConfig(true, true, Integer.MAX_VALUE);
        QueryRunner baseRunner = this.cachingClusteredClient.getQueryRunnerForIntervals(query, (Iterable)query.getIntervals());
        RetryQueryRunner spyRunner = (RetryQueryRunner)Mockito.spy((Object)new RetryQueryRunner(baseRunner, (arg_0, arg_1) -> ((CachingClusteredClient)this.cachingClusteredClient).getQueryRunnerForSegments(arg_0, arg_1), new RetryQueryRunnerConfig(), this.objectMapper));
        ((RetryQueryRunner)Mockito.doAnswer(arg_0 -> ResultLevelCachingQueryRunnerTest.lambda$testUseCacheAndReleaseResourceFromClient$2((BlockingPool)mergePool, arg_0)).when((Object)spyRunner)).run((QueryPlus)ArgumentMatchers.any(), (ResponseContext)ArgumentMatchers.any());
        ResultLevelCachingQueryRunner queryRunner1 = new ResultLevelCachingQueryRunner((QueryRunner)spyRunner, this.conglomerate.getToolChest(query), query, this.objectMapper, this.cache, cacheConfig, (ServiceEmitter)this.emitter);
        Sequence sequence1 = queryRunner1.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results1 = sequence1.toList();
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumMisses());
        this.emitter.verifyEmitted("query/resultCache/hit", 1);
        this.emitter.verifyValue("query/resultCache/hit", (Number)0);
        this.emitter.flush();
        Sequence sequence2 = queryRunner1.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results2 = sequence2.toList();
        Assert.assertEquals((Object)results1, (Object)results2);
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumMisses());
        this.emitter.verifyEmitted("query/resultCache/hit", 1);
        this.emitter.verifyValue("query/resultCache/hit", (Number)1);
        this.emitter.flush();
        Sequence sequence3 = queryRunner1.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext());
        List results3 = sequence3.toList();
        Assert.assertEquals((Object)results1, (Object)results3);
        Assert.assertEquals((long)2L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumMisses());
        this.emitter.verifyEmitted("query/resultCache/hit", 1);
        this.emitter.verifyValue("query/resultCache/hit", (Number)1);
    }

    @Test
    public void testPopulateCacheThrowsException() {
        this.cache = (Cache)Mockito.spy((Object)this.cache);
        ((Cache)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("some error")}).when((Object)this.cache)).put((Cache.NamedKey)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = ResultLevelCachingQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        ResultLevelCachingQueryRunner<Result<TimeseriesResultValue>> queryRunner1 = this.createQueryRunner(this.newCacheConfig(true, true, Integer.MAX_VALUE), query);
        queryRunner1.run(QueryPlus.wrap(query), ResultLevelCachingQueryRunnerTest.responseContext()).toList();
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumMisses());
        this.emitter.verifyEmitted("query/resultCache/hit", 1);
        this.emitter.verifyValue("query/resultCache/hit", (Number)0);
    }

    private <T> ResultLevelCachingQueryRunner<T> createQueryRunner(CacheConfig cacheConfig, Query<T> query) {
        QueryRunner baseRunner = this.cachingClusteredClient.getQueryRunnerForIntervals(query, (Iterable)query.getIntervals());
        return new ResultLevelCachingQueryRunner((QueryRunner)new RetryQueryRunner(baseRunner, (arg_0, arg_1) -> ((CachingClusteredClient)this.cachingClusteredClient).getQueryRunnerForSegments(arg_0, arg_1), new RetryQueryRunnerConfig(), this.objectMapper), this.conglomerate.getToolChest(query), query, this.objectMapper, this.cache, cacheConfig, (ServiceEmitter)this.emitter);
    }

    private CacheConfig newCacheConfig(final boolean populateResultLevelCache, final boolean useResultLevelCache, final int resultLevelCacheLimit) {
        return new CacheConfig(){

            public boolean isPopulateResultLevelCache() {
                return populateResultLevelCache;
            }

            public boolean isUseResultLevelCache() {
                return useResultLevelCache;
            }

            public int getResultLevelCacheLimit() {
                return resultLevelCacheLimit;
            }
        };
    }

    private static /* synthetic */ Object lambda$testUseCacheAndReleaseResourceFromClient$2(BlockingPool mergePool, InvocationOnMock invocation) throws Throwable {
        List resource = mergePool.takeBatch(1, 1L);
        if (resource.isEmpty()) {
            Assert.fail((String)"Resource should not be empty");
        }
        Sequence realSequence = (Sequence)invocation.callRealMethod();
        Closer closer = Closer.create();
        closer.register(() -> resource.forEach(ReferenceCountingResourceHolder::close));
        return Sequences.withBaggage((Sequence)realSequence, (Closeable)closer);
    }
}

