/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.druid.rpc.FixedServiceLocator;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocations;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.junit.Assert;
import org.junit.Test;

public class FixedServiceLocatorTest {
    public static final DruidServerMetadata DATA_SERVER_1 = new DruidServerMetadata("TestDataServer", "hostName:9092", null, 2L, ServerType.REALTIME, "tier1", 2);
    public static final DruidServerMetadata DATA_SERVER_2 = new DruidServerMetadata("TestDataServer", "hostName:8083", null, 2L, ServerType.REALTIME, "tier1", 2);

    @Test
    public void test_constructor_rejectsNull() {
        Assert.assertThrows(NullPointerException.class, () -> new FixedServiceLocator((ServiceLocation)null));
        Assert.assertThrows(NullPointerException.class, () -> new FixedServiceLocator((ServiceLocations)null));
    }

    @Test
    public void test_locate_singleServer() throws ExecutionException, InterruptedException {
        FixedServiceLocator serviceLocator = new FixedServiceLocator(ServiceLocation.fromDruidServerMetadata((DruidServerMetadata)DATA_SERVER_1));
        Assert.assertEquals((Object)ServiceLocations.forLocation((ServiceLocation)ServiceLocation.fromDruidServerMetadata((DruidServerMetadata)DATA_SERVER_1)), (Object)serviceLocator.locate().get());
    }

    @Test
    public void test_locate_afterClose() throws ExecutionException, InterruptedException {
        FixedServiceLocator serviceLocator = new FixedServiceLocator(ServiceLocation.fromDruidServerMetadata((DruidServerMetadata)DATA_SERVER_1));
        serviceLocator.close();
        Assert.assertEquals((Object)ServiceLocations.closed(), (Object)serviceLocator.locate().get());
    }

    @Test
    public void test_locate_multipleServers() throws ExecutionException, InterruptedException {
        ServiceLocations locations = ServiceLocations.forLocations((Set)ImmutableSet.of((Object)ServiceLocation.fromDruidServerMetadata((DruidServerMetadata)DATA_SERVER_1), (Object)ServiceLocation.fromDruidServerMetadata((DruidServerMetadata)DATA_SERVER_2)));
        FixedServiceLocator serviceLocator = new FixedServiceLocator(locations);
        Assert.assertEquals((Object)locations, (Object)serviceLocator.locate().get());
    }
}

