/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.indexer.granularity.ArbitraryGranularitySpec;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.granularity.UniformGranularitySpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.DurationGranularity;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.indexing.CombinedDataSchema;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.TestModifiedDataSchema;
import org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class DataSchemaTest
extends InitializedNullHandlingTest {
    private static ArbitraryGranularitySpec ARBITRARY_GRANULARITY = new ArbitraryGranularitySpec(Granularities.DAY, (List)ImmutableList.of((Object)Intervals.of((String)"2014/2015")));
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();

    DataSchemaTest() {
    }

    @Test
    void testDefaultExclusions() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dimB", (Object)"dimA"))), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parser).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"__time", (Object)"time", (Object)"col1", (Object)"col2", (Object)"metric1", (Object)"metric2", (Object[])new String[0]), (Object)schema.getDimensionsSpec().getDimensionExclusions());
    }

    @Test
    void testExplicitInclude() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"dimA", (Object)"dimB", (Object)"col2"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build(), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parser).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"__time", (Object)"dimC", (Object)"col1", (Object)"metric1", (Object)"metric2"), (Object)schema.getParser().getParseSpec().getDimensionsSpec().getDimensionExclusions());
    }

    @Test
    void testTransformSpec() {
        Map parserMap = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"dimA", (Object)"dimB", (Object)"col2"))), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parserMap).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withTransform(new TransformSpec((DimFilter)new SelectorDimFilter("dimA", "foo", null), (List)ImmutableList.of((Object)new ExpressionTransform("expr", "concat(dimA,dimA)", TestExprMacroTable.INSTANCE)))).withObjectMapper(this.jsonMapper).build();
        StringInputRowParser parser = (StringInputRowParser)schema.getParser();
        InputRow row1bb = (InputRow)parser.parseBatch(ByteBuffer.wrap("{\"time\":\"2000-01-01\",\"dimA\":\"foo\"}".getBytes(StandardCharsets.UTF_8))).get(0);
        Assertions.assertEquals((Object)DateTimes.of((String)"2000-01-01"), (Object)row1bb.getTimestamp());
        Assertions.assertEquals((Object)"foo", (Object)row1bb.getRaw("dimA"));
        Assertions.assertEquals((Object)"foofoo", (Object)row1bb.getRaw("expr"));
        InputRow row1string = parser.parse("{\"time\":\"2000-01-01\",\"dimA\":\"foo\"}");
        Assertions.assertEquals((Object)DateTimes.of((String)"2000-01-01"), (Object)row1string.getTimestamp());
        Assertions.assertEquals((Object)"foo", (Object)row1string.getRaw("dimA"));
        Assertions.assertEquals((Object)"foofoo", (Object)row1string.getRaw("expr"));
        InputRow row2 = (InputRow)parser.parseBatch(ByteBuffer.wrap("{\"time\":\"2000-01-01\",\"dimA\":\"x\"}".getBytes(StandardCharsets.UTF_8))).get(0);
        Assertions.assertNull((Object)row2);
    }

    @Test
    void testOverlapMetricNameAndDim() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"dimA", (Object)"dimB", (Object)"metric1"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build(), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parser).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        Throwable t = Assertions.assertThrows(DruidException.class, () -> schema.getParser());
        Assertions.assertEquals((Object)"Cannot specify a column more than once: [metric1] seen in dimensions list, metricsSpec list", (Object)t.getMessage());
    }

    @Test
    void testOverlapTimeAndDimPositionZero() {
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withTimestamp(new TimestampSpec("time", "auto", null)).withDimensions(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new LongDimensionSchema("__time"), (Object)new StringDimensionSchema("dimA"), (Object)new StringDimensionSchema("dimB"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build()).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        Assertions.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"dimA", (Object)"dimB"), (Object)schema.getDimensionsSpec().getDimensionNames());
        Assertions.assertTrue((boolean)schema.getDimensionsSpec().isForceSegmentSortByTime());
    }

    @Test
    void testOverlapTimeAndDimPositionZeroWrongType() {
        Throwable t = Assertions.assertThrows(DruidException.class, () -> DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withTimestamp(new TimestampSpec("time", "auto", null)).withDimensions(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("__time"), (Object)new StringDimensionSchema("dimA"), (Object)new StringDimensionSchema("dimB"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build()).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build());
        Assertions.assertEquals((Object)"Encountered dimension[__time] with incorrect type[STRING]. Type must be 'long'.", (Object)t.getMessage());
    }

    @Test
    void testOverlapTimeAndDimPositionOne() {
        Throwable t = Assertions.assertThrows(DruidException.class, () -> DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withTimestamp(new TimestampSpec("time", "auto", null)).withDimensions(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("dimA"), (Object)new LongDimensionSchema("__time"), (Object)new StringDimensionSchema("dimB"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build()).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build());
        Assertions.assertEquals((Object)("Encountered dimension[__time] at position[1]. This is only supported when the dimensionsSpec parameter[forceSegmentSortByTime] is set to[false]. " + DimensionsSpec.WARNING_NON_TIME_SORT_ORDER), (Object)t.getMessage());
    }

    @Test
    void testOverlapTimeAndDimPositionOne_withExplicitSortOrder() {
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withTimestamp(new TimestampSpec("time", "auto", null)).withDimensions(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("dimA"), (Object)new LongDimensionSchema("__time"), (Object)new StringDimensionSchema("dimB"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).setForceSegmentSortByTime(Boolean.valueOf(false)).build()).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        Assertions.assertEquals((Object)ImmutableList.of((Object)"dimA", (Object)"__time", (Object)"dimB"), (Object)schema.getDimensionsSpec().getDimensionNames());
        Assertions.assertFalse((boolean)schema.getDimensionsSpec().isForceSegmentSortByTime());
    }

    @Test
    void testOverlapTimeAndDimLegacy() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"__time", (Object)"dimA", (Object)"dimB", (Object)"metric1"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build(), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parser).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        Throwable t = Assertions.assertThrows(DruidException.class, () -> schema.getParser());
        Assertions.assertEquals((Object)"Encountered dimension[__time] with incorrect type[STRING]. Type must be 'long'.", (Object)t.getMessage());
    }

    @Test
    void testDuplicateAggregators() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build(), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Throwable t = Assertions.assertThrows(DruidException.class, () -> DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parser).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2"), new DoubleSumAggregatorFactory("metric1", "col3"), new DoubleSumAggregatorFactory("metric3", "col4"), new DoubleSumAggregatorFactory("metric3", "col5")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build());
        Assertions.assertEquals((Object)"Cannot specify a column more than once: [metric1] seen in metricsSpec list (2 occurrences); [metric3] seen in metricsSpec list (2 occurrences)", (Object)t.getMessage());
    }

    @Test
    void testSerdeWithInvalidParserMap() throws Exception {
        String jsonStr = "{\"dataSource\":\"" + StringEscapeUtils.escapeJson((String)"alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!") + "\",\"parser\":{\"type\":\"invalid\"},\"metricsSpec\":[{\"type\":\"doubleSum\",\"name\":\"metric1\",\"fieldName\":\"col1\"}],\"granularitySpec\":{\"type\":\"arbitrary\",\"queryGranularity\":{\"type\":\"duration\",\"duration\":86400000,\"origin\":\"1970-01-01T00:00:00.000Z\"},\"intervals\":[\"2014-01-01T00:00:00.000Z/2015-01-01T00:00:00.000Z\"]}}";
        DataSchema schema = (DataSchema)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString(this.jsonMapper.readValue(jsonStr, DataSchema.class)), DataSchema.class);
        Throwable t = Assertions.assertThrows(IllegalArgumentException.class, () -> schema.getParser());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)Matchers.startsWith((String)"Cannot construct instance of `org.apache.druid.data.input.impl.StringInputRowParser`, problem: parseSpec"));
        MatcherAssert.assertThat((Object)t.getCause(), (Matcher)Matchers.instanceOf(JsonMappingException.class));
    }

    @Test
    void testEmptyDatasource() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"dimA", (Object)"dimB", (Object)"col2"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build(), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DruidExceptionMatcher.ThrowingSupplier thrower = () -> DataSchema.builder().withDataSource("").withParserMap(parser).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [dataSource]: must not be null").assertThrowsAndMatches(thrower);
    }

    @Test
    void testInvalidWhitespaceDatasource() {
        ImmutableMap invalidCharToDataSourceName = ImmutableMap.of((Object)"\\t", (Object)"\tab\t", (Object)"\\r", (Object)"\rcarriage\return\r", (Object)"\\n", (Object)"\nnew\nline\n");
        for (Map.Entry entry : invalidCharToDataSourceName.entrySet()) {
            String dataSource = (String)entry.getValue();
            String msg = StringUtils.format((String)"Invalid value for field [dataSource]: Value [%s] contains illegal whitespace characters.  Only space is allowed.", (Object[])new Object[]{dataSource});
            DruidExceptionMatcher.invalidInput().expectMessageIs(msg).assertThrowsAndMatches(() -> DataSchema.builder().withDataSource(dataSource).withParserMap(Collections.emptyMap()).withObjectMapper(this.jsonMapper).build());
        }
    }

    @Test
    void testSerde() throws Exception {
        String jsonStr = "{\"dataSource\":\"" + StringEscapeUtils.escapeJson((String)"alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!") + "\",\"parser\":{\"type\":\"string\",\"parseSpec\":{\"format\":\"json\",\"timestampSpec\":{\"column\":\"xXx\", \"format\": \"auto\", \"missingValue\": null},\"dimensionsSpec\":{\"dimensions\":[], \"dimensionExclusions\":[]},\"flattenSpec\":{\"useFieldDiscovery\":true, \"fields\":[]},\"featureSpec\":{}},\"encoding\":\"UTF-8\"},\"metricsSpec\":[{\"type\":\"doubleSum\",\"name\":\"metric1\",\"fieldName\":\"col1\"}],\"granularitySpec\":{\"type\":\"arbitrary\",\"queryGranularity\":{\"type\":\"duration\",\"duration\":86400000,\"origin\":\"1970-01-01T00:00:00.000Z\"},\"intervals\":[\"2014-01-01T00:00:00.000Z/2015-01-01T00:00:00.000Z\"]}}";
        DataSchema actual = (DataSchema)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString(this.jsonMapper.readValue(jsonStr, DataSchema.class)), DataSchema.class);
        Assertions.assertEquals((Object)"alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!", (Object)actual.getDataSource());
        Assertions.assertEquals((Object)new JSONParseSpec(new TimestampSpec("xXx", null, null), DimensionsSpec.builder().setDimensionExclusions(Arrays.asList("__time", "metric1", "xXx", "col1")).build(), null, null, null), (Object)actual.getParser().getParseSpec());
        Assertions.assertArrayEquals((Object[])new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1")}, (Object[])actual.getAggregators());
        Assertions.assertEquals((Object)new ArbitraryGranularitySpec((Granularity)new DurationGranularity(86400000L, null), (List)ImmutableList.of((Object)Intervals.of((String)"2014/2015"))), (Object)actual.getGranularitySpec());
        Assertions.assertNull((Object)actual.getProjections());
    }

    @Test
    public void testSerdeWithProjections() throws Exception {
        AggregateProjectionSpec projectionSpec = new AggregateProjectionSpec("ab_count_projection", null, Arrays.asList(new StringDimensionSchema("a"), new LongDimensionSchema("b")), new AggregatorFactory[]{new CountAggregatorFactory("count")});
        DataSchema original = DataSchema.builder().withDataSource("datasource").withTimestamp(new TimestampSpec(null, null, null)).withDimensions(DimensionsSpec.EMPTY).withAggregators(new AggregatorFactory[]{new CountAggregatorFactory("rows")}).withProjections((List)ImmutableList.of((Object)projectionSpec)).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).build();
        DataSchema serdeResult = (DataSchema)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString((Object)original), DataSchema.class);
        Assertions.assertEquals((Object)"datasource", (Object)serdeResult.getDataSource());
        Assertions.assertArrayEquals((Object[])new AggregatorFactory[]{new CountAggregatorFactory("rows")}, (Object[])serdeResult.getAggregators());
        Assertions.assertEquals((Object)ImmutableList.of((Object)projectionSpec), (Object)serdeResult.getProjections());
        Assertions.assertEquals((Object)ImmutableList.of((Object)"ab_count_projection"), (Object)serdeResult.getProjectionNames());
        Assertions.assertEquals((Object)this.jsonMapper.writeValueAsString((Object)original), (Object)this.jsonMapper.writeValueAsString((Object)serdeResult));
    }

    @Test
    void testSerializeWithInvalidDataSourceName() throws Exception {
        ImmutableMap datasourceToErrorMsg = ImmutableMap.of((Object)"", (Object)"Invalid value for field [dataSource]: must not be null", (Object)"../invalid", (Object)"Invalid value for field [dataSource]: Value [../invalid] cannot start with '.'.", (Object)"\tname", (Object)"Invalid value for field [dataSource]: Value [\tname] contains illegal whitespace characters.  Only space is allowed.", (Object)"name\t invalid", (Object)"Invalid value for field [dataSource]: Value [name\t invalid] contains illegal whitespace characters.  Only space is allowed.");
        for (Map.Entry entry : datasourceToErrorMsg.entrySet()) {
            String jsonStr = "{\"dataSource\":\"" + StringEscapeUtils.escapeJson((String)((String)entry.getKey())) + "\",\"parser\":{\"type\":\"string\",\"parseSpec\":{\"format\":\"json\",\"timestampSpec\":{\"column\":\"xXx\", \"format\": \"auto\", \"missingValue\": null},\"dimensionsSpec\":{\"dimensions\":[], \"dimensionExclusions\":[]},\"flattenSpec\":{\"useFieldDiscovery\":true, \"fields\":[]},\"featureSpec\":{}},\"encoding\":\"UTF-8\"},\"metricsSpec\":[{\"type\":\"doubleSum\",\"name\":\"metric1\",\"fieldName\":\"col1\"}],\"granularitySpec\":{\"type\":\"arbitrary\",\"queryGranularity\":{\"type\":\"duration\",\"duration\":86400000,\"origin\":\"1970-01-01T00:00:00.000Z\"},\"intervals\":[\"2014-01-01T00:00:00.000Z/2015-01-01T00:00:00.000Z\"]}}";
            try {
                this.jsonMapper.readValue(this.jsonMapper.writeValueAsString(this.jsonMapper.readValue(jsonStr, DataSchema.class)), DataSchema.class);
            }
            catch (ValueInstantiationException e) {
                MatcherAssert.assertThat((String)((String)entry.getKey()), (Object)e.getCause(), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs((String)entry.getValue()));
                continue;
            }
            Assertions.fail((String)("Serialization of datasource " + (String)entry.getKey() + " should have failed."));
        }
    }

    @Test
    void testSerdeWithUpdatedDataSchemaAddedField() throws IOException {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dimB", (Object)"dimA"))), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema originalSchema = DataSchema.builder().withDataSource("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!").withParserMap(parser).withAggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}).withGranularity((GranularitySpec)ARBITRARY_GRANULARITY).withObjectMapper(this.jsonMapper).build();
        String serialized = this.jsonMapper.writeValueAsString((Object)originalSchema);
        TestModifiedDataSchema deserialized = (TestModifiedDataSchema)((Object)this.jsonMapper.readValue(serialized, TestModifiedDataSchema.class));
        Assertions.assertEquals(null, (Object)deserialized.getExtra());
        Assertions.assertEquals((Object)originalSchema.getDataSource(), (Object)deserialized.getDataSource());
        Assertions.assertEquals((Object)originalSchema.getGranularitySpec(), (Object)deserialized.getGranularitySpec());
        Assertions.assertEquals((Object)originalSchema.getParser().getParseSpec(), (Object)deserialized.getParser().getParseSpec());
        Assertions.assertArrayEquals((Object[])originalSchema.getAggregators(), (Object[])deserialized.getAggregators());
        Assertions.assertEquals((Object)originalSchema.getTransformSpec(), (Object)deserialized.getTransformSpec());
        Assertions.assertEquals((Object)originalSchema.getParserMap(), (Object)deserialized.getParserMap());
    }

    @Test
    void testSerdeWithUpdatedDataSchemaRemovedField() throws IOException {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dimB", (Object)"dimA"))), null, null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        TestModifiedDataSchema originalSchema = new TestModifiedDataSchema("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!", null, null, new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}, (GranularitySpec)ARBITRARY_GRANULARITY, null, parser, this.jsonMapper, "some arbitrary string");
        String serialized = this.jsonMapper.writeValueAsString((Object)originalSchema);
        DataSchema deserialized = (DataSchema)this.jsonMapper.readValue(serialized, DataSchema.class);
        Assertions.assertEquals((Object)originalSchema.getDataSource(), (Object)deserialized.getDataSource());
        Assertions.assertEquals((Object)originalSchema.getGranularitySpec(), (Object)deserialized.getGranularitySpec());
        Assertions.assertEquals((Object)originalSchema.getParser().getParseSpec(), (Object)deserialized.getParser().getParseSpec());
        Assertions.assertArrayEquals((Object[])originalSchema.getAggregators(), (Object[])deserialized.getAggregators());
        Assertions.assertEquals((Object)originalSchema.getTransformSpec(), (Object)deserialized.getTransformSpec());
        Assertions.assertEquals((Object)originalSchema.getParserMap(), (Object)deserialized.getParserMap());
    }

    @Test
    void testWithDimensionSpec() {
        TimestampSpec tsSpec = (TimestampSpec)Mockito.mock(TimestampSpec.class);
        GranularitySpec gSpec = (GranularitySpec)Mockito.mock(GranularitySpec.class);
        DimensionsSpec oldDimSpec = (DimensionsSpec)Mockito.mock(DimensionsSpec.class);
        DimensionsSpec newDimSpec = (DimensionsSpec)Mockito.mock(DimensionsSpec.class);
        AggregatorFactory aggFactory = (AggregatorFactory)Mockito.mock(AggregatorFactory.class);
        Mockito.when((Object)aggFactory.getName()).thenReturn((Object)"myAgg");
        TransformSpec transSpec = (TransformSpec)Mockito.mock(TransformSpec.class);
        Map parserMap = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)newDimSpec.withDimensionExclusions((Set)ArgumentMatchers.any(Set.class))).thenReturn((Object)newDimSpec);
        DataSchema oldSchema = DataSchema.builder().withDataSource("dataSource").withTimestamp(tsSpec).withDimensions(oldDimSpec).withAggregators(new AggregatorFactory[]{aggFactory}).withGranularity(gSpec).withTransform(transSpec).withParserMap(parserMap).withObjectMapper(this.jsonMapper).build();
        DataSchema newSchema = oldSchema.withDimensionsSpec(newDimSpec);
        Assertions.assertSame((Object)oldSchema.getDataSource(), (Object)newSchema.getDataSource());
        Assertions.assertSame((Object)oldSchema.getTimestampSpec(), (Object)newSchema.getTimestampSpec());
        Assertions.assertSame((Object)newDimSpec, (Object)newSchema.getDimensionsSpec());
        Assertions.assertSame((Object)oldSchema.getAggregators(), (Object)newSchema.getAggregators());
        Assertions.assertSame((Object)oldSchema.getGranularitySpec(), (Object)newSchema.getGranularitySpec());
        Assertions.assertSame((Object)oldSchema.getTransformSpec(), (Object)newSchema.getTransformSpec());
        Assertions.assertSame((Object)oldSchema.getParserMap(), (Object)newSchema.getParserMap());
    }

    @Test
    void testCombinedDataSchemaSetsMultiValuedColumnsInfo() {
        ImmutableSet multiValuedDimensions = ImmutableSet.of((Object)"dimA");
        CombinedDataSchema schema = new CombinedDataSchema("alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!", new TimestampSpec("time", "auto", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dimA", (Object)"dimB", (Object)"metric1"))).setDimensionExclusions((List)ImmutableList.of((Object)"dimC")).build(), null, (GranularitySpec)ARBITRARY_GRANULARITY, null, null, (Set)multiValuedDimensions);
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"dimA"), (Object)schema.getMultiValuedDimensions());
    }

    @Test
    void testInvalidProjectionDupeNames() {
        Throwable t = Assertions.assertThrows(DruidException.class, () -> DataSchema.builder().withDataSource("dataSource").withGranularity((GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.NONE, Boolean.valueOf(false), List.of(Intervals.of((String)"2014/2015")))).withProjections(List.of(new AggregateProjectionSpec("some projection", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"g")}), List.of(new LongDimensionSchema("g")), new AggregatorFactory[]{new CountAggregatorFactory("count")}), new AggregateProjectionSpec("some projection", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.MINUTE, (String)"g")}), List.of(new LongDimensionSchema("g")), new AggregatorFactory[]{new CountAggregatorFactory("count")}))).build());
        Assertions.assertEquals((Object)"projection[some projection] is already defined, projection names must be unique", (Object)t.getMessage());
    }

    @Test
    void testInvalidProjectionGranularity() {
        Throwable t = Assertions.assertThrows(DruidException.class, () -> DataSchema.builder().withDataSource("dataSource").withGranularity((GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.NONE, Boolean.valueOf(false), List.of(Intervals.of((String)"2014/2015")))).withProjections(List.of(new AggregateProjectionSpec("ok granularity", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"g")}), List.of(new LongDimensionSchema("g")), new AggregatorFactory[]{new CountAggregatorFactory("count")}), new AggregateProjectionSpec("acceptable granularity", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.MINUTE, (String)"g")}), List.of(new LongDimensionSchema("g")), new AggregatorFactory[]{new CountAggregatorFactory("count")}), new AggregateProjectionSpec("not having a time column is ok too", VirtualColumns.EMPTY, null, new AggregatorFactory[]{new CountAggregatorFactory("count")}), new AggregateProjectionSpec("bad granularity", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.DAY, (String)"g")}), List.of(new LongDimensionSchema("g")), new AggregatorFactory[]{new CountAggregatorFactory("count")}))).build());
        Assertions.assertEquals((Object)"projection[bad granularity] has granularity[{type=period, period=P1D, timeZone=UTC, origin=null}] which must be finer than or equal to segment granularity[{type=period, period=PT1H, timeZone=UTC, origin=null}]", (Object)t.getMessage());
    }
}

