/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.LongFirstAggregatorFactory;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.FingerprintGenerator;
import org.junit.Assert;
import org.junit.Test;

public class FingerprintGeneratorTest {
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();
    private final FingerprintGenerator fingerprintGenerator = new FingerprintGenerator(this.mapper);

    @Test
    public void testGenerateFingerprint_precalculatedHash() {
        RowSignature rowSignature = RowSignature.builder().add("c1", ColumnType.LONG).add("c0", ColumnType.STRING).add("c2", ColumnType.FLOAT).add("c3", ColumnType.DOUBLE).build();
        HashMap<String, Object> aggregatorFactoryMap = new HashMap<String, Object>();
        aggregatorFactoryMap.put("longFirst", new LongFirstAggregatorFactory("longFirst", "c1", null));
        aggregatorFactoryMap.put("stringAny", new StringAnyAggregatorFactory("stringAny", "c0", Integer.valueOf(1024), Boolean.valueOf(true)));
        SchemaPayload schemaPayload = new SchemaPayload(rowSignature, aggregatorFactoryMap);
        String expected = "82E774457D26D0B8D481B6C39872070B25EA3C72C6EFC107B346FA42641740E1";
        Assert.assertEquals((Object)expected, (Object)this.fingerprintGenerator.generateFingerprint(schemaPayload, "ds", 0));
    }

    @Test
    public void testGenerateFingerprint_columnPermutation() {
        RowSignature rowSignature = RowSignature.builder().add("c2", ColumnType.LONG).add("c1", ColumnType.FLOAT).add("c3", ColumnType.DOUBLE).add("c0", ColumnType.STRING).build();
        HashMap<String, Object> aggregatorFactoryMap = new HashMap<String, Object>();
        aggregatorFactoryMap.put("longFirst", new LongFirstAggregatorFactory("longFirst", "c2", null));
        aggregatorFactoryMap.put("stringAny", new StringAnyAggregatorFactory("stringAny", "c0", Integer.valueOf(1024), Boolean.valueOf(true)));
        SchemaPayload schemaPayload = new SchemaPayload(rowSignature, aggregatorFactoryMap);
        RowSignature rowSignaturePermutation = RowSignature.builder().add("c2", ColumnType.LONG).add("c0", ColumnType.STRING).add("c3", ColumnType.DOUBLE).add("c1", ColumnType.FLOAT).build();
        HashMap<String, Object> aggregatorFactoryMapForPermutation = new HashMap<String, Object>();
        aggregatorFactoryMapForPermutation.put("stringAny", new StringAnyAggregatorFactory("stringAny", "c0", Integer.valueOf(1024), Boolean.valueOf(true)));
        aggregatorFactoryMapForPermutation.put("longFirst", new LongFirstAggregatorFactory("longFirst", "c2", null));
        SchemaPayload schemaPayloadNew = new SchemaPayload(rowSignaturePermutation, aggregatorFactoryMapForPermutation);
        Assert.assertEquals((Object)this.fingerprintGenerator.generateFingerprint(schemaPayload, "ds", 0), (Object)this.fingerprintGenerator.generateFingerprint(schemaPayloadNew, "ds", 0));
    }

    @Test
    public void testGenerateFingerprint_differentDatasources() {
        RowSignature rowSignature = RowSignature.builder().add("c1", ColumnType.FLOAT).add("c2", ColumnType.LONG).add("c3", ColumnType.DOUBLE).build();
        HashMap<String, LongFirstAggregatorFactory> aggregatorFactoryMap = new HashMap<String, LongFirstAggregatorFactory>();
        aggregatorFactoryMap.put("longFirst", new LongFirstAggregatorFactory("longFirst", "long-col", null));
        SchemaPayload schemaPayload = new SchemaPayload(rowSignature, aggregatorFactoryMap);
        Assert.assertNotEquals((Object)this.fingerprintGenerator.generateFingerprint(schemaPayload, "ds1", 0), (Object)this.fingerprintGenerator.generateFingerprint(schemaPayload, "ds2", 0));
    }

    @Test
    public void testGenerateFingerprint_differentVersion() {
        RowSignature rowSignature = RowSignature.builder().add("c1", ColumnType.FLOAT).add("c2", ColumnType.LONG).add("c3", ColumnType.DOUBLE).build();
        HashMap<String, LongFirstAggregatorFactory> aggregatorFactoryMap = new HashMap<String, LongFirstAggregatorFactory>();
        aggregatorFactoryMap.put("longFirst", new LongFirstAggregatorFactory("longFirst", "long-col", null));
        SchemaPayload schemaPayload = new SchemaPayload(rowSignature, aggregatorFactoryMap);
        Assert.assertNotEquals((Object)this.fingerprintGenerator.generateFingerprint(schemaPayload, "ds", 0), (Object)this.fingerprintGenerator.generateFingerprint(schemaPayload, "ds", 1));
    }

    @Test
    public void testRowSignatureIsSorted() {
        RowSignature rowSignature = RowSignature.builder().add("c5", ColumnType.STRING).add("c1", ColumnType.FLOAT).add("b2", ColumnType.LONG).add("d3", ColumnType.DOUBLE).add("a1", ColumnType.STRING).build();
        RowSignature sortedSignature = this.fingerprintGenerator.getLexicographicallySortedSignature(rowSignature);
        Assert.assertNotEquals((Object)rowSignature, (Object)sortedSignature);
        List columnNames = sortedSignature.getColumnNames();
        List<String> sortedOrder = Arrays.asList("a1", "b2", "c1", "c5", "d3");
        Assert.assertEquals(sortedOrder, (Object)columnNames);
        for (String column : sortedOrder) {
            Assert.assertEquals((Object)sortedSignature.getColumnType(column), (Object)rowSignature.getColumnType(column));
        }
    }
}

