/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.client.CachingClusteredClientTest;
import org.apache.druid.client.CoordinatorSegmentWatcherConfig;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.client.DirectDruidClientFactory;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.SegmentLoadInfo;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.metadata.metadata.AllColumnIncluderator;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.metadata.SegmentMetadataQuerySegmentWalker;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class SegmentMetadataQuerySegmentWalkerTest {
    private final String DATASOURCE = "testDatasource";
    private DruidServer[] servers;
    private Random random;
    private TestCoordinatorServerView testCoordinatorServerView;
    private Module module;
    @ClassRule
    public static QueryStackTests.Junit4ConglomerateRule conglomerateRule = new QueryStackTests.Junit4ConglomerateRule();

    @Before
    public void setUp() {
        DruidHttpClientConfig httpClientConfig = new DruidHttpClientConfig(){

            public long getMaxQueuedBytes() {
                return 0L;
            }
        };
        this.servers = new DruidServer[]{new DruidServer("test1", "test1", null, 10L, ServerType.HISTORICAL, "bye", 0), new DruidServer("test2", "test2", null, 10L, ServerType.HISTORICAL, "bye", 0), new DruidServer("test3", "test2", null, 10L, ServerType.INDEXER_EXECUTOR, "bye", 0)};
        this.random = new Random(0L);
        this.module = Modules.combine((Module[])new Module[]{binder -> binder.bind(CoordinatorServerView.class).toInstance((Object)this.testCoordinatorServerView), binder -> binder.bind(DruidHttpClientConfig.class).toInstance((Object)httpClientConfig), binder -> binder.bind(QueryRunnerFactoryConglomerate.class).toInstance((Object)conglomerateRule.getConglomerate()), binder -> binder.bind(ServerConfig.class).toInstance((Object)new ServerConfig()), binder -> binder.bind(ServiceEmitter.class).toInstance((Object)new NoopServiceEmitter())});
    }

    @Test
    public void testWalker() throws IOException {
        HashMap<String, VersionedIntervalTimeline<String, SegmentLoadInfo>> timelines = new HashMap<String, VersionedIntervalTimeline<String, SegmentLoadInfo>>();
        HashMap<String, QueryRunner> queryRunnerMap = new HashMap<String, QueryRunner>();
        Map<String, CachingClusteredClientTest.ServerExpectations> serverExpectationsMap = this.populateTimeline(timelines, queryRunnerMap, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Intervals.of((String)"2011-01-01/2011-01-02"), (Object)Lists.newArrayList((Object[])new Integer[]{0, 4, 5})), Pair.of((Object)Intervals.of((String)"2011-01-05/2011-01-07"), (Object)Lists.newArrayList((Object[])new Integer[]{0, 1, 1}))}));
        this.testCoordinatorServerView = new TestCoordinatorServerView(timelines, queryRunnerMap);
        List segmentDescriptors = serverExpectationsMap.values().stream().flatMap(serverExpectations -> Lists.newArrayList(serverExpectations.iterator()).stream()).map(CachingClusteredClientTest.ServerExpectation::getSegment).map(segment -> segment.getId().toDescriptor()).collect(Collectors.toList());
        SegmentMetadataQuery segmentMetadataQuery = new SegmentMetadataQuery((DataSource)new TableDataSource("testDatasource"), (QuerySegmentSpec)new MultipleSpecificSegmentSpec(segmentDescriptors), (ColumnIncluderator)new AllColumnIncluderator(), Boolean.valueOf(false), QueryContexts.override(Collections.emptyMap(), (String)"enableParallelMerge", (Object)false), EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class), Boolean.valueOf(false), null, null);
        SegmentMetadataQuerySegmentWalker walker = (SegmentMetadataQuerySegmentWalker)Guice.createInjector((Module[])new Module[]{this.module}).getInstance(SegmentMetadataQuerySegmentWalker.class);
        Set actualSegmentIds = walker.getQueryRunnerForSegments((Query)segmentMetadataQuery, segmentDescriptors).run(QueryPlus.wrap((Query)segmentMetadataQuery)).toList().stream().map(SegmentAnalysis::getId).collect(Collectors.toSet());
        Set expectedSegmentIds = serverExpectationsMap.values().stream().flatMap(serverExpectations -> Lists.newArrayList(serverExpectations.iterator()).stream()).map(CachingClusteredClientTest.ServerExpectation::getSegment).map(segment -> segment.getId().toString()).collect(Collectors.toSet());
        Assert.assertEquals(expectedSegmentIds, actualSegmentIds);
    }

    @Test
    public void testWalkerWithRestriction() throws IOException {
        HashMap<String, VersionedIntervalTimeline<String, SegmentLoadInfo>> timelines = new HashMap<String, VersionedIntervalTimeline<String, SegmentLoadInfo>>();
        HashMap<String, QueryRunner> queryRunnerMap = new HashMap<String, QueryRunner>();
        Map<String, CachingClusteredClientTest.ServerExpectations> serverExpectationsMap = this.populateTimeline(timelines, queryRunnerMap, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Intervals.of((String)"2011-01-01/2011-01-02"), (Object)Lists.newArrayList((Object[])new Integer[]{0, 4, 5})), Pair.of((Object)Intervals.of((String)"2011-01-05/2011-01-07"), (Object)Lists.newArrayList((Object[])new Integer[]{0, 1, 1}))}));
        this.testCoordinatorServerView = new TestCoordinatorServerView(timelines, queryRunnerMap);
        List segmentDescriptors = serverExpectationsMap.values().stream().flatMap(serverExpectations -> Lists.newArrayList(serverExpectations.iterator()).stream()).map(CachingClusteredClientTest.ServerExpectation::getSegment).map(segment -> segment.getId().toDescriptor()).collect(Collectors.toList());
        SegmentMetadataQuery segmentMetadataQuery = new SegmentMetadataQuery((DataSource)RestrictedDataSource.create((DataSource)new TableDataSource("testDatasource"), (Policy)NoRestrictionPolicy.instance()), (QuerySegmentSpec)new MultipleSpecificSegmentSpec(segmentDescriptors), (ColumnIncluderator)new AllColumnIncluderator(), Boolean.valueOf(false), QueryContexts.override(Collections.emptyMap(), (String)"enableParallelMerge", (Object)false), EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class), Boolean.valueOf(false), null, null);
        SegmentMetadataQuerySegmentWalker walker = (SegmentMetadataQuerySegmentWalker)Guice.createInjector((Module[])new Module[]{this.module}).getInstance(SegmentMetadataQuerySegmentWalker.class);
        Set actualSegmentIds = walker.getQueryRunnerForSegments((Query)segmentMetadataQuery, segmentDescriptors).run(QueryPlus.wrap((Query)segmentMetadataQuery)).toList().stream().map(SegmentAnalysis::getId).collect(Collectors.toSet());
        Set expectedSegmentIds = serverExpectationsMap.values().stream().flatMap(serverExpectations -> Lists.newArrayList(serverExpectations.iterator()).stream()).map(CachingClusteredClientTest.ServerExpectation::getSegment).map(segment -> segment.getId().toString()).collect(Collectors.toSet());
        Assert.assertEquals(expectedSegmentIds, actualSegmentIds);
    }

    @Test
    public void testQueryAppendedSegments() throws IOException {
        HashMap<String, VersionedIntervalTimeline<String, SegmentLoadInfo>> timelines = new HashMap<String, VersionedIntervalTimeline<String, SegmentLoadInfo>>();
        HashMap<String, QueryRunner> queryRunnerMap = new HashMap<String, QueryRunner>();
        this.populateTimeline(timelines, queryRunnerMap, Collections.singletonList(Pair.of((Object)Intervals.of((String)"2011-01-01/2011-01-02"), (Object)Lists.newArrayList((Object[])new Integer[]{0, 4, 5}))));
        queryRunnerMap.clear();
        this.testCoordinatorServerView = new TestCoordinatorServerView(timelines, queryRunnerMap);
        Map<String, CachingClusteredClientTest.ServerExpectations> serverExpectationsMap = this.populateTimeline(timelines, queryRunnerMap, Collections.singletonList(Pair.of((Object)Intervals.of((String)"2011-01-01/2011-01-02"), (Object)Lists.newArrayList((Object[])new Integer[]{5, 6, 5}))));
        List segmentDescriptors = serverExpectationsMap.values().stream().flatMap(serverExpectations -> Lists.newArrayList(serverExpectations.iterator()).stream()).map(CachingClusteredClientTest.ServerExpectation::getSegment).map(segment -> segment.getId().toDescriptor()).collect(Collectors.toList());
        SegmentMetadataQuery segmentMetadataQuery = new SegmentMetadataQuery((DataSource)new TableDataSource("testDatasource"), (QuerySegmentSpec)new MultipleSpecificSegmentSpec(segmentDescriptors), (ColumnIncluderator)new AllColumnIncluderator(), Boolean.valueOf(false), QueryContexts.override(Collections.emptyMap(), (String)"enableParallelMerge", (Object)false), EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class), Boolean.valueOf(false), null, null);
        SegmentMetadataQuerySegmentWalker walker = (SegmentMetadataQuerySegmentWalker)Guice.createInjector((Module[])new Module[]{this.module}).getInstance(SegmentMetadataQuerySegmentWalker.class);
        Set actualSegmentIds = walker.getQueryRunnerForSegments((Query)segmentMetadataQuery, segmentDescriptors).run(QueryPlus.wrap((Query)segmentMetadataQuery)).toList().stream().map(SegmentAnalysis::getId).collect(Collectors.toSet());
        Set expectedSegmentIds = serverExpectationsMap.values().stream().flatMap(serverExpectations -> Lists.newArrayList(serverExpectations.iterator()).stream()).map(CachingClusteredClientTest.ServerExpectation::getSegment).map(segment -> segment.getId().toString()).collect(Collectors.toSet());
        Assert.assertEquals(expectedSegmentIds, actualSegmentIds);
    }

    private Map<String, CachingClusteredClientTest.ServerExpectations> populateTimeline(Map<String, VersionedIntervalTimeline<String, SegmentLoadInfo>> timelines, Map<String, QueryRunner> queryRunnerMap, List<Pair<Interval, List<Integer>>> intervalAndChunks) {
        VersionedIntervalTimeline timeline = new VersionedIntervalTimeline(Comparator.naturalOrder());
        timelines.put("testDatasource", (VersionedIntervalTimeline<String, SegmentLoadInfo>)timeline);
        HashMap<String, CachingClusteredClientTest.ServerExpectations> serverExpectationsMap = new HashMap<String, CachingClusteredClientTest.ServerExpectations>();
        for (Pair<Interval, List<Integer>> intervalAndChunk : intervalAndChunks) {
            List partitionDetails = (List)intervalAndChunk.rhs;
            int startNum = (Integer)partitionDetails.get(0);
            int endNum = (Integer)partitionDetails.get(1);
            int corePartitions = (Integer)partitionDetails.get(2);
            for (int partitionNum = startNum; partitionNum <= endNum; ++partitionNum) {
                SingleDimensionShardSpec shardSpec;
                Interval interval = (Interval)intervalAndChunk.lhs;
                int numChunks = endNum - startNum + 1;
                SegmentId segmentId = SegmentId.of((String)"testDatasource", (Interval)interval, (String)"0", (int)partitionNum);
                DataSegment mockSegment = (DataSegment)EasyMock.mock(DataSegment.class);
                if (corePartitions == 1) {
                    shardSpec = new SingleDimensionShardSpec("dimAll", null, null, 0, Integer.valueOf(1));
                } else {
                    String start = null;
                    String end = null;
                    if (partitionNum > 0) {
                        start = String.valueOf(partitionNum);
                    }
                    if (partitionNum + 1 < numChunks) {
                        end = String.valueOf(partitionNum + 1);
                    }
                    shardSpec = new SingleDimensionShardSpec("dim", start, end, partitionNum, Integer.valueOf(corePartitions));
                }
                CachingClusteredClientTest.ServerExpectation expectation = new CachingClusteredClientTest.ServerExpectation(segmentId, interval, mockSegment, (ShardSpec)shardSpec, null);
                DruidServer server = this.servers[this.random.nextInt(this.servers.length)];
                EasyMock.expect((Object)mockSegment.getShardSpec()).andReturn((Object)shardSpec).anyTimes();
                EasyMock.replay((Object[])new Object[]{mockSegment});
                serverExpectationsMap.computeIfAbsent(server.getName(), s -> new CachingClusteredClientTest.ServerExpectations(server, (QueryRunner)EasyMock.mock(QueryRunner.class)));
                SegmentLoadInfo segmentLoadInfo = new SegmentLoadInfo(expectation.getSegment());
                segmentLoadInfo.addServer(server.getMetadata());
                ((CachingClusteredClientTest.ServerExpectations)serverExpectationsMap.get(server.getName())).addExpectation(expectation);
                queryRunnerMap.computeIfAbsent(server.getName(), v -> ((CachingClusteredClientTest.ServerExpectations)serverExpectationsMap.get(server.getName())).getQueryRunner());
                timeline.add(interval, (Object)"0", shardSpec.createChunk((Object)segmentLoadInfo));
                timelines.put("testDatasource", (VersionedIntervalTimeline<String, SegmentLoadInfo>)timeline);
            }
        }
        for (CachingClusteredClientTest.ServerExpectations serverExpectations : serverExpectationsMap.values()) {
            QueryRunner queryRunner = serverExpectations.getQueryRunner();
            ArrayList serverExpectationList = Lists.newArrayList(serverExpectations.iterator());
            EasyMock.expect((Object)queryRunner.run((QueryPlus)EasyMock.anyObject(QueryPlus.class), (ResponseContext)EasyMock.anyObject(ResponseContext.class))).andReturn((Object)Sequences.simple(this.toSegmentAnalysis(serverExpectationList))).anyTimes();
            EasyMock.replay((Object[])new Object[]{queryRunner});
        }
        return serverExpectationsMap;
    }

    private List<SegmentAnalysis> toSegmentAnalysis(List<CachingClusteredClientTest.ServerExpectation> serverExpectationList) {
        ArrayList<SegmentAnalysis> segmentAnalyses = new ArrayList<SegmentAnalysis>();
        for (CachingClusteredClientTest.ServerExpectation serverExpectation : serverExpectationList) {
            final SegmentAnalysis mockSegmentAnalysis = (SegmentAnalysis)EasyMock.mock(SegmentAnalysis.class);
            EasyMock.expect((Object)mockSegmentAnalysis.getId()).andReturn((Object)serverExpectation.getSegmentId().toString()).anyTimes();
            EasyMock.expect((Object)mockSegmentAnalysis.compareTo((SegmentAnalysis)EasyMock.isA(SegmentAnalysis.class))).andAnswer((IAnswer)new IAnswer<Integer>(){

                public Integer answer() {
                    SegmentAnalysis otherSegment = (SegmentAnalysis)EasyMock.getCurrentArguments()[0];
                    String thisId = mockSegmentAnalysis.getId();
                    String otherId = otherSegment.getId();
                    return thisId.compareTo(otherId);
                }
            }).anyTimes();
            EasyMock.replay((Object[])new Object[]{mockSegmentAnalysis});
            segmentAnalyses.add(mockSegmentAnalysis);
        }
        return segmentAnalyses;
    }

    private static class TestCoordinatorServerView
    extends CoordinatorServerView {
        private final Map<String, VersionedIntervalTimeline<String, SegmentLoadInfo>> timelines;
        private final Map<String, QueryRunner> queryRunnerMap;

        public TestCoordinatorServerView(Map<String, VersionedIntervalTimeline<String, SegmentLoadInfo>> timelines, Map<String, QueryRunner> queryRunnerMap) {
            super((ServerInventoryView)Mockito.mock(ServerInventoryView.class), (CoordinatorSegmentWatcherConfig)Mockito.mock(CoordinatorSegmentWatcherConfig.class), (ServiceEmitter)Mockito.mock(ServiceEmitter.class), (DirectDruidClientFactory)Mockito.mock(DirectDruidClientFactory.class));
            this.timelines = timelines;
            this.queryRunnerMap = queryRunnerMap;
        }

        public QueryRunner getQueryRunner(String serverName) {
            return this.queryRunnerMap.get(serverName);
        }

        public VersionedIntervalTimeline<String, SegmentLoadInfo> getTimeline(DataSource dataSource) {
            return this.timelines.get(Iterables.getOnlyElement((Iterable)dataSource.getTableNames()));
        }
    }
}

