/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import com.google.common.base.Optional;
import org.apache.druid.segment.realtime.ChatHandlerProvider;
import org.apache.druid.segment.realtime.ChatHandlerResource;
import org.apache.druid.server.initialization.jetty.ServiceUnavailableException;
import org.apache.druid.server.metrics.DataSourceTaskIdHolder;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class ChatHandlerResourceTest
extends EasyMockSupport {
    @Mock
    ChatHandlerProvider handlers;
    @Mock
    DataSourceTaskIdHolder dataSourceTaskIdHolder;
    ChatHandlerResource chatHandlerResource;

    @Test
    public void test_noHandlerFound() {
        String handlerId = "handlerId";
        EasyMock.expect((Object)this.dataSourceTaskIdHolder.getTaskId()).andReturn(null);
        EasyMock.expect((Object)this.handlers.get(handlerId)).andReturn((Object)Optional.absent());
        this.replayAll();
        this.chatHandlerResource = new ChatHandlerResource(this.handlers, this.dataSourceTaskIdHolder);
        Assert.assertThrows(ServiceUnavailableException.class, () -> this.chatHandlerResource.doTaskChat(handlerId, null));
        this.verifyAll();
    }
}

