/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.realtime.appenderator.SegmentSchemas;
import org.apache.druid.segment.realtime.appenderator.SinkSchemaUtil;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class SinkSchemaUtilTest {
    @Test
    public void testComputeAbsoluteSchemaEmpty() {
        Assert.assertEquals(Optional.empty(), (Object)SinkSchemaUtil.computeAbsoluteSchema(new HashMap()));
    }

    @Test
    public void testComputeAbsoluteSchema() {
        HashMap<SegmentId, Pair> sinkSchemaMap = new HashMap<SegmentId, Pair>();
        SegmentId segment1 = SegmentId.of((String)"foo", (Interval)Intervals.of((String)"2000-01-01T01:00:00.000Z/2000-01-01T02:00:00.000Z"), (String)"v1", (int)0);
        LinkedHashMap columnTypeMap1 = Maps.newLinkedHashMap();
        columnTypeMap1.put("dim1", ColumnType.FLOAT);
        columnTypeMap1.put("dim2", ColumnType.UNKNOWN_COMPLEX);
        columnTypeMap1.put("dim3", ColumnType.NESTED_DATA);
        Pair schema1 = Pair.of((Object)this.toRowSignature(columnTypeMap1), (Object)20);
        sinkSchemaMap.put(segment1, schema1);
        SegmentId segment2 = SegmentId.of((String)"foo", (Interval)Intervals.of((String)"2000-01-01T01:00:00.000Z/2000-01-01T02:00:00.000Z"), (String)"v1", (int)1);
        LinkedHashMap columnTypeMap2 = Maps.newLinkedHashMap();
        columnTypeMap2.put("dim1", ColumnType.FLOAT);
        columnTypeMap2.put("dim2", ColumnType.LONG);
        columnTypeMap2.put("dim3", ColumnType.STRING);
        columnTypeMap2.put("dim4", ColumnType.NESTED_DATA);
        Pair schema2 = Pair.of((Object)this.toRowSignature(columnTypeMap2), (Object)40);
        sinkSchemaMap.put(segment2, schema2);
        Optional segmentSchemas = SinkSchemaUtil.computeAbsoluteSchema(sinkSchemaMap);
        Assert.assertTrue((boolean)segmentSchemas.isPresent());
        Assert.assertEquals((long)2L, (long)((SegmentSchemas)segmentSchemas.get()).getSegmentSchemaList().size());
        Map<String, SegmentSchemas.SegmentSchema> segmentSchemaMap = ((SegmentSchemas)segmentSchemas.get()).getSegmentSchemaList().stream().collect(Collectors.toMap(SegmentSchemas.SegmentSchema::getSegmentId, v -> v));
        SegmentSchemas.SegmentSchema segmentSchema1 = segmentSchemaMap.get(segment1.toString());
        Assert.assertEquals((long)20L, (long)segmentSchema1.getNumRows().intValue());
        Assert.assertEquals((Object)segment1.toString(), (Object)segmentSchema1.getSegmentId());
        Assert.assertEquals((Object)"foo", (Object)segmentSchema1.getDataSource());
        Assert.assertFalse((boolean)segmentSchema1.isDelta());
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3"), (Object)segmentSchema1.getNewColumns());
        Assert.assertEquals((Object)columnTypeMap1, (Object)segmentSchema1.getColumnTypeMap());
        Assert.assertEquals(Collections.emptyList(), (Object)segmentSchema1.getUpdatedColumns());
        SegmentSchemas.SegmentSchema segmentSchema2 = segmentSchemaMap.get(segment2.toString());
        Assert.assertEquals((long)40L, (long)segmentSchema2.getNumRows().intValue());
        Assert.assertEquals((Object)segment2.toString(), (Object)segmentSchema2.getSegmentId());
        Assert.assertEquals((Object)"foo", (Object)segmentSchema2.getDataSource());
        Assert.assertFalse((boolean)segmentSchema2.isDelta());
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3", (Object)"dim4"), (Object)segmentSchema2.getNewColumns());
        Assert.assertEquals((Object)columnTypeMap2, (Object)segmentSchema2.getColumnTypeMap());
        Assert.assertEquals(Collections.emptyList(), (Object)segmentSchema2.getUpdatedColumns());
    }

    @Test
    public void testComputeSchemaChangeNoChange() {
        HashMap<SegmentId, Pair> previousSinkSchemaMap = new HashMap<SegmentId, Pair>();
        SegmentId segment1 = SegmentId.of((String)"foo", (Interval)Intervals.of((String)"2000-01-01T01:00:00.000Z/2000-01-01T02:00:00.000Z"), (String)"v1", (int)0);
        LinkedHashMap columnTypeMap1 = Maps.newLinkedHashMap();
        columnTypeMap1.put("dim1", ColumnType.FLOAT);
        columnTypeMap1.put("dim2", ColumnType.UNKNOWN_COMPLEX);
        columnTypeMap1.put("dim3", ColumnType.NESTED_DATA);
        Pair schema1 = Pair.of((Object)this.toRowSignature(columnTypeMap1), (Object)20);
        previousSinkSchemaMap.put(segment1, schema1);
        SegmentId segment2 = SegmentId.of((String)"foo", (Interval)Intervals.of((String)"2000-01-01T01:00:00.000Z/2000-01-01T02:00:00.000Z"), (String)"v1", (int)1);
        LinkedHashMap columnTypeMap2 = Maps.newLinkedHashMap();
        columnTypeMap2.put("dim1", ColumnType.FLOAT);
        columnTypeMap2.put("dim2", ColumnType.LONG);
        columnTypeMap2.put("dim3", ColumnType.STRING);
        columnTypeMap2.put("dim4", ColumnType.NESTED_DATA);
        Pair schema2 = Pair.of((Object)this.toRowSignature(columnTypeMap2), (Object)40);
        previousSinkSchemaMap.put(segment2, schema2);
        SegmentId segment3 = SegmentId.of((String)"foo", (Interval)Intervals.of((String)"2000-01-01T01:00:00.000Z/2000-01-01T02:00:00.000Z"), (String)"v1", (int)2);
        LinkedHashMap columnTypeMap3 = Maps.newLinkedHashMap();
        columnTypeMap2.put("dim1", ColumnType.FLOAT);
        columnTypeMap2.put("dim2", ColumnType.LONG);
        columnTypeMap2.put("dim3", ColumnType.STRING);
        columnTypeMap2.put("dim5", ColumnType.NESTED_DATA);
        Pair schema3 = Pair.of((Object)this.toRowSignature(columnTypeMap3), (Object)80);
        previousSinkSchemaMap.put(segment3, schema3);
        Assert.assertFalse((boolean)SinkSchemaUtil.computeSchemaChange(previousSinkSchemaMap, previousSinkSchemaMap).isPresent());
    }

    @Test
    public void testComputeSchemaChange() {
        HashMap<SegmentId, Pair> previousSinkSchemaMap = new HashMap<SegmentId, Pair>();
        SegmentId segment1 = SegmentId.of((String)"foo", (Interval)Intervals.of((String)"2000-01-01T01:00:00.000Z/2000-01-01T02:00:00.000Z"), (String)"v1", (int)0);
        LinkedHashMap columnTypeMap1 = Maps.newLinkedHashMap();
        columnTypeMap1.put("dim1", ColumnType.FLOAT);
        columnTypeMap1.put("dim2", ColumnType.UNKNOWN_COMPLEX);
        columnTypeMap1.put("dim3", ColumnType.NESTED_DATA);
        Pair schema1 = Pair.of((Object)this.toRowSignature(columnTypeMap1), (Object)20);
        previousSinkSchemaMap.put(segment1, schema1);
        SegmentId segment2 = SegmentId.of((String)"foo", (Interval)Intervals.of((String)"2000-01-01T01:00:00.000Z/2000-01-01T02:00:00.000Z"), (String)"v1", (int)1);
        LinkedHashMap columnTypeMap2 = Maps.newLinkedHashMap();
        columnTypeMap2.put("dim1", ColumnType.FLOAT);
        columnTypeMap2.put("dim2", ColumnType.LONG);
        columnTypeMap2.put("dim3", ColumnType.STRING);
        columnTypeMap2.put("dim4", ColumnType.NESTED_DATA);
        Pair schema2 = Pair.of((Object)this.toRowSignature(columnTypeMap2), (Object)40);
        previousSinkSchemaMap.put(segment2, schema2);
        SegmentId segment3 = SegmentId.of((String)"foo", (Interval)Intervals.of((String)"2000-01-01T01:00:00.000Z/2000-01-01T02:00:00.000Z"), (String)"v1", (int)2);
        LinkedHashMap columnTypeMap3 = Maps.newLinkedHashMap();
        columnTypeMap2.put("dim1", ColumnType.FLOAT);
        columnTypeMap2.put("dim2", ColumnType.LONG);
        columnTypeMap2.put("dim3", ColumnType.STRING);
        columnTypeMap2.put("dim5", ColumnType.NESTED_DATA);
        Pair schema3 = Pair.of((Object)this.toRowSignature(columnTypeMap3), (Object)80);
        previousSinkSchemaMap.put(segment3, schema3);
        HashMap<SegmentId, Pair> currentSinkSchemaMap = new HashMap<SegmentId, Pair>();
        LinkedHashMap currColumnTypeMap1 = Maps.newLinkedHashMap();
        currColumnTypeMap1.put("dim1", ColumnType.DOUBLE);
        currColumnTypeMap1.put("dim2", ColumnType.NESTED_DATA);
        currColumnTypeMap1.put("dim4", ColumnType.NESTED_DATA);
        currColumnTypeMap1.put("dim5", ColumnType.STRING);
        Pair currSchema1 = Pair.of((Object)this.toRowSignature(currColumnTypeMap1), (Object)50);
        currentSinkSchemaMap.put(segment1, currSchema1);
        currentSinkSchemaMap.put(segment2, schema2);
        Pair currSchema3 = Pair.of((Object)this.toRowSignature(columnTypeMap3), (Object)100);
        currentSinkSchemaMap.put(segment3, currSchema3);
        SegmentId segment4 = SegmentId.of((String)"foo", (Interval)Intervals.of((String)"2000-01-01T01:00:00.000Z/2000-01-01T02:00:00.000Z"), (String)"v1", (int)5);
        LinkedHashMap columnTypeMap4 = Maps.newLinkedHashMap();
        columnTypeMap4.put("dim1", ColumnType.FLOAT);
        columnTypeMap4.put("dim2", ColumnType.LONG);
        columnTypeMap4.put("dim3", ColumnType.STRING);
        columnTypeMap4.put("dim4", ColumnType.NESTED_DATA);
        Pair schema4 = Pair.of((Object)this.toRowSignature(columnTypeMap4), (Object)40);
        currentSinkSchemaMap.put(segment4, schema4);
        Optional segmentSchemasChange = SinkSchemaUtil.computeSchemaChange(previousSinkSchemaMap, currentSinkSchemaMap);
        Assert.assertTrue((boolean)segmentSchemasChange.isPresent());
        Assert.assertEquals((long)3L, (long)((SegmentSchemas)segmentSchemasChange.get()).getSegmentSchemaList().size());
        Map<String, SegmentSchemas.SegmentSchema> segmentSchemaMap = ((SegmentSchemas)segmentSchemasChange.get()).getSegmentSchemaList().stream().collect(Collectors.toMap(SegmentSchemas.SegmentSchema::getSegmentId, v -> v));
        SegmentSchemas.SegmentSchema segmentSchema1 = segmentSchemaMap.get(segment1.toString());
        Assert.assertEquals((Object)segment1.toString(), (Object)segmentSchema1.getSegmentId());
        Assert.assertEquals((Object)"foo", (Object)segmentSchema1.getDataSource());
        Assert.assertTrue((boolean)segmentSchema1.isDelta());
        Assert.assertEquals((long)50L, (long)segmentSchema1.getNumRows().intValue());
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim4", (Object)"dim5"), (Object)segmentSchema1.getNewColumns());
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim1", (Object)"dim2"), (Object)segmentSchema1.getUpdatedColumns());
        Assert.assertEquals((Object)currColumnTypeMap1, (Object)segmentSchema1.getColumnTypeMap());
        SegmentSchemas.SegmentSchema segmentSchema2 = segmentSchemaMap.get(segment3.toString());
        Assert.assertEquals((Object)segment3.toString(), (Object)segmentSchema2.getSegmentId());
        Assert.assertEquals((Object)"foo", (Object)segmentSchema2.getDataSource());
        Assert.assertTrue((boolean)segmentSchema2.isDelta());
        Assert.assertEquals((long)100L, (long)segmentSchema2.getNumRows().intValue());
        Assert.assertEquals(Collections.emptyList(), (Object)segmentSchema2.getNewColumns());
        Assert.assertEquals(Collections.emptyList(), (Object)segmentSchema2.getUpdatedColumns());
        Assert.assertEquals(new HashMap(), (Object)segmentSchema2.getColumnTypeMap());
        SegmentSchemas.SegmentSchema segmentSchema3 = segmentSchemaMap.get(segment4.toString());
        Assert.assertEquals((Object)segment4.toString(), (Object)segmentSchema3.getSegmentId());
        Assert.assertEquals((Object)"foo", (Object)segmentSchema3.getDataSource());
        Assert.assertFalse((boolean)segmentSchema3.isDelta());
        Assert.assertEquals((long)40L, (long)segmentSchema3.getNumRows().intValue());
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3", (Object)"dim4"), (Object)segmentSchema3.getNewColumns());
        Assert.assertEquals(Collections.emptyList(), (Object)segmentSchema3.getUpdatedColumns());
        Assert.assertEquals((Object)columnTypeMap4, (Object)segmentSchema3.getColumnTypeMap());
    }

    private RowSignature toRowSignature(Map<String, ColumnType> columnTypeMap) {
        RowSignature.Builder builder = RowSignature.builder();
        for (Map.Entry<String, ColumnType> entry : columnTypeMap.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }
}

