/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.FilteredServerInventoryView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.druid.client.selector.HistoricalFilter;
import org.apache.druid.client.selector.RandomServerSelectorStrategy;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.server.ClientInfoResource;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleElementPartitionChunk;
import org.easymock.EasyMock;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClientInfoResourceTest {
    private static final String KEY_DIMENSIONS = "dimensions";
    private static final String KEY_METRICS = "metrics";
    private static final DateTime FIXED_TEST_TIME = new DateTime(2015, 9, 14, 0, 0, (Chronology)ISOChronology.getInstanceUTC());
    private final String dataSource = "test-data-source";
    private FilteredServerInventoryView serverInventoryView;
    private TimelineServerView timelineServerView;
    private ClientInfoResource resource;

    @Before
    public void setup() {
        VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
        DruidServer server = new DruidServer("name", "host", null, 1234L, ServerType.HISTORICAL, "tier", 0);
        this.addSegment((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "1960-02-13/1961-02-14", (List<String>)ImmutableList.of((Object)"d5"), (List<String>)ImmutableList.of((Object)"m5"), "v0");
        this.addSegment((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2014-02-13/2014-02-14", (List<String>)ImmutableList.of((Object)"d1"), (List<String>)ImmutableList.of((Object)"m1"), "v0");
        this.addSegment((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2014-02-14/2014-02-15", (List<String>)ImmutableList.of((Object)"d1"), (List<String>)ImmutableList.of((Object)"m1"), "v0");
        this.addSegment((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2014-02-16/2014-02-17", (List<String>)ImmutableList.of((Object)"d1"), (List<String>)ImmutableList.of((Object)"m1"), "v0");
        this.addSegment((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2014-02-17/2014-02-18", (List<String>)ImmutableList.of((Object)"d2"), (List<String>)ImmutableList.of((Object)"m2"), "v0");
        this.addSegment((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2015-02-01/2015-02-07", (List<String>)ImmutableList.of((Object)"d1"), (List<String>)ImmutableList.of((Object)"m1"), "v1");
        this.addSegment((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2015-02-07/2015-02-13", (List<String>)ImmutableList.of((Object)"d1"), (List<String>)ImmutableList.of((Object)"m1"), "v1");
        this.addSegmentWithShardSpec((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2015-02-03/2015-02-05", (List<String>)ImmutableList.of((Object)"d1", (Object)"d2"), (List<String>)ImmutableList.of((Object)"m1", (Object)"m2"), "v2", (ShardSpec)new NumberedShardSpec(0, 2));
        this.addSegmentWithShardSpec((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2015-02-03/2015-02-05", (List<String>)ImmutableList.of((Object)"d1", (Object)"d2", (Object)"d3"), (List<String>)ImmutableList.of((Object)"m1", (Object)"m2", (Object)"m3"), "v2", (ShardSpec)new NumberedShardSpec(1, 2));
        this.addSegment((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2015-02-09/2015-02-10", (List<String>)ImmutableList.of((Object)"d1", (Object)"d3"), (List<String>)ImmutableList.of((Object)"m1", (Object)"m3"), "v2");
        this.addSegment((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2015-02-11/2015-02-12", (List<String>)ImmutableList.of((Object)"d3"), (List<String>)ImmutableList.of((Object)"m3"), "v2");
        this.addSegment((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2015-03-13/2015-03-19", (List<String>)ImmutableList.of((Object)"d1"), (List<String>)ImmutableList.of((Object)"m1"), "v3");
        this.addSegment((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2015-03-13/2015-03-14", (List<String>)ImmutableList.of((Object)"d1"), (List<String>)ImmutableList.of((Object)"m1"), "v4");
        this.addSegment((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2015-03-14/2015-03-15", (List<String>)ImmutableList.of((Object)"d1"), (List<String>)ImmutableList.of((Object)"m1"), "v5");
        this.addSegment((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2015-03-15/2015-03-16", (List<String>)ImmutableList.of((Object)"d1"), (List<String>)ImmutableList.of((Object)"m1"), "v6");
        this.addSegmentWithShardSpec((VersionedIntervalTimeline<String, ServerSelector>)timeline, server, "2015-04-03/2015-04-05", (List<String>)ImmutableList.of((Object)"d4"), (List<String>)ImmutableList.of((Object)"m4"), "v7", (ShardSpec)new NumberedShardSpec(0, 2));
        this.serverInventoryView = (FilteredServerInventoryView)EasyMock.createMock(FilteredServerInventoryView.class);
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)server)).anyTimes();
        this.timelineServerView = (TimelineServerView)EasyMock.createMock(TimelineServerView.class);
        EasyMock.expect((Object)this.timelineServerView.getTimeline((TableDataSource)EasyMock.anyObject(TableDataSource.class))).andReturn(Optional.of(timeline));
        EasyMock.replay((Object[])new Object[]{this.serverInventoryView, this.timelineServerView});
        this.resource = this.getResourceTestHelper(this.serverInventoryView, this.timelineServerView, new SegmentMetadataQueryConfig());
    }

    @Test
    public void testGetDatasourceNonFullWithInterval() {
        Map actual = this.resource.getDatasource("test-data-source", "1975/2015", null);
        ImmutableMap expected = ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1", (Object)"d2"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1", (Object)"m2"));
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetDatasourceFullWithInterval() {
        Map actual = this.resource.getDatasource("test-data-source", "1975/2015", "true");
        ImmutableMap expected = ImmutableMap.of((Object)"2014-02-13T00:00:00.000Z/2014-02-15T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1")), (Object)"2014-02-16T00:00:00.000Z/2014-02-17T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1")), (Object)"2014-02-17T00:00:00.000Z/2014-02-18T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d2"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m2")));
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView, this.timelineServerView});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetDatasourceFullWithSmallInterval() {
        Map actual = this.resource.getDatasource("test-data-source", "2014-02-13T09:00:00.000Z/2014-02-17T23:00:00.000Z", "true");
        ImmutableMap expected = ImmutableMap.of((Object)"2014-02-13T09:00:00.000Z/2014-02-15T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1")), (Object)"2014-02-16T00:00:00.000Z/2014-02-17T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1")), (Object)"2014-02-17T00:00:00.000Z/2014-02-17T23:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d2"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m2")));
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView, this.timelineServerView});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetDatasourceWithDefaultInterval() {
        Map actual = this.resource.getDatasource("test-data-source", null, null);
        ImmutableMap expected = ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of(), (Object)KEY_METRICS, (Object)ImmutableSet.of());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetDatasourceWithConfiguredDefaultInterval() {
        ClientInfoResource defaultResource = this.getResourceTestHelper(this.serverInventoryView, this.timelineServerView, new SegmentMetadataQueryConfig("P100Y"));
        ImmutableMap expected = ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1", (Object)"d2", (Object)"d3", (Object)"d4", (Object)"d5"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1", (Object)"m2", (Object)"m3", (Object)"m4", (Object)"m5"));
        Map actual = defaultResource.getDatasource("test-data-source", null, null);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetDatasourceFullWithOvershadowedSegments1() {
        Map actual = this.resource.getDatasource("test-data-source", "2015-02-02T09:00:00.000Z/2015-02-06T23:00:00.000Z", "true");
        ImmutableMap expected = ImmutableMap.of((Object)"2015-02-02T09:00:00.000Z/2015-02-03T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1")), (Object)"2015-02-03T00:00:00.000Z/2015-02-05T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1", (Object)"d2", (Object)"d3"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1", (Object)"m2", (Object)"m3")), (Object)"2015-02-05T00:00:00.000Z/2015-02-06T23:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1")));
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView, this.timelineServerView});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetDatasourceFullWithOvershadowedSegments2() {
        Map actual = this.resource.getDatasource("test-data-source", "2015-02-09T09:00:00.000Z/2015-02-13T23:00:00.000Z", "true");
        ImmutableMap expected = ImmutableMap.of((Object)"2015-02-09T09:00:00.000Z/2015-02-10T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1", (Object)"d3"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1", (Object)"m3")), (Object)"2015-02-10T00:00:00.000Z/2015-02-11T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1")), (Object)"2015-02-11T00:00:00.000Z/2015-02-12T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d3"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m3")), (Object)"2015-02-12T00:00:00.000Z/2015-02-13T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1")));
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView, this.timelineServerView});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetDatasourceFullWithOvershadowedSegmentsMerged() {
        Map actual = this.resource.getDatasource("test-data-source", "2015-03-13T02:00:00.000Z/2015-03-19T15:00:00.000Z", "true");
        ImmutableMap expected = ImmutableMap.of((Object)"2015-03-13T02:00:00.000Z/2015-03-19T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1")));
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView, this.timelineServerView});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetDatasourceFullWithIncompleteSegment() {
        Map actual = this.resource.getDatasource("test-data-source", "2015-04-03/2015-04-05", "true");
        ImmutableMap expected = ImmutableMap.of();
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView, this.timelineServerView});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetDatasourceFullWithLargeInterval() {
        Map actual = this.resource.getDatasource("test-data-source", "1975/2050", "true");
        ImmutableMap expected = ImmutableMap.builder().put((Object)"2014-02-13T00:00:00.000Z/2014-02-15T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1"))).put((Object)"2014-02-16T00:00:00.000Z/2014-02-17T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1"))).put((Object)"2014-02-17T00:00:00.000Z/2014-02-18T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d2"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m2"))).put((Object)"2015-02-01T00:00:00.000Z/2015-02-03T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1"))).put((Object)"2015-02-03T00:00:00.000Z/2015-02-05T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1", (Object)"d2", (Object)"d3"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1", (Object)"m2", (Object)"m3"))).put((Object)"2015-02-05T00:00:00.000Z/2015-02-09T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1"))).put((Object)"2015-02-09T00:00:00.000Z/2015-02-10T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1", (Object)"d3"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1", (Object)"m3"))).put((Object)"2015-02-10T00:00:00.000Z/2015-02-11T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1"))).put((Object)"2015-02-11T00:00:00.000Z/2015-02-12T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d3"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m3"))).put((Object)"2015-02-12T00:00:00.000Z/2015-02-13T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1"))).put((Object)"2015-03-13T00:00:00.000Z/2015-03-19T00:00:00.000Z", (Object)ImmutableMap.of((Object)KEY_DIMENSIONS, (Object)ImmutableSet.of((Object)"d1"), (Object)KEY_METRICS, (Object)ImmutableSet.of((Object)"m1"))).build();
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView, this.timelineServerView});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private void addSegment(VersionedIntervalTimeline<String, ServerSelector> timeline, DruidServer server, String interval, List<String> dims, List<String> metrics, String version) {
        DataSegment segment = DataSegment.builder().dataSource("test-data-source").interval(Intervals.of((String)interval)).version(version).dimensions(dims).metrics(metrics).size(1L).build();
        server.addDataSegment(segment);
        ServerSelector ss = new ServerSelector(segment, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()), HistoricalFilter.IDENTITY_FILTER);
        timeline.add(Intervals.of((String)interval), (Object)version, (PartitionChunk)new SingleElementPartitionChunk((Object)ss));
    }

    private void addSegmentWithShardSpec(VersionedIntervalTimeline<String, ServerSelector> timeline, DruidServer server, String interval, List<String> dims, List<String> metrics, String version, ShardSpec shardSpec) {
        DataSegment segment = DataSegment.builder().dataSource("test-data-source").interval(Intervals.of((String)interval)).version(version).dimensions(dims).metrics(metrics).shardSpec(shardSpec).size(1L).build();
        server.addDataSegment(segment);
        ServerSelector ss = new ServerSelector(segment, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()), HistoricalFilter.IDENTITY_FILTER);
        timeline.add(Intervals.of((String)interval), (Object)version, shardSpec.createChunk((Object)ss));
    }

    private ClientInfoResource getResourceTestHelper(FilteredServerInventoryView serverInventoryView, TimelineServerView timelineServerView, SegmentMetadataQueryConfig segmentMetadataQueryConfig) {
        return new ClientInfoResource(serverInventoryView, timelineServerView, segmentMetadataQueryConfig, new AuthConfig(), null){

            protected DateTime getCurrentTime() {
                return FIXED_TEST_TIME;
            }
        };
    }
}

