/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.testing.fieldbinder.Bind;
import com.google.inject.testing.fieldbinder.BoundFieldModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.ForegroundCachePopulator;
import org.apache.druid.client.cache.LocalCacheProvider;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.guava.YieldingSequenceBase;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.ConcatQueryRunner;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DefaultQueryMetrics;
import org.apache.druid.query.DefaultQueryRunnerFactoryConglomerate;
import org.apache.druid.query.Druids;
import org.apache.druid.query.ForwardingQueryProcessingPool;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.Result;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.context.DefaultResponseContext;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.planning.ExecutionVertex;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.query.policy.RestrictAllTablesPolicyEnforcer;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchResultValue;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.segment.ReferenceCountedSegmentProvider;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestSegmentUtils;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.ServerManager;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.test.utils.TestSegmentCacheManager;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class ServerManagerTest {
    private static ImmutableSet<DataSegment> DATA_SEGMENTS = new ImmutableSet.Builder().add((Object)TestSegmentUtils.makeSegment((String)"test", (String)"1", (Interval)Intervals.of((String)"P1d/2011-04-01"))).add((Object)TestSegmentUtils.makeSegment((String)"test", (String)"1", (Interval)Intervals.of((String)"P1d/2011-04-02"))).add((Object)TestSegmentUtils.makeSegment((String)"test", (String)"2", (Interval)Intervals.of((String)"P1d/2011-04-02"))).add((Object)TestSegmentUtils.makeSegment((String)"test", (String)"1", (Interval)Intervals.of((String)"P1d/2011-04-03"))).add((Object)TestSegmentUtils.makeSegment((String)"test", (String)"1", (Interval)Intervals.of((String)"P1d/2011-04-04"))).add((Object)TestSegmentUtils.makeSegment((String)"test", (String)"1", (Interval)Intervals.of((String)"P1d/2011-04-05"))).add((Object)TestSegmentUtils.makeSegment((String)"test", (String)"2", (Interval)Intervals.of((String)"PT1h/2011-04-04T01"))).add((Object)TestSegmentUtils.makeSegment((String)"test", (String)"2", (Interval)Intervals.of((String)"PT1h/2011-04-04T02"))).add((Object)TestSegmentUtils.makeSegment((String)"test", (String)"2", (Interval)Intervals.of((String)"PT1h/2011-04-04T03"))).add((Object)TestSegmentUtils.makeSegment((String)"test", (String)"2", (Interval)Intervals.of((String)"PT1h/2011-04-04T05"))).add((Object)TestSegmentUtils.makeSegment((String)"test", (String)"2", (Interval)Intervals.of((String)"PT1h/2011-04-04T06"))).add((Object)TestSegmentUtils.makeSegment((String)"test2", (String)"1", (Interval)Intervals.of((String)"P1d/2011-04-01"))).add((Object)TestSegmentUtils.makeSegment((String)"test2", (String)"1", (Interval)Intervals.of((String)"P1d/2011-04-02"))).build();
    @Bind
    private QueryRunnerFactoryConglomerate conglomerate;
    @Bind
    private SegmentManager segmentManager;
    @Bind
    private PolicyEnforcer policyEnforcer;
    @Bind
    private ServerConfig serverConfig;
    @Bind
    private ServiceEmitter serviceEmitter;
    @Bind
    private QueryProcessingPool queryProcessingPool;
    @Bind
    private CachePopulator cachePopulator;
    @Bind
    @Smile
    private ObjectMapper objectMapper;
    @Bind
    private Cache cache;
    @Bind
    private CacheConfig cacheConfig;
    private MyQueryRunnerFactory factory;
    private ExecutorService serverManagerExec;
    @Inject
    private ServerManager serverManager;

    @Before
    public void setUp() {
        this.serviceEmitter = new NoopServiceEmitter();
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.segmentManager = new SegmentManager((SegmentCacheManager)new TestSegmentCacheManager((Set<DataSegment>)DATA_SEGMENTS));
        for (DataSegment segment : DATA_SEGMENTS) {
            this.loadQueryable(segment.getDataSource(), segment.getVersion(), segment.getInterval());
        }
        this.factory = new MyQueryRunnerFactory(new CountDownLatch(1), new CountDownLatch(1), new CountDownLatch(1));
        this.conglomerate = DefaultQueryRunnerFactoryConglomerate.buildFromQueryRunnerFactories((Map)ImmutableMap.of(SearchQuery.class, (Object)this.factory));
        this.serverManagerExec = Execs.multiThreaded((int)2, (String)"ServerManagerTest-%d");
        this.queryProcessingPool = new ForwardingQueryProcessingPool(this.serverManagerExec);
        this.cachePopulator = new ForegroundCachePopulator((ObjectMapper)new DefaultObjectMapper(), new CachePopulatorStats(), -1L);
        this.objectMapper = new DefaultObjectMapper();
        this.cache = new LocalCacheProvider().get();
        this.cacheConfig = new CacheConfig();
        this.serverConfig = new ServerConfig();
        this.policyEnforcer = NoopPolicyEnforcer.instance();
        Guice.createInjector((Module[])new Module[]{BoundFieldModule.of((Object)this)}).injectMembers((Object)this);
    }

    @Test
    public void testSimpleGet() {
        Future<?> future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"P1d/2011-04-01"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"1", (Object)Intervals.of((String)"P1d/2011-04-01"))));
        this.waitForTestVerificationAndCleanup(future);
        future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"P2d/2011-04-02"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"1", (Object)Intervals.of((String)"P1d/2011-04-01")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"P1d/2011-04-02"))));
        this.waitForTestVerificationAndCleanup(future);
    }

    @Test
    public void testSimpleGetTombstone() {
        Future<?> future = this.assertQueryable(Granularities.DAY, "testTombstone", Intervals.of((String)"P1d/2011-04-01"), Collections.emptyList());
        this.waitForTestVerificationAndCleanup(future);
    }

    @Test
    public void testDelete1() {
        String dataSouce = "test";
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        Future<?> future = this.assertQueryable(Granularities.DAY, "test", interval, (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"2", (Object)interval)));
        this.waitForTestVerificationAndCleanup(future);
        this.dropQueryable("test", "2", interval);
        future = this.assertQueryable(Granularities.DAY, "test", interval, (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"1", (Object)interval)));
        this.waitForTestVerificationAndCleanup(future);
    }

    @Test
    public void testDelete2() {
        this.loadQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        Future<?> future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"2011-04-04/2011-04-06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"3", (Object)Intervals.of((String)"2011-04-04/2011-04-05"))));
        this.waitForTestVerificationAndCleanup(future);
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        this.dropQueryable("test", "1", Intervals.of((String)"2011-04-04/2011-04-05"));
        future = this.assertQueryable(Granularities.HOUR, "test", Intervals.of((String)"2011-04-04/2011-04-04T06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T00/2011-04-04T01")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T01/2011-04-04T02")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T02/2011-04-04T03")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T04/2011-04-04T05")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T05/2011-04-04T06"))));
        this.waitForTestVerificationAndCleanup(future);
        future = this.assertQueryable(Granularities.HOUR, "test", Intervals.of((String)"2011-04-04/2011-04-04T03"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T00/2011-04-04T01")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T01/2011-04-04T02")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T02/2011-04-04T03"))));
        this.waitForTestVerificationAndCleanup(future);
        future = this.assertQueryable(Granularities.HOUR, "test", Intervals.of((String)"2011-04-04T04/2011-04-04T06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T04/2011-04-04T05")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T05/2011-04-04T06"))));
        this.waitForTestVerificationAndCleanup(future);
    }

    @Test
    public void testReferenceCounting() throws Exception {
        this.loadQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        Future<?> future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"2011-04-04/2011-04-06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"3", (Object)Intervals.of((String)"2011-04-04/2011-04-05"))));
        this.factory.notifyLatch.await(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.factory.getReferenceProviders().size());
        for (ReferenceCountedSegmentProvider referenceCountingSegment : this.factory.getReferenceProviders()) {
            Assert.assertEquals((long)1L, (long)referenceCountingSegment.getNumReferences());
        }
        this.factory.waitYieldLatch.countDown();
        Assert.assertEquals((long)1L, (long)this.factory.getSegments().size());
        for (TestSegmentUtils.SegmentForTesting segment : this.factory.getSegments()) {
            Assert.assertFalse((boolean)segment.isClosed());
        }
        this.factory.waitLatch.countDown();
        future.get();
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        for (TestSegmentUtils.SegmentForTesting segment : this.factory.getSegments()) {
            Assert.assertTrue((boolean)segment.isClosed());
        }
    }

    @Test
    public void testReferenceCounting_whileQueryExecuting() throws Exception {
        this.loadQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        Future<?> future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"2011-04-04/2011-04-06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"3", (Object)Intervals.of((String)"2011-04-04/2011-04-05"))));
        this.factory.notifyLatch.await(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.factory.getReferenceProviders().size());
        for (ReferenceCountedSegmentProvider referenceCountingSegment : this.factory.getReferenceProviders()) {
            Assert.assertEquals((long)1L, (long)referenceCountingSegment.getNumReferences());
        }
        this.factory.waitYieldLatch.countDown();
        Assert.assertEquals((long)1L, (long)this.factory.getSegments().size());
        for (TestSegmentUtils.SegmentForTesting segment : this.factory.getSegments()) {
            Assert.assertFalse((boolean)segment.isClosed());
        }
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        for (TestSegmentUtils.SegmentForTesting segment : this.factory.getSegments()) {
            Assert.assertFalse((boolean)segment.isClosed());
        }
        this.factory.waitLatch.countDown();
        future.get();
        for (TestSegmentUtils.SegmentForTesting segment : this.factory.getSegments()) {
            Assert.assertTrue((boolean)segment.isClosed());
        }
    }

    @Test
    public void testReferenceCounting_multipleDrops() throws Exception {
        this.loadQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        Future<?> future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"2011-04-04/2011-04-06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"3", (Object)Intervals.of((String)"2011-04-04/2011-04-05"))));
        this.factory.notifyLatch.await(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.factory.getReferenceProviders().size());
        for (ReferenceCountedSegmentProvider referenceCountingSegment : this.factory.getReferenceProviders()) {
            Assert.assertEquals((long)1L, (long)referenceCountingSegment.getNumReferences());
        }
        this.factory.waitYieldLatch.countDown();
        Assert.assertEquals((long)1L, (long)this.factory.getSegments().size());
        for (TestSegmentUtils.SegmentForTesting segment : this.factory.getSegments()) {
            Assert.assertFalse((boolean)segment.isClosed());
        }
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        for (TestSegmentUtils.SegmentForTesting segment : this.factory.getSegments()) {
            Assert.assertFalse((boolean)segment.isClosed());
        }
        this.factory.waitLatch.countDown();
        future.get();
        for (TestSegmentUtils.SegmentForTesting segment : this.factory.getSegments()) {
            Assert.assertTrue((boolean)segment.isClosed());
        }
    }

    @Test
    public void testReferenceCounting_restrictedSegment() throws Exception {
        this.factory = new MyQueryRunnerFactory(new CountDownLatch(1), new CountDownLatch(1), new CountDownLatch(2));
        this.conglomerate = DefaultQueryRunnerFactoryConglomerate.buildFromQueryRunnerFactories((Map)ImmutableMap.of(SearchQuery.class, (Object)this.factory));
        this.serverManager = (ServerManager)Guice.createInjector((Module[])new Module[]{BoundFieldModule.of((Object)this)}).getInstance(ServerManager.class);
        Interval interval = Intervals.of((String)"P1d/2011-04-01");
        this.loadQueryable("test", "1", interval);
        SearchQuery query = ServerManagerTest.searchQuery("test", interval, Granularities.ALL);
        SearchQuery queryOnRestricted = ServerManagerTest.searchQuery((DataSource)RestrictedDataSource.create((DataSource)TableDataSource.create((String)"test"), (Policy)NoRestrictionPolicy.instance()), interval, Granularities.ALL);
        Future<?> future = this.assertQuery(query, interval, (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"1", (Object)interval)));
        Thread.sleep(1000L);
        Future<?> futureOnRestricted = this.assertQuery(queryOnRestricted, interval, (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"1", (Object)interval)));
        Assert.assertTrue((boolean)this.factory.notifyLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)1L, (long)this.factory.getReferenceProviders().size());
        Assert.assertEquals((long)2L, (long)this.factory.getReferenceProviders().get(0).getNumReferences());
        this.factory.waitYieldLatch.countDown();
        this.factory.waitLatch.countDown();
        future.get();
        futureOnRestricted.get();
        Assert.assertEquals((long)1L, (long)this.factory.getReferenceProviders().size());
        Assert.assertEquals((long)0L, (long)this.factory.getReferenceProviders().get(0).getNumReferences());
    }

    @Test
    public void testGetQueryRunnerForIntervals_whenTimelineIsMissingReturningNoopQueryRunner() {
        Interval interval = Intervals.of((String)"0000-01-01/P1D");
        QueryRunner queryRunner = this.serverManager.getQueryRunnerForIntervals((Query)ServerManagerTest.searchQuery("unknown_datasource", interval, Granularities.ALL), Collections.singletonList(interval));
        Assert.assertSame(NoopQueryRunner.class, queryRunner.getClass());
    }

    @Test
    public void testGetQueryRunnerForSegments_whenTimelineIsMissingReportingMissingSegmentsOnQueryDataSource() {
        Interval interval = Intervals.of((String)"0000-01-01/P1D");
        SearchQuery query = ServerManagerTest.searchQueryWithQueryDataSource("unknown_datasource", interval, Granularities.ALL);
        List<SegmentDescriptor> unknownSegments = Collections.singletonList(new SegmentDescriptor(interval, "unknown_version", 0));
        DruidException e = (DruidException)Assertions.assertThrows(DruidException.class, () -> this.serverManager.getQueryRunnerForSegments((Query)query, (Iterable)unknownSegments));
        Assert.assertTrue((boolean)e.getMessage().startsWith("Base dataSource"));
        Assert.assertTrue((boolean)e.getMessage().endsWith("is not a table!"));
    }

    @Test
    public void testGetQueryRunnerForSegments_whenTimelineIsMissingReportingMissingSegments() {
        Interval interval = Intervals.of((String)"0000-01-01/P1D");
        SearchQuery query = ServerManagerTest.searchQuery("unknown_datasource", interval, Granularities.ALL);
        List<SegmentDescriptor> unknownSegments = Collections.singletonList(new SegmentDescriptor(interval, "unknown_version", 0));
        DefaultResponseContext responseContext = DefaultResponseContext.createEmpty();
        List results = this.serverManager.getQueryRunnerForSegments((Query)query, unknownSegments).run(QueryPlus.wrap((Query)query), (ResponseContext)responseContext).toList();
        Assert.assertTrue((boolean)results.isEmpty());
        Assert.assertNotNull((Object)responseContext.getMissingSegments());
        Assert.assertEquals(unknownSegments, (Object)responseContext.getMissingSegments());
    }

    @Test
    public void testGetQueryRunnerForSegments_whenTimelineEntryIsMissingReportingMissingSegments() {
        Interval interval = Intervals.of((String)"P1d/2011-04-01");
        SearchQuery query = ServerManagerTest.searchQuery("test", interval, Granularities.ALL);
        List<SegmentDescriptor> unknownSegments = Collections.singletonList(new SegmentDescriptor(interval, "unknown_version", 0));
        DefaultResponseContext responseContext = DefaultResponseContext.createEmpty();
        List results = this.serverManager.getQueryRunnerForSegments((Query)query, unknownSegments).run(QueryPlus.wrap((Query)query), (ResponseContext)responseContext).toList();
        Assert.assertTrue((boolean)results.isEmpty());
        Assert.assertNotNull((Object)responseContext.getMissingSegments());
        Assert.assertEquals(unknownSegments, (Object)responseContext.getMissingSegments());
    }

    @Test
    public void testGetQueryRunnerForSegments_whenTimelinePartitionChunkIsMissingReportingMissingSegments() {
        Interval interval = Intervals.of((String)"P1d/2011-04-01");
        int unknownPartitionId = 1000;
        SearchQuery query = ServerManagerTest.searchQuery("test", interval, Granularities.ALL);
        List<SegmentDescriptor> unknownSegments = Collections.singletonList(new SegmentDescriptor(interval, "1", 1000));
        DefaultResponseContext responseContext = DefaultResponseContext.createEmpty();
        List results = this.serverManager.getQueryRunnerForSegments((Query)query, unknownSegments).run(QueryPlus.wrap((Query)query), (ResponseContext)responseContext).toList();
        Assert.assertTrue((boolean)results.isEmpty());
        Assert.assertNotNull((Object)responseContext.getMissingSegments());
        Assert.assertEquals(unknownSegments, (Object)responseContext.getMissingSegments());
    }

    @Test
    public void testGetQueryRunnerForSegments_whenSegmentIsClosedReportingMissingSegments() {
        Interval interval = Intervals.of((String)"P1d/2011-04-01");
        SearchQuery query = ServerManagerTest.searchQuery("test", interval, Granularities.ALL);
        Optional maybeTimeline = this.segmentManager.getTimeline(ExecutionVertex.of((Query)query).getBaseTableDataSource());
        Assume.assumeTrue((boolean)maybeTimeline.isPresent());
        List holders = ((VersionedIntervalTimeline)maybeTimeline.get()).lookup(interval);
        ArrayList<SegmentDescriptor> closedSegments = new ArrayList<SegmentDescriptor>();
        for (TimelineObjectHolder holder : holders) {
            for (PartitionChunk chunk : holder.getObject()) {
                ReferenceCountedSegmentProvider segment = (ReferenceCountedSegmentProvider)chunk.getObject();
                Assert.assertNotNull((Object)segment.getBaseSegment().getId());
                closedSegments.add(new SegmentDescriptor(segment.getBaseSegment().getDataInterval(), segment.getVersion(), segment.getBaseSegment().getId().getPartitionNum()));
                segment.close();
            }
        }
        DefaultResponseContext responseContext = DefaultResponseContext.createEmpty();
        List results = this.serverManager.getQueryRunnerForSegments((Query)query, closedSegments).run(QueryPlus.wrap((Query)query), (ResponseContext)responseContext).toList();
        Assert.assertTrue((boolean)results.isEmpty());
        Assert.assertNotNull((Object)responseContext.getMissingSegments());
        Assert.assertEquals(closedSegments, (Object)responseContext.getMissingSegments());
    }

    @Test
    public void testGetQueryRunnerForSegments_forUnknownQueryThrowingException() {
        Interval interval = Intervals.of((String)"P1d/2011-04-01");
        List<SegmentDescriptor> descriptors = Collections.singletonList(new SegmentDescriptor(interval, "1", 0));
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("test").intervals(interval.toString()).build();
        QueryUnsupportedException e = (QueryUnsupportedException)Assert.assertThrows(QueryUnsupportedException.class, () -> this.lambda$testGetQueryRunnerForSegments_forUnknownQueryThrowingException$1((Query)query, descriptors));
        Assert.assertTrue((boolean)e.getMessage().startsWith("Unknown query type"));
    }

    @Test
    public void testGetQueryRunnerForSegments_restricted() throws Exception {
        this.conglomerate = DefaultQueryRunnerFactoryConglomerate.buildFromQueryRunnerFactories((Map)ImmutableMap.of(SearchQuery.class, (Object)this.factory));
        this.serverManager = (ServerManager)Guice.createInjector((Module[])new Module[]{BoundFieldModule.of((Object)this)}).getInstance(ServerManager.class);
        Interval interval = Intervals.of((String)"P1d/2011-04-01");
        SearchQuery query = ServerManagerTest.searchQuery("test", interval, Granularities.ALL);
        SearchQuery queryOnRestricted = ServerManagerTest.searchQuery((DataSource)RestrictedDataSource.create((DataSource)TableDataSource.create((String)"test"), (Policy)NoRestrictionPolicy.instance()), interval, Granularities.ALL);
        this.serverManager.getQueryRunnerForIntervals((Query)query, (Iterable)ImmutableList.of((Object)interval)).run(QueryPlus.wrap((Query)query)).toList();
        this.policyEnforcer = new RestrictAllTablesPolicyEnforcer((List)ImmutableList.of((Object)NoRestrictionPolicy.class.getName()));
        this.serverManager = (ServerManager)Guice.createInjector((Module[])new Module[]{BoundFieldModule.of((Object)this)}).getInstance(ServerManager.class);
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> this.serverManager.getQueryRunnerForIntervals((Query)query, (Iterable)ImmutableList.of((Object)interval)).run(QueryPlus.wrap((Query)query)).toList());
        Assert.assertEquals((Object)DruidException.Category.FORBIDDEN, (Object)e.getCategory());
        Assert.assertEquals((Object)DruidException.Persona.OPERATOR, (Object)e.getTargetPersona());
        Assert.assertEquals((Object)"Failed security validation with segment [test_2011-03-31T00:00:00.000Z_2011-04-01T00:00:00.000Z_1]", (Object)e.getMessage());
        this.serverManager.getQueryRunnerForIntervals((Query)queryOnRestricted, (Iterable)ImmutableList.of((Object)interval)).run(QueryPlus.wrap((Query)queryOnRestricted)).toList();
    }

    private void waitForTestVerificationAndCleanup(Future future) {
        try {
            this.factory.notifyLatch.await(1000L, TimeUnit.MILLISECONDS);
            this.factory.waitLatch.countDown();
            future.get();
            this.factory.clearSegments();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private static SearchQuery searchQueryWithQueryDataSource(String datasource, Interval interval, Granularity granularity) {
        ImmutableList descriptors = ImmutableList.of((Object)new SegmentDescriptor(Intervals.of((String)"2000/3000"), "0", 0), (Object)new SegmentDescriptor(Intervals.of((String)"2000/3000"), "0", 1));
        return ServerManagerTest.searchQuery((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource(datasource).intervals((QuerySegmentSpec)new MultipleSpecificSegmentSpec((List)descriptors)).granularity(Granularities.ALL).build()), interval, granularity);
    }

    private static SearchQuery searchQuery(String datasource, Interval interval, Granularity granularity) {
        return ServerManagerTest.searchQuery((DataSource)TableDataSource.create((String)datasource), interval, granularity);
    }

    private static SearchQuery searchQuery(DataSource datasource, Interval interval, Granularity granularity) {
        return Druids.newSearchQueryBuilder().dataSource(datasource).intervals(Collections.singletonList(interval)).granularity(granularity).limit(10000).query("wow").build();
    }

    private Future<?> assertQueryable(Granularity granularity, String dataSource, Interval interval, List<Pair<String, Interval>> expected) {
        SearchQuery query = ServerManagerTest.searchQuery(dataSource, interval, granularity);
        return this.assertQuery(query, interval, expected);
    }

    private Future<?> assertQuery(SearchQuery query, Interval interval, List<Pair<String, Interval>> expected) {
        Iterator<Pair<String, Interval>> expectedIter = expected.iterator();
        List<Interval> intervals = Collections.singletonList(interval);
        QueryRunner runner = this.serverManager.getQueryRunnerForIntervals((Query)query, intervals);
        return this.serverManagerExec.submit(() -> {
            Sequence seq = runner.run(QueryPlus.wrap((Query)query));
            seq.toList();
            Iterator<TestSegmentUtils.SegmentForTesting> adaptersIter = this.factory.getSegments().iterator();
            while (expectedIter.hasNext() && adaptersIter.hasNext()) {
                Pair expectedVals = (Pair)expectedIter.next();
                TestSegmentUtils.SegmentForTesting value = adaptersIter.next();
                Assert.assertEquals((Object)expectedVals.lhs, (Object)value.getVersion());
                Assert.assertEquals((Object)expectedVals.rhs, (Object)value.getInterval());
            }
            Assert.assertFalse((boolean)expectedIter.hasNext());
            Assert.assertFalse((boolean)adaptersIter.hasNext());
        });
    }

    private void loadQueryable(String dataSource, String version, Interval interval) {
        try {
            DataSegment segment = "testTombstone".equals(dataSource) ? TestSegmentUtils.makeTombstoneSegment((String)dataSource, (String)version, (Interval)interval) : TestSegmentUtils.makeSegment((String)dataSource, (String)version, (Interval)interval);
            this.segmentManager.loadSegment(segment);
        }
        catch (IOException | SegmentLoadingException e) {
            throw new RuntimeException(e);
        }
    }

    private void dropQueryable(String dataSource, String version, Interval interval) {
        this.segmentManager.dropSegment(TestSegmentUtils.makeSegment((String)dataSource, (String)version, (Interval)interval));
    }

    private /* synthetic */ void lambda$testGetQueryRunnerForSegments_forUnknownQueryThrowingException$1(Query query, List descriptors) throws Throwable {
        this.serverManager.getQueryRunnerForSegments(query, (Iterable)descriptors);
    }

    private static class MyQueryRunnerFactory
    implements QueryRunnerFactory<Result<SearchResultValue>, SearchQuery> {
        private final CountDownLatch waitLatch;
        private final CountDownLatch waitYieldLatch;
        private final CountDownLatch notifyLatch;
        private final List<TestSegmentUtils.SegmentForTesting> segments = new ArrayList<TestSegmentUtils.SegmentForTesting>();
        private final List<ReferenceCountedSegmentProvider> referenceProviders = new ArrayList<ReferenceCountedSegmentProvider>();

        public MyQueryRunnerFactory(CountDownLatch waitLatch, CountDownLatch waitYieldLatch, CountDownLatch notifyLatch) {
            this.waitLatch = waitLatch;
            this.waitYieldLatch = waitYieldLatch;
            this.notifyLatch = notifyLatch;
        }

        public QueryRunner<Result<SearchResultValue>> createRunner(Segment segment) {
            if (!this.segments.stream().map(TestSegmentUtils.SegmentForTesting::getId).anyMatch(segmentId -> segment.getId().equals(segmentId))) {
                if (segment instanceof ReferenceCountedSegmentProvider.ReferenceClosingSegment) {
                    ReferenceCountedSegmentProvider provider = ((ReferenceCountedSegmentProvider.ReferenceClosingSegment)segment).getProvider();
                    this.referenceProviders.add(provider);
                    this.segments.add((TestSegmentUtils.SegmentForTesting)provider.getBaseSegment());
                } else {
                    throw new IAE("Unsupported segment instance: [%s]", new Object[]{segment.getClass()});
                }
            }
            return new BlockingQueryRunner<Result<SearchResultValue>>((QueryRunner<Result<SearchResultValue>>)new NoopQueryRunner(), this.waitLatch, this.waitYieldLatch, this.notifyLatch);
        }

        public QueryRunner<Result<SearchResultValue>> mergeRunners(QueryProcessingPool queryProcessingPool, Iterable<QueryRunner<Result<SearchResultValue>>> queryRunners) {
            return new ConcatQueryRunner(Sequences.simple(queryRunners));
        }

        public QueryToolChest<Result<SearchResultValue>, SearchQuery> getToolchest() {
            return new NoopQueryToolChest<Result<SearchResultValue>, SearchQuery>();
        }

        public List<TestSegmentUtils.SegmentForTesting> getSegments() {
            return this.segments;
        }

        public List<ReferenceCountedSegmentProvider> getReferenceProviders() {
            return this.referenceProviders;
        }

        public void clearSegments() {
            this.segments.clear();
        }
    }

    private static class BlockingSequence<T>
    extends YieldingSequenceBase<T> {
        private final Sequence<T> baseSequence;
        private final CountDownLatch waitLatch;
        private final CountDownLatch waitYieldLatch;
        private final CountDownLatch notifyLatch;

        private BlockingSequence(Sequence<T> baseSequence, CountDownLatch waitLatch, CountDownLatch waitYieldLatch, CountDownLatch notifyLatch) {
            this.baseSequence = baseSequence;
            this.waitLatch = waitLatch;
            this.waitYieldLatch = waitYieldLatch;
            this.notifyLatch = notifyLatch;
        }

        public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
            this.notifyLatch.countDown();
            try {
                this.waitYieldLatch.await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            final Yielder baseYielder = this.baseSequence.toYielder(initValue, accumulator);
            return new Yielder<OutType>(){

                public OutType get() {
                    try {
                        waitLatch.await(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return baseYielder.get();
                }

                public Yielder<OutType> next(OutType initValue) {
                    return baseYielder.next(initValue);
                }

                public boolean isDone() {
                    return baseYielder.isDone();
                }

                public void close() throws IOException {
                    baseYielder.close();
                }
            };
        }
    }

    private static class BlockingQueryRunner<T>
    implements QueryRunner<T> {
        private final QueryRunner<T> runner;
        private final CountDownLatch waitLatch;
        private final CountDownLatch waitYieldLatch;
        private final CountDownLatch notifyLatch;

        public BlockingQueryRunner(QueryRunner<T> runner, CountDownLatch waitLatch, CountDownLatch waitYieldLatch, CountDownLatch notifyLatch) {
            this.runner = runner;
            this.waitLatch = waitLatch;
            this.waitYieldLatch = waitYieldLatch;
            this.notifyLatch = notifyLatch;
        }

        public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
            return new BlockingSequence(this.runner.run(queryPlus, responseContext), this.waitLatch, this.waitYieldLatch, this.notifyLatch);
        }
    }

    public static class NoopQueryToolChest<T, QueryType extends Query<T>>
    extends QueryToolChest<T, QueryType> {
        public QueryRunner<T> mergeResults(QueryRunner<T> runner) {
            return runner;
        }

        public QueryMetrics<Query<?>> makeMetrics(QueryType query) {
            return new DefaultQueryMetrics();
        }

        public Function<T, T> makePreComputeManipulatorFn(QueryType query, MetricManipulationFn fn) {
            return Functions.identity();
        }

        public TypeReference<T> getResultTypeReference() {
            return new TypeReference<T>(){};
        }
    }
}

