/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import org.apache.druid.audit.AuditInfo;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigAuditEntry;
import org.apache.druid.server.coordinator.InlineSchemaDataSourceCompactionConfig;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSourceCompactionConfigAuditEntryTest {
    private final AuditInfo auditInfo = new AuditInfo("author", "identity", "comment", "ip");
    private final DataSourceCompactionConfigAuditEntry firstEntry = new DataSourceCompactionConfigAuditEntry(new ClusterCompactionConfig(Double.valueOf(0.1), Integer.valueOf(9), null, null, null), (DataSourceCompactionConfig)InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").build(), this.auditInfo, DateTimes.nowUtc());

    @Test
    public void testhasSameConfigWithSameBaseConfigIsTrue() {
        DataSourceCompactionConfigAuditEntry secondEntry = new DataSourceCompactionConfigAuditEntry(new ClusterCompactionConfig(Double.valueOf(0.1), Integer.valueOf(9), null, null, null), (DataSourceCompactionConfig)InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").build(), this.auditInfo, DateTimes.nowUtc());
        Assert.assertTrue((boolean)this.firstEntry.hasSameConfig(secondEntry));
        Assert.assertTrue((boolean)secondEntry.hasSameConfig(this.firstEntry));
    }

    @Test
    public void testhasSameConfigWithDifferentClusterConfigIsFalse() {
        DataSourceCompactionConfigAuditEntry secondEntry = new DataSourceCompactionConfigAuditEntry(new ClusterCompactionConfig(Double.valueOf(0.2), Integer.valueOf(9), null, null, null), (DataSourceCompactionConfig)InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").build(), this.auditInfo, DateTimes.nowUtc());
        Assert.assertFalse((boolean)this.firstEntry.hasSameConfig(secondEntry));
        Assert.assertFalse((boolean)secondEntry.hasSameConfig(this.firstEntry));
        secondEntry = new DataSourceCompactionConfigAuditEntry(new ClusterCompactionConfig(Double.valueOf(0.1), Integer.valueOf(10), null, null, null), (DataSourceCompactionConfig)InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").build(), this.auditInfo, DateTimes.nowUtc());
        Assert.assertFalse((boolean)this.firstEntry.hasSameConfig(secondEntry));
        Assert.assertFalse((boolean)secondEntry.hasSameConfig(this.firstEntry));
    }

    @Test
    public void testhasSameConfigWithDifferentDatasourceConfigIsFalse() {
        DataSourceCompactionConfigAuditEntry secondEntry = new DataSourceCompactionConfigAuditEntry(new ClusterCompactionConfig(Double.valueOf(0.1), Integer.valueOf(9), null, null, null), (DataSourceCompactionConfig)InlineSchemaDataSourceCompactionConfig.builder().forDataSource("koala").build(), this.auditInfo, DateTimes.nowUtc());
        Assert.assertFalse((boolean)this.firstEntry.hasSameConfig(secondEntry));
        Assert.assertFalse((boolean)secondEntry.hasSameConfig(this.firstEntry));
    }

    @Test
    public void testhasSameConfigWithNullDatasourceConfigIsFalse() {
        DataSourceCompactionConfigAuditEntry secondEntry = new DataSourceCompactionConfigAuditEntry(new ClusterCompactionConfig(Double.valueOf(0.1), Integer.valueOf(9), null, null, null), null, this.auditInfo, DateTimes.nowUtc());
        Assert.assertFalse((boolean)this.firstEntry.hasSameConfig(secondEntry));
        Assert.assertFalse((boolean)secondEntry.hasSameConfig(this.firstEntry));
    }
}

