/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidClusterTest {
    private static final List<DataSegment> SEGMENTS = CreateDataSegments.ofDatasource("test").forIntervals(2, Granularities.DAY).startingAt("2015-04-12").withNumPartitions(1).eachOfSizeInMb(100L);
    private static final ServerHolder NEW_REALTIME = new ServerHolder(new DruidServer("name1", "host2", null, 100L, ServerType.REALTIME, "tier1", 0).addDataSegment(SEGMENTS.get(0)).toImmutableDruidServer(), (LoadQueuePeon)new TestLoadQueuePeon());
    private static final ServerHolder NEW_HISTORICAL = new ServerHolder(new DruidServer("name1", "host2", null, 100L, ServerType.HISTORICAL, "tier1", 0).addDataSegment(SEGMENTS.get(0)).toImmutableDruidServer(), (LoadQueuePeon)new TestLoadQueuePeon());
    private DruidCluster.Builder clusterBuilder;

    @Before
    public void setup() {
        this.clusterBuilder = DruidCluster.builder().add(new ServerHolder(new DruidServer("name1", "host1", null, 100L, ServerType.REALTIME, "tier1", 0).addDataSegment(SEGMENTS.get(0)).toImmutableDruidServer(), (LoadQueuePeon)new TestLoadQueuePeon())).add(new ServerHolder(new DruidServer("name1", "host1", null, 100L, ServerType.HISTORICAL, "tier1", 0).addDataSegment(SEGMENTS.get(0)).toImmutableDruidServer(), (LoadQueuePeon)new TestLoadQueuePeon()));
    }

    @Test
    public void testAdd() {
        DruidCluster cluster = this.clusterBuilder.build();
        Assert.assertEquals((long)1L, (long)cluster.getHistoricals().values().stream().mapToInt(Collection::size).sum());
        Assert.assertEquals((long)1L, (long)cluster.getRealtimes().size());
        this.clusterBuilder.add(NEW_REALTIME);
        cluster = this.clusterBuilder.build();
        Assert.assertEquals((long)1L, (long)cluster.getHistoricals().values().stream().mapToInt(Collection::size).sum());
        Assert.assertEquals((long)2L, (long)cluster.getRealtimes().size());
        this.clusterBuilder.add(NEW_HISTORICAL);
        cluster = this.clusterBuilder.build();
        Assert.assertEquals((long)2L, (long)cluster.getHistoricals().values().stream().mapToInt(Collection::size).sum());
        Assert.assertEquals((long)2L, (long)cluster.getRealtimes().size());
    }

    @Test
    public void testGetAllManagedServers() {
        this.clusterBuilder.add(NEW_REALTIME);
        this.clusterBuilder.add(NEW_HISTORICAL);
        DruidCluster cluster = this.clusterBuilder.build();
        Set expectedRealtimes = cluster.getRealtimes();
        Map expectedHistoricals = cluster.getHistoricals();
        List allServers = cluster.getAllManagedServers();
        Assert.assertEquals((long)4L, (long)allServers.size());
        Assert.assertTrue((boolean)allServers.containsAll(cluster.getRealtimes()));
        Assert.assertTrue((boolean)allServers.containsAll(cluster.getHistoricals().values().stream().flatMap(Collection::stream).collect(Collectors.toList())));
        Assert.assertEquals((Object)expectedHistoricals, (Object)cluster.getHistoricals());
        Assert.assertEquals((Object)expectedRealtimes, (Object)cluster.getRealtimes());
    }

    @Test
    public void testIsEmpty() {
        DruidCluster emptyCluster = DruidCluster.EMPTY;
        Assert.assertFalse((boolean)this.clusterBuilder.build().isEmpty());
        Assert.assertTrue((boolean)emptyCluster.isEmpty());
    }
}

