/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.balancer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.coordinator.balancer.BalancerStrategy;
import org.apache.druid.server.coordinator.balancer.BalancerStrategyFactory;
import org.apache.druid.server.coordinator.balancer.CachingCostBalancerStrategy;
import org.apache.druid.server.coordinator.balancer.CostBalancerStrategy;
import org.apache.druid.server.coordinator.balancer.CostBalancerStrategyFactory;
import org.junit.Assert;
import org.junit.Test;

public class BalancerStrategyFactoryTest {
    private final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testCachingCostStrategyFallsBackToCost() throws JsonProcessingException {
        String json = "{\"strategy\":\"cachingCost\"}";
        BalancerStrategyFactory factory = (BalancerStrategyFactory)this.MAPPER.readValue("{\"strategy\":\"cachingCost\"}", BalancerStrategyFactory.class);
        BalancerStrategy strategy = factory.createBalancerStrategy(1);
        Assert.assertTrue((boolean)(strategy instanceof CostBalancerStrategy));
        Assert.assertFalse((boolean)(strategy instanceof CachingCostBalancerStrategy));
        factory.stopExecutor();
    }

    @Test
    public void testBalancerFactoryCreatesNewExecutorIfNumThreadsChanges() {
        CostBalancerStrategyFactory factory = new CostBalancerStrategyFactory();
        ListeningExecutorService exec1 = factory.getOrCreateBalancerExecutor(1);
        ListeningExecutorService exec2 = factory.getOrCreateBalancerExecutor(2);
        Assert.assertTrue((boolean)exec1.isShutdown());
        Assert.assertNotSame((Object)exec1, (Object)exec2);
        ListeningExecutorService exec3 = factory.getOrCreateBalancerExecutor(3);
        Assert.assertTrue((boolean)exec2.isShutdown());
        Assert.assertNotSame((Object)exec2, (Object)exec3);
        ListeningExecutorService exec4 = factory.getOrCreateBalancerExecutor(3);
        Assert.assertFalse((boolean)exec3.isShutdown());
        Assert.assertSame((Object)exec3, (Object)exec4);
        factory.stopExecutor();
    }
}

