/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.config.MetadataCleanupConfig;
import org.apache.druid.server.coordinator.duty.KillDatasourceMetadata;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillDatasourceMetadataTest {
    @Mock
    private IndexerMetadataStorageCoordinator mockIndexerMetadataStorageCoordinator;
    @Mock
    private MetadataSupervisorManager mockMetadataSupervisorManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    private KillDatasourceMetadata killDatasourceMetadata;
    private CoordinatorRunStats runStats;

    @Before
    public void setup() {
        this.runStats = new CoordinatorRunStats();
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)this.runStats);
    }

    @Test
    public void testRunSkipIfLastRunLessThanPeriod() {
        MetadataCleanupConfig config = new MetadataCleanupConfig(Boolean.valueOf(true), new Duration(Long.MAX_VALUE), new Duration((Object)"PT1S"));
        this.killDatasourceMetadata = new KillDatasourceMetadata(config, this.mockIndexerMetadataStorageCoordinator, this.mockMetadataSupervisorManager);
        this.killDatasourceMetadata.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockIndexerMetadataStorageCoordinator});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockMetadataSupervisorManager});
    }

    @Test
    public void testRunNotSkipIfLastRunMoreThanPeriod() {
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)this.runStats);
        MetadataCleanupConfig config = new MetadataCleanupConfig(Boolean.valueOf(true), new Duration((Object)"PT6S"), new Duration((Object)"PT1S"));
        this.killDatasourceMetadata = new KillDatasourceMetadata(config, this.mockIndexerMetadataStorageCoordinator, this.mockMetadataSupervisorManager);
        this.killDatasourceMetadata.run(this.mockDruidCoordinatorRuntimeParams);
        ((IndexerMetadataStorageCoordinator)Mockito.verify((Object)this.mockIndexerMetadataStorageCoordinator)).removeDataSourceMetadataOlderThan(ArgumentMatchers.anyLong(), ArgumentMatchers.anySet());
        Assert.assertTrue((boolean)this.runStats.hasStat(Stats.Kill.DATASOURCES));
    }

    @Test
    public void testRunWithEmptyFilterExcludedDatasource() {
        MetadataCleanupConfig config = new MetadataCleanupConfig(Boolean.valueOf(true), new Duration((Object)"PT6S"), new Duration((Object)"PT1S"));
        this.killDatasourceMetadata = new KillDatasourceMetadata(config, this.mockIndexerMetadataStorageCoordinator, this.mockMetadataSupervisorManager);
        this.killDatasourceMetadata.run(this.mockDruidCoordinatorRuntimeParams);
        ((IndexerMetadataStorageCoordinator)Mockito.verify((Object)this.mockIndexerMetadataStorageCoordinator)).removeDataSourceMetadataOlderThan(ArgumentMatchers.anyLong(), (Set)ArgumentMatchers.eq((Object)ImmutableSet.of()));
        Assert.assertTrue((boolean)this.runStats.hasStat(Stats.Kill.DATASOURCES));
    }
}

