/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.client.DruidServer;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulation;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulationBaseTest;
import org.apache.druid.timeline.DataSegment;
import org.junit.Test;

public class MarkSegmentsAsUnusedTest
extends CoordinatorSimulationBaseTest {
    @Override
    public void setUp() {
    }

    @Test
    public void testSegmentsOvershadowedByZeroReplicaSegmentsAreMarkedAsUnused() {
        long size1TB = 1000000L;
        ArrayList<DruidServer> servers = new ArrayList<DruidServer>();
        for (int i = 0; i < 2; ++i) {
            servers.add(MarkSegmentsAsUnusedTest.createHistorical(i, "tier_t1", 1000000L));
        }
        List<DataSegment> segmentsV0 = CoordinatorSimulationBaseTest.Segments.WIKI_10X1D;
        CoordinatorDynamicConfig dynamicConfig = CoordinatorDynamicConfig.builder().withMarkSegmentAsUnusedDelayMillis(0L).build();
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 0).forever()).withServers(servers).withSegments(segmentsV0).withDynamicConfig(dynamicConfig).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyNotEmitted("segment/assigned/count");
        List<DataSegment> segmentsV1 = segmentsV0.stream().map(segment -> segment.withVersion(segment.getVersion() + "__new")).collect(Collectors.toList());
        this.addSegments(segmentsV1);
        this.runCoordinatorCycle();
        this.verifyNotEmitted("segment/assigned/count");
        this.verifyValue("segment/overshadowed/count", 10L);
    }
}

