/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.emitter;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Properties;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ServerModule;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.NoopEmitter;
import org.apache.druid.java.util.emitter.core.ParametrizedUriEmitter;
import org.apache.druid.server.emitter.EmitterModule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class EmitterModuleTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testParametrizedUriEmitterConfig() {
        Properties props = new Properties();
        props.setProperty("druid.emitter", "parametrized");
        props.setProperty("druid.emitter.parametrized.recipientBaseUrlPattern", "http://example.com:8888/{feed}");
        props.setProperty("druid.emitter.parametrized.httpEmitting.flushMillis", "1");
        props.setProperty("druid.emitter.parametrized.httpEmitting.flushCount", "2");
        props.setProperty("druid.emitter.parametrized.httpEmitting.basicAuthentication", "a:b");
        props.setProperty("druid.emitter.parametrized.httpEmitting.batchingStrategy", "NEWLINES");
        props.setProperty("druid.emitter.parametrized.httpEmitting.maxBatchSize", "4");
        props.setProperty("druid.emitter.parametrized.httpEmitting.flushTimeOut", "1000");
        Emitter emitter = (Emitter)this.makeInjectorWithProperties(props).getInstance(Emitter.class);
        Assert.assertThat((Object)emitter, (Matcher)CoreMatchers.instanceOf(ParametrizedUriEmitter.class));
    }

    @Test
    public void testMissingEmitterType() {
        Properties props = new Properties();
        props.setProperty("druid.emitter", "");
        Emitter emitter = (Emitter)this.makeInjectorWithProperties(props).getInstance(Emitter.class);
        Assert.assertThat((Object)emitter, (Matcher)CoreMatchers.instanceOf(NoopEmitter.class));
    }

    @Test
    public void testInvalidEmitterType() {
        Properties props = new Properties();
        props.setProperty("druid.emitter", "invalid");
        this.expectedException.expectMessage("Unknown emitter type[druid.emitter]=[invalid]");
        this.makeInjectorWithProperties(props).getInstance(Emitter.class);
    }

    private Injector makeInjectorWithProperties(final Properties props) {
        EmitterModule emitterModule = new EmitterModule();
        emitterModule.setProps(props);
        return Guice.createInjector((Iterable)ImmutableList.of((Object)new DruidGuiceExtensions(), (Object)new LifecycleModule(), (Object)new ServerModule(), (Object)new JacksonModule(), (Object)new Module(){

            public void configure(Binder binder) {
                binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
                binder.bind(JsonConfigurator.class).in(LazySingleton.class);
                binder.bind(Properties.class).toInstance((Object)props);
            }
        }, (Object)emitterModule));
    }
}

