/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.server.coordinator.CloneStatusManager;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.ServerCloneStatus;
import org.apache.druid.server.http.BrokerSyncStatus;
import org.apache.druid.server.http.CloneStatus;
import org.apache.druid.server.http.ConfigSyncStatus;
import org.apache.druid.server.http.CoordinatorDynamicConfigSyncer;
import org.apache.druid.server.http.CoordinatorDynamicConfigsResource;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoordinatorDynamicConfigsResourceTest {
    private CoordinatorConfigManager manager;
    private AuditManager auditManager;
    private CoordinatorDynamicConfigSyncer coordinatorDynamicConfigSyncer;
    private CloneStatusManager cloneStatusManager;

    @Before
    public void setUp() throws Exception {
        this.manager = (CoordinatorConfigManager)EasyMock.createStrictMock(CoordinatorConfigManager.class);
        this.auditManager = (AuditManager)EasyMock.createStrictMock(AuditManager.class);
        this.coordinatorDynamicConfigSyncer = (CoordinatorDynamicConfigSyncer)EasyMock.createStrictMock(CoordinatorDynamicConfigSyncer.class);
        this.cloneStatusManager = (CloneStatusManager)EasyMock.createStrictMock(CloneStatusManager.class);
    }

    @Test
    public void testGetBrokerStatus() {
        EasyMock.expect((Object)this.coordinatorDynamicConfigSyncer.getInSyncBrokers()).andReturn((Object)ImmutableSet.of((Object)new BrokerSyncStatus("host1", 8080, 1000L))).once();
        EasyMock.replay((Object[])new Object[]{this.coordinatorDynamicConfigSyncer});
        EasyMock.replay((Object[])new Object[]{this.cloneStatusManager});
        Response response = new CoordinatorDynamicConfigsResource(this.manager, this.auditManager, this.coordinatorDynamicConfigSyncer, this.cloneStatusManager).getBrokerStatus();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ConfigSyncStatus expected = new ConfigSyncStatus((Set)ImmutableSet.of((Object)new BrokerSyncStatus("host1", 8080, 1000L)));
        Assert.assertEquals((Object)expected, (Object)response.getEntity());
    }

    @Test
    public void testGetCloneStatus() {
        ImmutableList statusMetrics = ImmutableList.of((Object)new ServerCloneStatus("hist3", "hist1", ServerCloneStatus.State.IN_PROGRESS, 2L, 0L, 1000L), (Object)ServerCloneStatus.unknown((String)"hist4", (String)"hist3"));
        EasyMock.expect((Object)this.cloneStatusManager.getStatusForAllServers()).andReturn((Object)statusMetrics).once();
        EasyMock.expect((Object)this.cloneStatusManager.getStatusForServer("hist2")).andReturn((Object)ServerCloneStatus.unknown((String)"hist4", (String)"hist3")).once();
        EasyMock.replay((Object[])new Object[]{this.coordinatorDynamicConfigSyncer});
        EasyMock.replay((Object[])new Object[]{this.cloneStatusManager});
        CoordinatorDynamicConfigsResource resource = new CoordinatorDynamicConfigsResource(this.manager, this.auditManager, this.coordinatorDynamicConfigSyncer, this.cloneStatusManager);
        Response response = resource.getCloneStatus(null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new CloneStatus((List)statusMetrics), (Object)response.getEntity());
        response = resource.getCloneStatus("hist2");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ServerCloneStatus.unknown((String)"hist4", (String)"hist3"), (Object)response.getEntity());
    }
}

