/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.server.http.SegmentLoadingCapabilities;
import org.junit.Assert;
import org.junit.Test;

public class SegmentLoadingCapabilitiesTest {
    private final ObjectMapper jsonMapper = new DefaultObjectMapper();

    @Test
    public void testSerde() throws Exception {
        SegmentLoadingCapabilities capabilities = new SegmentLoadingCapabilities(1, 4);
        SegmentLoadingCapabilities reread = (SegmentLoadingCapabilities)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString((Object)capabilities), SegmentLoadingCapabilities.class);
        Assert.assertEquals((long)capabilities.getNumLoadingThreads(), (long)reread.getNumLoadingThreads());
        Assert.assertEquals((long)capabilities.getNumTurboLoadingThreads(), (long)reread.getNumTurboLoadingThreads());
    }

    @Test
    public void testSerdeFromJson() throws JsonProcessingException {
        String json = "{\"numLoadingThreads\":3,\"numTurboLoadingThreads\":5}";
        SegmentLoadingCapabilities reread = (SegmentLoadingCapabilities)this.jsonMapper.readValue(json, SegmentLoadingCapabilities.class);
        Assert.assertEquals((long)3L, (long)reread.getNumLoadingThreads());
        Assert.assertEquals((long)5L, (long)reread.getNumTurboLoadingThreads());
    }
}

