/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import javax.ws.rs.core.Response;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.server.http.ServletResourceUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ServletResourceUtilsTest {
    @Test
    public void testSanitizeException() {
        String message = "some message";
        Assert.assertEquals((Object)"some message", ServletResourceUtils.sanitizeException((Throwable)new Throwable("some message")).get("error"));
        Assert.assertEquals((Object)"null", ServletResourceUtils.sanitizeException(null).get("error"));
        Assert.assertEquals((Object)"some message", ServletResourceUtils.sanitizeException((Throwable)new Throwable(){

            @Override
            public String toString() {
                return "some message";
            }
        }).get("error"));
    }

    @Test
    public void testBuildErrorReponseFrom() {
        DruidException exception = InvalidInput.exception((String)"Invalid value of [%s]", (Object[])new Object[]{"inputKey"});
        Response response = ServletResourceUtils.buildErrorResponseFrom((DruidException)exception);
        Assert.assertEquals((long)exception.getStatusCode(), (long)response.getStatus());
        Object entity = response.getEntity();
        Assert.assertTrue((boolean)(entity instanceof ErrorResponse));
        MatcherAssert.assertThat((Object)((ErrorResponse)entity).getUnderlyingException(), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value of [inputKey]"));
    }
}

