/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.druid.client.DruidServerConfig;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.server.metrics.SegmentRowCountDistribution;
import org.apache.druid.server.metrics.SegmentStatsMonitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SegmentStatsMonitorTest {
    private static final String DATA_SOURCE = "dataSource";
    private static final int PRIORITY = 111;
    private static final String TIER = "tier";
    private DruidServerConfig druidServerConfig;
    private SegmentLoadDropHandler segmentLoadDropMgr;
    private ServiceEmitter serviceEmitter;
    private SegmentStatsMonitor monitor;
    private final SegmentLoaderConfig segmentLoaderConfig = new SegmentLoaderConfig();

    @Before
    public void setUp() {
        this.druidServerConfig = (DruidServerConfig)Mockito.mock(DruidServerConfig.class);
        this.segmentLoadDropMgr = (SegmentLoadDropHandler)Mockito.mock(SegmentLoadDropHandler.class);
        this.serviceEmitter = (ServiceEmitter)Mockito.mock(ServiceEmitter.class);
        this.monitor = new SegmentStatsMonitor(this.druidServerConfig, this.segmentLoadDropMgr, this.segmentLoaderConfig);
        Mockito.when((Object)this.druidServerConfig.getTier()).thenReturn((Object)TIER);
        Mockito.when((Object)this.druidServerConfig.getPriority()).thenReturn((Object)111);
    }

    @Test(expected=IllegalStateException.class)
    public void testLazyLoadOnStartThrowsException() {
        SegmentLoaderConfig segmentLoaderConfig = (SegmentLoaderConfig)Mockito.mock(SegmentLoaderConfig.class);
        Mockito.when((Object)segmentLoaderConfig.isLazyLoadOnStart()).thenReturn((Object)true);
        new SegmentStatsMonitor(this.druidServerConfig, this.segmentLoadDropMgr, segmentLoaderConfig);
    }

    @Test
    public void testSimple() {
        SegmentRowCountDistribution segmentRowCountDistribution = new SegmentRowCountDistribution();
        segmentRowCountDistribution.addRowCountToDistribution(100000L);
        Mockito.when((Object)this.segmentLoadDropMgr.getAverageNumOfRowsPerSegmentForDatasource()).thenReturn((Object)ImmutableMap.of((Object)DATA_SOURCE, (Object)100000L));
        Mockito.when((Object)this.segmentLoadDropMgr.getRowCountDistributionPerDatasource()).thenReturn((Object)ImmutableMap.of((Object)DATA_SOURCE, (Object)segmentRowCountDistribution));
        ArgumentCaptor eventArgumentCaptor = ArgumentCaptor.forClass(ServiceEventBuilder.class);
        this.monitor.doMonitor(this.serviceEmitter);
        ((ServiceEmitter)Mockito.verify((Object)this.serviceEmitter, (VerificationMode)Mockito.atLeastOnce())).emit((ServiceEventBuilder)eventArgumentCaptor.capture());
        List<Map<String, Object>> eventsAsMaps = this.getEventMaps(eventArgumentCaptor.getAllValues());
        Map<String, Map<String, Object>> actual = this.metricKeyedMap(eventsAsMaps);
        ArrayList<ServiceEventBuilder<ServiceMetricEvent>> expectedEvents = new ArrayList<ServiceEventBuilder<ServiceMetricEvent>>();
        expectedEvents.add(this.averageRowCountEvent(100000L));
        expectedEvents.add(this.rowCountRangeEvent("1-10k", 0));
        expectedEvents.add(this.rowCountRangeEvent("10k-2M", 1));
        expectedEvents.add(this.rowCountRangeEvent("2M-4M", 0));
        expectedEvents.add(this.rowCountRangeEvent("4M-6M", 0));
        expectedEvents.add(this.rowCountRangeEvent("6M-8M", 0));
        expectedEvents.add(this.rowCountRangeEvent("8M-10M", 0));
        expectedEvents.add(this.rowCountRangeEvent("10M+", 0));
        List<Map<String, Object>> expectedEventsAsMap = this.getEventMaps(expectedEvents);
        Map<String, Map<String, Object>> expected = this.metricKeyedMap(expectedEventsAsMap);
        Assert.assertEquals((String)"different number of metrics were returned", (long)expected.size(), (long)actual.size());
        for (Map.Entry<String, Map<String, Object>> expectedKeyedEntry : expected.entrySet()) {
            Map<String, Object> actualValue = actual.get(expectedKeyedEntry.getKey());
            this.assertMetricMapsEqual(expectedKeyedEntry.getKey(), expectedKeyedEntry.getValue(), actualValue);
        }
    }

    @Test
    public void testZeroAndTombstoneDistribution() {
        SegmentRowCountDistribution segmentRowCountDistribution = new SegmentRowCountDistribution();
        segmentRowCountDistribution.addRowCountToDistribution(100000L);
        segmentRowCountDistribution.addRowCountToDistribution(0L);
        segmentRowCountDistribution.addTombstoneToDistribution();
        segmentRowCountDistribution.addTombstoneToDistribution();
        Mockito.when((Object)this.segmentLoadDropMgr.getAverageNumOfRowsPerSegmentForDatasource()).thenReturn((Object)ImmutableMap.of((Object)DATA_SOURCE, (Object)50000L));
        Mockito.when((Object)this.segmentLoadDropMgr.getRowCountDistributionPerDatasource()).thenReturn((Object)ImmutableMap.of((Object)DATA_SOURCE, (Object)segmentRowCountDistribution));
        ArgumentCaptor eventArgumentCaptor = ArgumentCaptor.forClass(ServiceEventBuilder.class);
        this.monitor.doMonitor(this.serviceEmitter);
        ((ServiceEmitter)Mockito.verify((Object)this.serviceEmitter, (VerificationMode)Mockito.atLeastOnce())).emit((ServiceEventBuilder)eventArgumentCaptor.capture());
        List<Map<String, Object>> eventsAsMaps = this.getEventMaps(eventArgumentCaptor.getAllValues());
        Map<String, Map<String, Object>> actual = this.metricKeyedMap(eventsAsMaps);
        ArrayList<ServiceEventBuilder<ServiceMetricEvent>> expectedEvents = new ArrayList<ServiceEventBuilder<ServiceMetricEvent>>();
        expectedEvents.add(this.averageRowCountEvent(50000L));
        expectedEvents.add(this.rowCountRangeEvent("0", 1));
        expectedEvents.add(this.rowCountRangeEvent("Tombstone", 2));
        expectedEvents.add(this.rowCountRangeEvent("1-10k", 0));
        expectedEvents.add(this.rowCountRangeEvent("10k-2M", 1));
        expectedEvents.add(this.rowCountRangeEvent("2M-4M", 0));
        expectedEvents.add(this.rowCountRangeEvent("4M-6M", 0));
        expectedEvents.add(this.rowCountRangeEvent("6M-8M", 0));
        expectedEvents.add(this.rowCountRangeEvent("8M-10M", 0));
        expectedEvents.add(this.rowCountRangeEvent("10M+", 0));
        List<Map<String, Object>> expectedEventsAsMap = this.getEventMaps(expectedEvents);
        Map<String, Map<String, Object>> expected = this.metricKeyedMap(expectedEventsAsMap);
        Assert.assertEquals((String)"different number of metrics were returned", (long)expected.size(), (long)actual.size());
        for (Map.Entry<String, Map<String, Object>> expectedKeyedEntry : expected.entrySet()) {
            Map<String, Object> actualValue = actual.get(expectedKeyedEntry.getKey());
            this.assertMetricMapsEqual(expectedKeyedEntry.getKey(), expectedKeyedEntry.getValue(), actualValue);
        }
    }

    private void assertMetricMapsEqual(String messagePrefix, Map<String, Object> expected, Map<String, Object> actual) {
        Assert.assertEquals((String)"different number of expected values for metrics", (long)expected.size(), (long)actual.size());
        for (Map.Entry<String, Object> expectedMetricEntry : expected.entrySet()) {
            Assert.assertEquals((String)(messagePrefix + " " + expectedMetricEntry.getKey()), (Object)expectedMetricEntry.getValue(), (Object)actual.get(expectedMetricEntry.getKey()));
        }
    }

    @Nonnull
    private List<Map<String, Object>> getEventMaps(List<ServiceEventBuilder<ServiceMetricEvent>> eventBuilders) {
        return eventBuilders.stream().map(eventBuilder -> new HashMap(((ServiceMetricEvent)eventBuilder.build(ImmutableMap.of())).toMap())).peek(mappedValues -> mappedValues.remove("timestamp")).collect(Collectors.toList());
    }

    private Map<String, Map<String, Object>> metricKeyedMap(List<Map<String, Object>> eventsAsMaps) {
        return eventsAsMaps.stream().collect(Collectors.toMap(eventasdf -> {
            String metricName = eventasdf.get("metric").toString();
            String range = eventasdf.getOrDefault("range", "").toString();
            return metricName + range;
        }, Function.identity()));
    }

    private ServiceEventBuilder<ServiceMetricEvent> averageRowCountEvent(Number value) {
        return new ServiceMetricEvent.Builder().setDimension(DATA_SOURCE, (Object)DATA_SOURCE).setDimension(TIER, (Object)TIER).setDimension("priority", (Object)String.valueOf(111)).setMetric("segment/rowCount/avg", value);
    }

    private ServiceEventBuilder<ServiceMetricEvent> rowCountRangeEvent(String range, Number value) {
        return new ServiceMetricEvent.Builder().setDimension(DATA_SOURCE, (Object)DATA_SOURCE).setDimension(TIER, (Object)TIER).setDimension("priority", (Object)String.valueOf(111)).setDimension("range", (Object)range).setMetric("segment/rowCount/range/count", value);
    }
}

