/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.CoordinatorStat;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.metrics.TaskCountStatsMonitor;
import org.apache.druid.server.metrics.TaskCountStatsProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskCountStatsMonitorTest {
    private TaskCountStatsProvider statsProvider;
    private static final RowKey TASK_METRIC_KEY1 = RowKey.with((Dimension)Dimension.DATASOURCE, (String)"d1").with(Dimension.TASK_TYPE, "index").build();
    private static final RowKey TASK_METRIC_KEY2 = RowKey.with((Dimension)Dimension.DATASOURCE, (String)"d1").with(Dimension.TASK_TYPE, "kill").build();

    @Before
    public void setUp() {
        this.statsProvider = new TaskCountStatsProvider(){

            public Map<RowKey, Long> getSuccessfulTaskCount() {
                return ImmutableMap.of((Object)TASK_METRIC_KEY1, (Object)1L);
            }

            public Map<RowKey, Long> getFailedTaskCount() {
                return ImmutableMap.of((Object)TASK_METRIC_KEY1, (Object)1L, (Object)TASK_METRIC_KEY2, (Object)1L);
            }

            public Map<RowKey, Long> getRunningTaskCount() {
                return ImmutableMap.of((Object)TASK_METRIC_KEY1, (Object)1L);
            }

            public Map<RowKey, Long> getPendingTaskCount() {
                return ImmutableMap.of((Object)TASK_METRIC_KEY1, (Object)2L);
            }

            public Map<RowKey, Long> getWaitingTaskCount() {
                return ImmutableMap.of((Object)TASK_METRIC_KEY1, (Object)2L, (Object)TASK_METRIC_KEY2, (Object)1L);
            }

            public CoordinatorRunStats getStats() {
                CoordinatorRunStats stats = new CoordinatorRunStats();
                stats.add(Stat.INFO_1, 10L);
                stats.addToSegmentStat(Stat.DEBUG_1, "hot", "wiki", 20L);
                return stats;
            }
        };
    }

    @Test
    public void testMonitor() {
        TaskCountStatsMonitor monitor = new TaskCountStatsMonitor(this.statsProvider);
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)9L, (long)emitter.getEvents().size());
        emitter.verifyValue("task/success/count", Map.of("dataSource", "d1", "taskType", "index"), (Number)1L);
        emitter.verifyValue("task/failed/count", Map.of("dataSource", "d1", "taskType", "index"), (Number)1L);
        emitter.verifyValue("task/failed/count", Map.of("dataSource", "d1", "taskType", "kill"), (Number)1L);
        emitter.verifyValue("task/running/count", Map.of("dataSource", "d1", "taskType", "index"), (Number)1L);
        emitter.verifyValue("task/pending/count", Map.of("dataSource", "d1", "taskType", "index"), (Number)2L);
        emitter.verifyValue("task/waiting/count", Map.of("dataSource", "d1", "taskType", "index"), (Number)2L);
        emitter.verifyValue("task/waiting/count", Map.of("dataSource", "d1", "taskType", "kill"), (Number)1L);
        emitter.verifyValue(Stat.INFO_1.getMetricName(), (Number)10L);
        emitter.verifyValue(Stat.DEBUG_1.getMetricName(), Map.of("tier", "hot", "dataSource", "wiki"), (Number)20L);
    }

    private static class Stat {
        static final CoordinatorStat INFO_1 = CoordinatorStat.toLogAndEmit((String)"i1", (String)"info/1", (CoordinatorStat.Level)CoordinatorStat.Level.INFO);
        static final CoordinatorStat DEBUG_1 = CoordinatorStat.toDebugAndEmit((String)"d1", (String)"debug/1");

        private Stat() {
        }
    }
}

