/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.scheduling;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.client.SegmentServerSelector;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.server.scheduling.ThresholdBasedQueryPrioritizationStrategy;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ThresholdBasedQueryPrioritizationStrategyTest {
    private final Integer adjustment = 10;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private Druids.TimeseriesQueryBuilder queryBuilder;

    @Before
    public void setup() {
        this.queryBuilder = Druids.newTimeseriesQueryBuilder().dataSource("test").aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")});
    }

    @Test
    public void testPrioritizationPeriodThresholdInsidePeriod() {
        ThresholdBasedQueryPrioritizationStrategy strategy = new ThresholdBasedQueryPrioritizationStrategy("P90D", null, null, null, this.adjustment);
        DateTime startDate = DateTimes.nowUtc().minusDays(1);
        DateTime endDate = DateTimes.nowUtc();
        TimeseriesQuery query = this.queryBuilder.intervals((List)ImmutableList.of((Object)new Interval((ReadableInstant)startDate, (ReadableInstant)endDate))).granularity(Granularities.MINUTE).context((Map)ImmutableMap.of()).build();
        Assert.assertFalse((boolean)strategy.computePriority(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).isPresent());
    }

    @Test
    public void testPrioritizationPeriodThresholdOutsidePeriod() {
        ThresholdBasedQueryPrioritizationStrategy strategy = new ThresholdBasedQueryPrioritizationStrategy("P90D", null, null, null, this.adjustment);
        DateTime startDate = DateTimes.nowUtc().minusDays(100);
        DateTime endDate = DateTimes.nowUtc().minusDays(80);
        TimeseriesQuery query = this.queryBuilder.intervals((List)ImmutableList.of((Object)new Interval((ReadableInstant)startDate, (ReadableInstant)endDate))).granularity(Granularities.HOUR).context((Map)ImmutableMap.of()).build();
        Assert.assertEquals((long)(-this.adjustment.intValue()), (long)((Integer)strategy.computePriority(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).get()).intValue());
    }

    @Test
    public void testPrioritizationDurationThresholdInsideDuration() {
        ThresholdBasedQueryPrioritizationStrategy strategy = new ThresholdBasedQueryPrioritizationStrategy(null, "P7D", null, null, this.adjustment);
        DateTime startDate = DateTimes.nowUtc().minusDays(1);
        DateTime endDate = DateTimes.nowUtc();
        TimeseriesQuery query = this.queryBuilder.intervals((List)ImmutableList.of((Object)new Interval((ReadableInstant)startDate, (ReadableInstant)endDate))).granularity(Granularities.MINUTE).context((Map)ImmutableMap.of()).build();
        Assert.assertFalse((boolean)strategy.computePriority(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).isPresent());
    }

    @Test
    public void testPrioritizationDurationThresholdOutsideDuration() {
        ThresholdBasedQueryPrioritizationStrategy strategy = new ThresholdBasedQueryPrioritizationStrategy(null, "P7D", null, null, this.adjustment);
        DateTime startDate = DateTimes.nowUtc().minusDays(20);
        DateTime endDate = DateTimes.nowUtc();
        TimeseriesQuery query = this.queryBuilder.intervals((List)ImmutableList.of((Object)new Interval((ReadableInstant)startDate, (ReadableInstant)endDate))).granularity(Granularities.HOUR).context((Map)ImmutableMap.of()).build();
        Assert.assertEquals((long)(-this.adjustment.intValue()), (long)((Integer)strategy.computePriority(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).get()).intValue());
    }

    @Test
    public void testPrioritizationSegmentCountWithinThreshold() {
        ThresholdBasedQueryPrioritizationStrategy strategy = new ThresholdBasedQueryPrioritizationStrategy(null, null, Integer.valueOf(2), null, this.adjustment);
        DateTime startDate = DateTimes.nowUtc().minusDays(1);
        DateTime endDate = DateTimes.nowUtc();
        TimeseriesQuery query = this.queryBuilder.intervals((List)ImmutableList.of((Object)new Interval((ReadableInstant)startDate, (ReadableInstant)endDate))).granularity(Granularities.MINUTE).context((Map)ImmutableMap.of()).build();
        Assert.assertFalse((boolean)strategy.computePriority(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of((Object)((SegmentServerSelector)EasyMock.createMock(SegmentServerSelector.class)))).isPresent());
    }

    @Test
    public void testPrioritizationSegmentCountOverThreshold() {
        ThresholdBasedQueryPrioritizationStrategy strategy = new ThresholdBasedQueryPrioritizationStrategy(null, null, Integer.valueOf(2), null, this.adjustment);
        DateTime startDate = DateTimes.nowUtc().minusDays(20);
        DateTime endDate = DateTimes.nowUtc();
        TimeseriesQuery query = this.queryBuilder.intervals((List)ImmutableList.of((Object)new Interval((ReadableInstant)startDate, (ReadableInstant)endDate))).granularity(Granularities.HOUR).context((Map)ImmutableMap.of()).build();
        Assert.assertEquals((long)(-this.adjustment.intValue()), (long)((Integer)strategy.computePriority(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of((Object)((SegmentServerSelector)EasyMock.createMock(SegmentServerSelector.class)), (Object)((SegmentServerSelector)EasyMock.createMock(SegmentServerSelector.class)), (Object)((SegmentServerSelector)EasyMock.createMock(SegmentServerSelector.class)))).get()).intValue());
    }

    @Test
    public void testPrioritizationSegmentRangeWithinThreshold() {
        ThresholdBasedQueryPrioritizationStrategy strategy = new ThresholdBasedQueryPrioritizationStrategy(null, null, null, "P7D", this.adjustment);
        DateTime startDate = DateTimes.nowUtc().minusDays(1);
        DateTime endDate = DateTimes.nowUtc();
        TimeseriesQuery query = this.queryBuilder.intervals((List)ImmutableList.of((Object)new Interval((ReadableInstant)startDate, (ReadableInstant)endDate))).granularity(Granularities.MINUTE).context((Map)ImmutableMap.of()).build();
        SegmentServerSelector segmentServerSelector = (SegmentServerSelector)EasyMock.createMock(SegmentServerSelector.class);
        EasyMock.expect((Object)segmentServerSelector.getSegmentDescriptor()).andReturn((Object)new SegmentDescriptor(new Interval((ReadableInstant)startDate, (ReadableInstant)endDate), "", 0)).times(2);
        EasyMock.replay((Object[])new Object[]{segmentServerSelector});
        Assert.assertFalse((boolean)strategy.computePriority(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of((Object)segmentServerSelector)).isPresent());
    }

    @Test
    public void testPrioritizationSegmentRangeOverThreshold() {
        ThresholdBasedQueryPrioritizationStrategy strategy = new ThresholdBasedQueryPrioritizationStrategy(null, null, null, "P7D", this.adjustment);
        DateTime startDate = DateTimes.nowUtc().minusDays(20);
        DateTime endDate = DateTimes.nowUtc();
        TimeseriesQuery query = this.queryBuilder.intervals((List)ImmutableList.of((Object)new Interval((ReadableInstant)startDate, (ReadableInstant)endDate))).granularity(Granularities.HOUR).context((Map)ImmutableMap.of()).build();
        SegmentServerSelector segmentServerSelector = (SegmentServerSelector)EasyMock.createMock(SegmentServerSelector.class);
        EasyMock.expect((Object)segmentServerSelector.getSegmentDescriptor()).andReturn((Object)new SegmentDescriptor(new Interval((ReadableInstant)startDate, (ReadableInstant)endDate), "", 0)).times(2);
        EasyMock.replay((Object[])new Object[]{segmentServerSelector});
        Assert.assertEquals((long)(-this.adjustment.intValue()), (long)((Integer)strategy.computePriority(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of((Object)segmentServerSelector)).get()).intValue());
    }
}

