/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.druid.server.security.AllowHttpMethodsResourceFilter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AllowHttpMethodsResourceFilterTest {
    private static final String METHOD_ALLOWED = "METHOD_ALLOWED";
    private static final String METHOD_NOT_ALLOWED = "METHOD_NOT_ALLOWED";
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private FilterChain filterChain;
    private AllowHttpMethodsResourceFilter target;

    @Before
    public void setUp() {
        this.target = new AllowHttpMethodsResourceFilter((List)ImmutableList.of((Object)METHOD_ALLOWED));
    }

    @Test
    public void testDoFilterMethodNotAllowedShouldReturnAnError() throws IOException, ServletException {
        ((HttpServletRequest)Mockito.doReturn((Object)METHOD_NOT_ALLOWED).when((Object)this.request)).getMethod();
        this.target.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).sendError(405);
    }

    @Test
    public void testDoFilterMethodAllowedShouldFilter() throws IOException, ServletException {
        ((HttpServletRequest)Mockito.doReturn((Object)METHOD_ALLOWED).when((Object)this.request)).getMethod();
        this.target.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
    }

    @Test
    public void testDoFilterSupportedHttpMethodsShouldFilter() throws IOException, ServletException {
        for (String method : AllowHttpMethodsResourceFilter.SUPPORTED_METHODS) {
            ((HttpServletRequest)Mockito.doReturn((Object)method).when((Object)this.request)).getMethod();
            this.target.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
            ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
            Mockito.clearInvocations((Object[])new FilterChain[]{this.filterChain});
        }
    }
}

