/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.query.CloneQueryMode;
import org.apache.druid.query.LocatedSegmentDescriptor;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.timeline.TimelineLookup;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.Interval;

public class ServerViewUtil {
    public static List<LocatedSegmentDescriptor> getTargetLocations(TimelineServerView serverView, String datasource, List<Interval> intervals, int numCandidates, CloneQueryMode cloneQueryMode) {
        return ServerViewUtil.getTargetLocations(serverView, new TableDataSource(datasource), intervals, numCandidates, cloneQueryMode);
    }

    public static List<LocatedSegmentDescriptor> getTargetLocations(TimelineServerView serverView, TableDataSource datasource, List<Interval> intervals, int numCandidates, CloneQueryMode cloneQueryMode) {
        Optional maybeTimeline = serverView.getTimeline(datasource);
        if (!maybeTimeline.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<LocatedSegmentDescriptor> located = new ArrayList<LocatedSegmentDescriptor>();
        for (Interval interval : intervals) {
            for (TimelineObjectHolder holder : ((TimelineLookup)maybeTimeline.get()).lookup(interval)) {
                for (PartitionChunk chunk : holder.getObject()) {
                    ServerSelector selector = (ServerSelector)chunk.getObject();
                    SegmentDescriptor descriptor = new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), chunk.getChunkNumber());
                    long size = selector.getSegment().getSize();
                    List<DruidServerMetadata> candidates = selector.getCandidates(numCandidates, cloneQueryMode);
                    located.add(new LocatedSegmentDescriptor(descriptor, size, candidates));
                }
            }
        }
        return located;
    }
}

