/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.segment.column.RowSignature;

public class DataSourceInformation {
    private final String dataSource;
    private final RowSignature rowSignature;

    @JsonCreator
    public DataSourceInformation(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="rowSignature") RowSignature rowSignature) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"'dataSource' must be nonnull");
        this.rowSignature = (RowSignature)Preconditions.checkNotNull((Object)rowSignature, (Object)"rowSignature");
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public RowSignature getRowSignature() {
        return this.rowSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceInformation that = (DataSourceInformation)o;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.rowSignature, that.rowSignature);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.rowSignature);
    }

    public String toString() {
        return "DataSourceSchema{dataSource='" + this.dataSource + "', rowSignature=" + String.valueOf(this.rowSignature) + "}";
    }
}

