/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.google.common.util.concurrent.Futures;
import java.util.Map;
import org.apache.druid.client.BrokerViewOfCoordinatorConfig;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BrokerViewOfCoordinatorConfigTest {
    private BrokerViewOfCoordinatorConfig target;
    private CoordinatorClient coordinatorClient;
    private CoordinatorDynamicConfig config;

    @Before
    public void setUp() throws Exception {
        this.config = CoordinatorDynamicConfig.builder().withCloneServers(Map.of("host1", "host2")).build();
        this.coordinatorClient = (CoordinatorClient)Mockito.mock(CoordinatorClient.class);
        Mockito.when((Object)this.coordinatorClient.getCoordinatorDynamicConfig()).thenReturn((Object)Futures.immediateFuture((Object)this.config));
        this.target = new BrokerViewOfCoordinatorConfig(this.coordinatorClient);
    }

    @Test
    public void testFetchesConfigOnStartup() {
        this.target.start();
        ((CoordinatorClient)Mockito.verify((Object)this.coordinatorClient, (VerificationMode)Mockito.times((int)1))).getCoordinatorDynamicConfig();
        Assert.assertEquals((Object)this.config, (Object)this.target.getDynamicConfig());
    }
}

