/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.test.utils.ImmutableDruidDataSourceTestUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ImmutableDruidDataSourceTest {
    private static final DataSegment TEST_SEGMENT = DataSegment.builder((SegmentId)SegmentId.of((String)"test", (Interval)Intervals.of((String)"2017/2018"), (String)"version", null)).dimensions((List)ImmutableList.of((Object)"dim1", (Object)"dim2")).metrics((List)ImmutableList.of((Object)"met1", (Object)"met2")).projections((List)ImmutableList.of((Object)"proj1", (Object)"proj2")).binaryVersion(Integer.valueOf(1)).size(100L).build();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws IOException {
        ImmutableDruidDataSource dataSource = ImmutableDruidDataSourceTest.getImmutableDruidDataSource(TEST_SEGMENT);
        ObjectMapper objectMapper = new DefaultObjectMapper().setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT));
        String json = objectMapper.writeValueAsString((Object)dataSource);
        ImmutableDruidDataSourceTestUtils.assertEquals(dataSource, (ImmutableDruidDataSource)objectMapper.readValue(json, ImmutableDruidDataSource.class));
    }

    @Test
    public void testEqualsMethodThrowsUnsupportedOperationException() {
        ImmutableDruidDataSource dataSource1 = ImmutableDruidDataSourceTest.getImmutableDruidDataSource(TEST_SEGMENT);
        ImmutableDruidDataSource dataSource2 = ImmutableDruidDataSourceTest.getImmutableDruidDataSource(TEST_SEGMENT);
        Assert.assertThrows((String)"ImmutableDruidDataSource shouldn't be used as the key in containers", UnsupportedOperationException.class, () -> dataSource1.equals((Object)dataSource2));
    }

    private static ImmutableDruidDataSource getImmutableDruidDataSource(DataSegment segment1) {
        return new ImmutableDruidDataSource("test", (Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2"), (Map)ImmutableSortedMap.of((Comparable)segment1.getId(), (Object)segment1));
    }

    @Test
    public void testHashCodeMethodThrowsUnsupportedOperationException() {
        ImmutableDruidDataSource dataSource = ImmutableDruidDataSourceTest.getImmutableDruidDataSource(TEST_SEGMENT);
        Assert.assertThrows((String)"ImmutableDruidDataSource shouldn't be used as the key in containers", UnsupportedOperationException.class, () -> ((ImmutableDruidDataSource)dataSource).hashCode());
    }
}

