/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.druid.client.cache.BackgroundCachePopulator;
import org.apache.druid.client.cache.ByteCountingLRUMap;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.ForegroundCachePopulator;
import org.apache.druid.client.cache.MapCache;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CachePopulatorTest {
    private final ExecutorService exec = Execs.multiThreaded((int)2, (String)"cache-populator-test-%d");
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Cache cache = new MapCache(new ByteCountingLRUMap(Long.MAX_VALUE));
    private final CachePopulatorStats stats = new CachePopulatorStats();

    @After
    public void tearDown() {
        this.exec.shutdownNow();
    }

    @Test
    public void testForegroundPopulator() {
        ForegroundCachePopulator populator = new ForegroundCachePopulator(this.objectMapper, this.stats, -1L);
        ImmutableList strings = ImmutableList.of((Object)"foo", (Object)"bar");
        Assert.assertEquals((Object)strings, this.wrapAndReturn((CachePopulator)populator, CachePopulatorTest.makeKey(1), (List<String>)strings));
        Assert.assertEquals((Object)strings, this.readFromCache(CachePopulatorTest.makeKey(1)));
        Assert.assertEquals((long)1L, (long)this.stats.snapshot().getNumOk());
        Assert.assertEquals((long)0L, (long)this.stats.snapshot().getNumError());
        Assert.assertEquals((long)0L, (long)this.stats.snapshot().getNumOversized());
    }

    @Test
    public void testForegroundPopulatorMaxEntrySize() {
        ForegroundCachePopulator populator = new ForegroundCachePopulator(this.objectMapper, this.stats, 30L);
        ImmutableList strings = ImmutableList.of((Object)"foo", (Object)"bar");
        ImmutableList strings2 = ImmutableList.of((Object)"foo", (Object)"baralararararararaarararararaa");
        Assert.assertEquals((Object)strings, this.wrapAndReturn((CachePopulator)populator, CachePopulatorTest.makeKey(1), (List<String>)strings));
        Assert.assertEquals((Object)strings, this.readFromCache(CachePopulatorTest.makeKey(1)));
        Assert.assertEquals((Object)strings2, this.wrapAndReturn((CachePopulator)populator, CachePopulatorTest.makeKey(2), (List<String>)strings2));
        Assert.assertNull(this.readFromCache(CachePopulatorTest.makeKey(2)));
        Assert.assertEquals((long)1L, (long)this.stats.snapshot().getNumOk());
        Assert.assertEquals((long)0L, (long)this.stats.snapshot().getNumError());
        Assert.assertEquals((long)1L, (long)this.stats.snapshot().getNumOversized());
    }

    @Test(timeout=60000L)
    public void testBackgroundPopulator() throws InterruptedException {
        BackgroundCachePopulator populator = new BackgroundCachePopulator(this.exec, this.objectMapper, this.stats, -1L);
        ImmutableList strings = ImmutableList.of((Object)"foo", (Object)"bar");
        Assert.assertEquals((Object)strings, this.wrapAndReturn((CachePopulator)populator, CachePopulatorTest.makeKey(1), (List<String>)strings));
        while (this.cache.getStats().getNumEntries() < 1L) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)strings, this.readFromCache(CachePopulatorTest.makeKey(1)));
        Assert.assertEquals((long)1L, (long)this.stats.snapshot().getNumOk());
        Assert.assertEquals((long)0L, (long)this.stats.snapshot().getNumError());
        Assert.assertEquals((long)0L, (long)this.stats.snapshot().getNumOversized());
    }

    @Test(timeout=60000L)
    public void testBackgroundPopulatorMaxEntrySize() throws InterruptedException {
        BackgroundCachePopulator populator = new BackgroundCachePopulator(this.exec, this.objectMapper, this.stats, 30L);
        ImmutableList strings = ImmutableList.of((Object)"foo", (Object)"bar");
        ImmutableList strings2 = ImmutableList.of((Object)"foo", (Object)"baralararararararaarararararaa");
        Assert.assertEquals((Object)strings, this.wrapAndReturn((CachePopulator)populator, CachePopulatorTest.makeKey(1), (List<String>)strings));
        Assert.assertEquals((Object)strings2, this.wrapAndReturn((CachePopulator)populator, CachePopulatorTest.makeKey(2), (List<String>)strings2));
        while (this.cache.getStats().getNumEntries() < 1L || this.stats.snapshot().getNumOversized() < 1L) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)strings, this.readFromCache(CachePopulatorTest.makeKey(1)));
        Assert.assertNull(this.readFromCache(CachePopulatorTest.makeKey(2)));
        Assert.assertEquals((long)1L, (long)this.stats.snapshot().getNumOk());
        Assert.assertEquals((long)0L, (long)this.stats.snapshot().getNumError());
        Assert.assertEquals((long)1L, (long)this.stats.snapshot().getNumOversized());
    }

    private static Cache.NamedKey makeKey(int n) {
        return new Cache.NamedKey("test", Ints.toByteArray((int)n));
    }

    private List<String> wrapAndReturn(CachePopulator populator, Cache.NamedKey key, List<String> strings) {
        return populator.wrap(Sequences.simple(strings), s -> ImmutableMap.of((Object)"s", (Object)s), this.cache, key).toList();
    }

    private List<String> readFromCache(Cache.NamedKey key) {
        List<String> list;
        block9: {
            byte[] bytes = this.cache.get(key);
            if (bytes == null) {
                return null;
            }
            MappingIterator iterator = this.objectMapper.readValues(this.objectMapper.getFactory().createParser(bytes), JacksonUtils.TYPE_REFERENCE_MAP_STRING_STRING);
            try {
                ArrayList retVal = new ArrayList();
                Iterators.addAll(retVal, (Iterator)iterator);
                list = retVal.stream().map(m -> (String)m.get("s")).collect(Collectors.toList());
                if (iterator == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (iterator != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            iterator.close();
        }
        return list;
    }
}

