/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.coordinator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Injector;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.druid.client.BootstrapSegmentsResponse;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.coordinator.CoordinatorClientImpl;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.initialization.CoreInjectorBuilder;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.MapLookupExtractorFactory;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.rpc.MockServiceClient;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.DataSourceInformation;
import org.apache.druid.server.compaction.CompactionStatusResponse;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.PruneLoadSpec;
import org.apache.druid.timeline.SegmentStatusInCluster;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoordinatorClientImplTest {
    private ObjectMapper jsonMapper;
    private MockServiceClient serviceClient;
    private CoordinatorClient coordinatorClient;
    private static final DataSegment SEGMENT1 = DataSegment.builder().dataSource("xyz").interval(Intervals.of((String)"1000/2000")).version("1").loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"loc", (Object)"foo")).shardSpec((ShardSpec)new NumberedShardSpec(0, 1)).size(1L).build();
    private static final DataSegment SEGMENT2 = DataSegment.builder().dataSource("xyz").interval(Intervals.of((String)"2000/3000")).version("1").loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"loc", (Object)"bar")).shardSpec((ShardSpec)new NumberedShardSpec(0, 1)).size(1L).build();
    private static final DataSegment SEGMENT3 = DataSegment.builder().dataSource("abc").interval(Intervals.of((String)"2000/3000")).version("1").loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"loc", (Object)"bar")).shardSpec((ShardSpec)new NumberedShardSpec(0, 1)).size(1L).build();

    @Before
    public void setup() {
        this.jsonMapper = new DefaultObjectMapper();
        this.jsonMapper.setInjectableValues((InjectableValues)new InjectableValues.Std((Map)ImmutableMap.of((Object)DataSegment.PruneSpecsHolder.class.getName(), (Object)DataSegment.PruneSpecsHolder.DEFAULT)));
        this.jsonMapper.registerSubtypes(new Class[]{MapLookupExtractorFactory.class});
        this.serviceClient = new MockServiceClient();
        this.coordinatorClient = new CoordinatorClientImpl((ServiceClient)this.serviceClient, this.jsonMapper);
    }

    @After
    public void tearDown() {
        this.serviceClient.verify();
    }

    @Test
    public void test_isHandoffComplete() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/datasources/xyz/handoffComplete?interval=2000-01-01T00%3A00%3A00.000Z%2F3000-01-01T00%3A00%3A00.000Z&partitionNumber=2&version=1"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), StringUtils.toUtf8((String)"true"));
        Assert.assertEquals((Object)true, (Object)this.coordinatorClient.isHandoffComplete("xyz", new SegmentDescriptor(Intervals.of((String)"2000/3000"), "1", 2)).get());
    }

    @Test
    public void test_fetchUsedSegment() throws Exception {
        DataSegment segment = DataSegment.builder().dataSource("xyz").interval(Intervals.of((String)"2000/3000")).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 1)).size(1L).build();
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/metadata/datasources/xyz/segments/def?includeUnused=false"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)segment));
        Assert.assertEquals((Object)segment, (Object)this.coordinatorClient.fetchSegment("xyz", "def", false).get());
    }

    @Test
    public void test_fetchSegment() throws Exception {
        DataSegment segment = DataSegment.builder().dataSource("xyz").interval(Intervals.of((String)"2000/3000")).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 1)).size(1L).build();
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/metadata/datasources/xyz/segments/def?includeUnused=true"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)segment));
        Assert.assertEquals((Object)segment, (Object)this.coordinatorClient.fetchSegment("xyz", "def", true).get());
    }

    @Test
    public void test_fetchUsedSegments() throws Exception {
        List<Interval> intervals = Collections.singletonList(Intervals.of((String)"2000/3000"));
        DataSegment segment = DataSegment.builder().dataSource("xyz").interval(intervals.get(0)).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 1)).size(1L).build();
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.POST, "/druid/coordinator/v1/metadata/datasources/xyz/segments?full").jsonContent(this.jsonMapper, intervals), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(Collections.singletonList(segment)));
        Assert.assertEquals(Collections.singletonList(segment), (Object)this.coordinatorClient.fetchUsedSegments("xyz", intervals).get());
    }

    @Test
    public void test_fetchBootstrapSegments() throws Exception {
        ImmutableList expectedSegments = ImmutableList.of((Object)SEGMENT1, (Object)SEGMENT2);
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.POST, "/druid/coordinator/v1/metadata/bootstrapSegments"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)expectedSegments));
        ListenableFuture response = this.coordinatorClient.fetchBootstrapSegments();
        Assert.assertNotNull((Object)response);
        ImmutableList observedDataSegments = ImmutableList.copyOf((Iterator)((BootstrapSegmentsResponse)response.get()).getIterator());
        for (int idx = 0; idx < expectedSegments.size(); ++idx) {
            Assert.assertEquals((Object)((DataSegment)expectedSegments.get(idx)).getLoadSpec(), (Object)((DataSegment)observedDataSegments.get(idx)).getLoadSpec());
        }
    }

    @Test
    public void test_fetchBootstrapSegmentsAreLoadableWhenPruneLoadSpecIsEnabled() throws Exception {
        ImmutableList expectedSegments = ImmutableList.of((Object)SEGMENT1, (Object)SEGMENT2);
        Injector injector = new CoreInjectorBuilder(new StartupInjectorBuilder().build()).addModule(binder -> binder.bindConstant().annotatedWith(PruneLoadSpec.class).to(true)).build();
        ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
        CoordinatorClientImpl coordinatorClient = new CoordinatorClientImpl((ServiceClient)this.serviceClient, objectMapper);
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.POST, "/druid/coordinator/v1/metadata/bootstrapSegments"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), objectMapper.writeValueAsBytes((Object)expectedSegments));
        ListenableFuture response = coordinatorClient.fetchBootstrapSegments();
        Assert.assertNotNull((Object)response);
        ImmutableList observedDataSegments = ImmutableList.copyOf((Iterator)((BootstrapSegmentsResponse)response.get()).getIterator());
        Assert.assertEquals((Object)expectedSegments, (Object)observedDataSegments);
        for (int idx = 0; idx < expectedSegments.size(); ++idx) {
            Assert.assertEquals((Object)((DataSegment)expectedSegments.get(idx)).getLoadSpec(), (Object)((DataSegment)observedDataSegments.get(idx)).getLoadSpec());
        }
    }

    @Test
    public void test_fetchEmptyBootstrapSegments() throws Exception {
        ImmutableList segments = ImmutableList.of();
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.POST, "/druid/coordinator/v1/metadata/bootstrapSegments"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)segments));
        ListenableFuture response = this.coordinatorClient.fetchBootstrapSegments();
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)segments, (Object)ImmutableList.copyOf((Iterator)((BootstrapSegmentsResponse)response.get()).getIterator()));
    }

    @Test
    public void test_fetchDataSourceInformation() throws Exception {
        String foo = "foo";
        DataSourceInformation fooInfo = new DataSourceInformation("foo", RowSignature.builder().add("d1", ColumnType.FLOAT).add("d2", ColumnType.DOUBLE).build());
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.POST, "/druid/coordinator/v1/metadata/dataSourceInformation").jsonContent(this.jsonMapper, Collections.singletonList(foo)), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(Collections.singletonList(fooInfo)));
        Assert.assertEquals(Collections.singletonList(fooInfo), (Object)this.coordinatorClient.fetchDataSourceInformation(Collections.singleton(foo)).get());
    }

    @Test
    public void test_fetchServerViewSegments() throws Exception {
        ImmutableList intervals = ImmutableList.of((Object)Intervals.of((String)"2001/2002"), (Object)Intervals.of((String)"2501/2502"));
        ImmutableSet serverMetadataSet = ImmutableSet.of((Object)new DruidServerMetadata("TEST_SERVER", "testhost:9092", null, 1L, ServerType.INDEXER_EXECUTOR, "tier1", 0));
        ImmutableSegmentLoadInfo immutableSegmentLoadInfo1 = new ImmutableSegmentLoadInfo(DataSegment.builder().dataSource("xyz").interval((Interval)intervals.get(0)).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 1)).size(1L).build(), (Set)serverMetadataSet);
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/datasources/xyz/intervals/2001-01-01T00:00:00.000Z_2002-01-01T00:00:00.000Z/serverview?full"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(Collections.singletonList(immutableSegmentLoadInfo1)));
        ImmutableSegmentLoadInfo immutableSegmentLoadInfo2 = new ImmutableSegmentLoadInfo(DataSegment.builder().dataSource("xyz").interval((Interval)intervals.get(1)).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 1)).size(1L).build(), (Set)serverMetadataSet);
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/datasources/xyz/intervals/2501-01-01T00:00:00.000Z_2502-01-01T00:00:00.000Z/serverview?full"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(Collections.singletonList(immutableSegmentLoadInfo2)));
        ImmutableList segmentLoadInfoList = ImmutableList.of((Object)immutableSegmentLoadInfo1, (Object)immutableSegmentLoadInfo2);
        Assert.assertEquals((Object)segmentLoadInfoList, (Object)this.coordinatorClient.fetchServerViewSegments("xyz", (List)intervals));
    }

    @Test
    public void test_getCompactionSnapshots_nullDataSource() throws JsonProcessingException, ExecutionException, InterruptedException {
        List<AutoCompactionSnapshot> compactionSnapshots = List.of(AutoCompactionSnapshot.builder((String)"ds1").withStatus(AutoCompactionSnapshot.ScheduleStatus.RUNNING).build(), AutoCompactionSnapshot.builder((String)"ds2").withStatus(AutoCompactionSnapshot.ScheduleStatus.NOT_ENABLED).build());
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/compaction/status"), HttpResponseStatus.OK, Map.of(), DefaultObjectMapper.INSTANCE.writeValueAsBytes((Object)new CompactionStatusResponse(compactionSnapshots)));
        Assert.assertEquals((Object)new CompactionStatusResponse(compactionSnapshots), (Object)this.coordinatorClient.getCompactionSnapshots(null).get());
    }

    @Test
    public void test_getCompactionSnapshots_nonNullDataSource() throws Exception {
        List<AutoCompactionSnapshot> compactionSnapshots = List.of(AutoCompactionSnapshot.builder((String)"ds1").build());
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/compaction/status?dataSource=ds1"), HttpResponseStatus.OK, Map.of(), DefaultObjectMapper.INSTANCE.writeValueAsBytes((Object)new CompactionStatusResponse(compactionSnapshots)));
        Assert.assertEquals((Object)new CompactionStatusResponse(compactionSnapshots), (Object)this.coordinatorClient.getCompactionSnapshots("ds1").get());
    }

    @Test
    public void test_getCoordinatorDynamicConfig() throws Exception {
        CoordinatorDynamicConfig config = CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(105).withReplicantLifetime(500).withReplicationThrottleLimit(5).build();
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/config"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), DefaultObjectMapper.INSTANCE.writeValueAsBytes((Object)config));
        Assert.assertEquals((Object)config, (Object)this.coordinatorClient.getCoordinatorDynamicConfig().get());
    }

    @Test
    public void test_updateCoordinatorDynamicConfig() throws Exception {
        CoordinatorDynamicConfig config = CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(105).withReplicantLifetime(500).withReplicationThrottleLimit(5).build();
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.POST, "/druid/coordinator/v1/config").jsonContent(this.jsonMapper, (Object)config), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), DefaultObjectMapper.INSTANCE.writeValueAsBytes(null));
        Assert.assertNull((Object)this.coordinatorClient.updateCoordinatorDynamicConfig(config).get());
    }

    @Test
    public void test_updateAllLookups_withEmptyLookup() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.POST, "/druid/coordinator/v1/lookups/config").jsonContent(this.jsonMapper, Map.of()), HttpResponseStatus.OK, Map.of("Content-Type", "application/json"), DefaultObjectMapper.INSTANCE.writeValueAsBytes(null));
        Assert.assertNull((Object)this.coordinatorClient.updateAllLookups(Map.of()).get());
    }

    @Test
    public void test_fetchLookupsForTierSync_detailedEnabled() throws Exception {
        MapLookupExtractorFactory lookupData = new MapLookupExtractorFactory(Map.of("77483", "United States", "77484", "India"), true);
        LookupExtractorFactoryContainer lookupDataContainer = new LookupExtractorFactoryContainer("v0", (LookupExtractorFactory)lookupData);
        Map<String, LookupExtractorFactoryContainer> lookups = Map.of("default_tier", lookupDataContainer);
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/default_tier?detailed=true"), HttpResponseStatus.OK, Map.of("Content-Type", "application/json"), DefaultObjectMapper.INSTANCE.writeValueAsBytes(lookups));
        Assert.assertEquals(lookups, (Object)this.coordinatorClient.fetchLookupsForTierSync("default_tier"));
    }

    @Test
    public void test_fetchAllUsedSegmentsWithOvershadowedStatus_includeRealtime() throws JsonProcessingException {
        ImmutableList segments = ImmutableList.of((Object)SEGMENT1, (Object)SEGMENT2, (Object)SEGMENT3);
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/metadata/segments?includeOvershadowedStatus&includeRealtimeSegments"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)segments));
        CloseableIterator iterator = (CloseableIterator)FutureUtils.getUnchecked((ListenableFuture)this.coordinatorClient.fetchAllUsedSegmentsWithOvershadowedStatus(null, true), (boolean)true);
        ArrayList<SegmentStatusInCluster> actualSegments = new ArrayList<SegmentStatusInCluster>();
        while (iterator.hasNext()) {
            actualSegments.add((SegmentStatusInCluster)iterator.next());
        }
        Assert.assertEquals((Object)segments, actualSegments.stream().map(SegmentStatusInCluster::getDataSegment).collect(ImmutableList.toImmutableList()));
    }

    @Test
    public void test_fetchAllUsedSegmentsWithOvershadowedStatus_noParams() throws JsonProcessingException {
        ImmutableList segments = ImmutableList.of((Object)SEGMENT1, (Object)SEGMENT2, (Object)SEGMENT3);
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/metadata/segments?includeOvershadowedStatus"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)segments));
        CloseableIterator iterator = (CloseableIterator)FutureUtils.getUnchecked((ListenableFuture)this.coordinatorClient.fetchAllUsedSegmentsWithOvershadowedStatus(null, false), (boolean)true);
        ArrayList<SegmentStatusInCluster> actualSegments = new ArrayList<SegmentStatusInCluster>();
        while (iterator.hasNext()) {
            actualSegments.add((SegmentStatusInCluster)iterator.next());
        }
        Assert.assertEquals((Object)segments, actualSegments.stream().map(SegmentStatusInCluster::getDataSegment).collect(ImmutableList.toImmutableList()));
    }

    @Test
    public void test_fetchAllUsedSegmentsWithOvershadowedStatus_filterByDataSource() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/metadata/segments?includeOvershadowedStatus&includeRealtimeSegments&datasources=abc"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)ImmutableList.of((Object)SEGMENT3)));
        CloseableIterator iterator = (CloseableIterator)FutureUtils.getUnchecked((ListenableFuture)this.coordinatorClient.fetchAllUsedSegmentsWithOvershadowedStatus(Set.of("abc"), true), (boolean)true);
        ArrayList<SegmentStatusInCluster> actualSegments = new ArrayList<SegmentStatusInCluster>();
        while (iterator.hasNext()) {
            actualSegments.add((SegmentStatusInCluster)iterator.next());
        }
        Assert.assertEquals(List.of(SEGMENT3), actualSegments.stream().map(SegmentStatusInCluster::getDataSegment).collect(Collectors.toList()));
    }

    @Test
    public void test_fetchAllUsedSegmentsWithOvershadowedStatus_filterByDataSources() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/metadata/segments?includeOvershadowedStatus&includeRealtimeSegments&datasources=xyz&datasources=abc"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)ImmutableList.of((Object)SEGMENT1, (Object)SEGMENT2, (Object)SEGMENT3)));
        LinkedHashSet<String> dataSources = new LinkedHashSet<String>(List.of("xyz", "abc"));
        CloseableIterator iterator = (CloseableIterator)FutureUtils.getUnchecked((ListenableFuture)this.coordinatorClient.fetchAllUsedSegmentsWithOvershadowedStatus(dataSources, true), (boolean)true);
        ArrayList<SegmentStatusInCluster> actualSegments = new ArrayList<SegmentStatusInCluster>();
        while (iterator.hasNext()) {
            actualSegments.add((SegmentStatusInCluster)iterator.next());
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)SEGMENT1, (Object)SEGMENT2, (Object)SEGMENT3), actualSegments.stream().map(SegmentStatusInCluster::getDataSegment).collect(ImmutableList.toImmutableList()));
    }

    @Test
    public void test_fetchAllUsedSegmentsWithOvershadowedStatus_filterByDataSourceOnly() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/metadata/segments?includeOvershadowedStatus&datasources=abc"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(List.of(SEGMENT3)));
        CloseableIterator iterator = (CloseableIterator)FutureUtils.getUnchecked((ListenableFuture)this.coordinatorClient.fetchAllUsedSegmentsWithOvershadowedStatus(Set.of("abc"), false), (boolean)true);
        ArrayList<SegmentStatusInCluster> actualSegments = new ArrayList<SegmentStatusInCluster>();
        while (iterator.hasNext()) {
            actualSegments.add((SegmentStatusInCluster)iterator.next());
        }
        Assert.assertEquals(List.of(SEGMENT3), actualSegments.stream().map(SegmentStatusInCluster::getDataSegment).collect(ImmutableList.toImmutableList()));
    }

    @Test
    public void test_getRulesForAllDatasources() throws Exception {
        ImmutableMap rules = ImmutableMap.of((Object)"xyz", List.of(new IntervalLoadRule(Intervals.of((String)"2025-01-01/2025-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2), null), new IntervalLoadRule(Intervals.of((String)"2025-02-01/2025-03-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2), null)));
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/rules"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)rules));
        Assert.assertEquals((Object)rules, (Object)this.coordinatorClient.getRulesForAllDatasources().get());
    }

    @Test
    public void test_findCurrentLeader() throws Exception {
        String leaderUrl = "http://localhost:8081";
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/leader"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"text/plain"), StringUtils.toUtf8((String)leaderUrl));
        Assert.assertEquals((Object)leaderUrl, (Object)((URI)FutureUtils.getUnchecked((ListenableFuture)this.coordinatorClient.findCurrentLeader(), (boolean)true)).toString());
    }

    @Test
    public void test_findCurrentLeader_invalidUrl() {
        String invalidLeaderUrl = "{{1234invalidUrl";
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/leader"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"text/plain"), StringUtils.toUtf8((String)invalidLeaderUrl));
        Assert.assertThrows(RuntimeException.class, () -> FutureUtils.getUnchecked((ListenableFuture)this.coordinatorClient.findCurrentLeader(), (boolean)true));
    }

    @Test
    public void test_findCurrentLeader_runtimeException() {
        this.serviceClient.expectAndThrow(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/leader"), new RuntimeException("Simulated runtime error"));
        Assert.assertThrows(RuntimeException.class, () -> FutureUtils.getUnchecked((ListenableFuture)this.coordinatorClient.findCurrentLeader(), (boolean)true));
    }

    @Test
    public void test_findCurrentLeader_httpResponseException() {
        this.serviceClient.expectAndThrow(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/leader"), (Throwable)new HttpResponseException(new StringFullResponseHolder((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND), StandardCharsets.UTF_8)));
        try {
            FutureUtils.getUnchecked((ListenableFuture)this.coordinatorClient.findCurrentLeader(), (boolean)true);
        }
        catch (Exception e) {
            Throwable throwable = Throwables.getRootCause((Throwable)e);
            Assert.assertTrue((boolean)(throwable instanceof HttpResponseException));
        }
    }

    @Test
    public void test_updateRulesForDatasource() throws Exception {
        List<IntervalLoadRule> rules = List.of(new IntervalLoadRule(Intervals.of((String)"2025-01-01/2025-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2), null));
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.POST, "/druid/coordinator/v1/rules/xyz").jsonContent(this.jsonMapper, rules), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(null));
        Assert.assertNull((Object)this.coordinatorClient.updateRulesForDatasource("xyz", rules).get());
    }
}

