/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.selector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.druid.client.DirectDruidClient;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.selector.ConnectionCountServerSelectorStrategy;
import org.apache.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.druid.client.selector.HistoricalFilter;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.CloneQueryMode;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionCountServerSelectorStrategyTest {
    @Test
    public void testDifferentConnectionCount() {
        QueryableDruidServer s1 = this.mockServer("test1", 2);
        QueryableDruidServer s2 = this.mockServer("test2", 1);
        QueryableDruidServer s3 = this.mockServer("test3", 4);
        ServerSelector serverSelector = this.initSelector(s1, s2, s3);
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)s2, (Object)serverSelector.pick(null, CloneQueryMode.EXCLUDECLONES));
        }
    }

    @Test
    public void testBalancerTieBreaking() {
        QueryableDruidServer s1 = this.mockServer("test1", 100);
        QueryableDruidServer s2 = this.mockServer("test2", 100);
        ServerSelector serverSelector = this.initSelector(s1, s2);
        HashSet<String> pickedServers = new HashSet<String>();
        for (int i = 0; i < 100; ++i) {
            pickedServers.add(serverSelector.pick(null, CloneQueryMode.EXCLUDECLONES).getServer().getName());
        }
        Assert.assertTrue((String)"Multiple servers should be selected when the number of connections is equal.", (pickedServers.size() > 1 ? 1 : 0) != 0);
    }

    private QueryableDruidServer mockServer(String name, int openConnections) {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        EasyMock.expect((Object)client.getNumOpenConnections()).andReturn((Object)openConnections).anyTimes();
        EasyMock.replay((Object[])new Object[]{client});
        return new QueryableDruidServer(new DruidServer(name, "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), (QueryRunner)client);
    }

    private ServerSelector initSelector(QueryableDruidServer ... servers) {
        HighestPriorityTierSelectorStrategy strategy = new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy());
        ServerSelector selector = new ServerSelector(new DataSegment("test", Intervals.of((String)"2025-01-01/2025-01-02"), DateTimes.of((String)"2025-01-01").toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(0), 0L), (TierSelectorStrategy)strategy, HistoricalFilter.IDENTITY_FILTER);
        ArrayList<QueryableDruidServer> serverList = new ArrayList<QueryableDruidServer>(Arrays.asList(servers));
        Collections.shuffle(serverList);
        for (QueryableDruidServer server : serverList) {
            selector.addServerAndUpdateSegment(server, selector.getSegment());
        }
        return selector;
    }
}

